/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector;

import com.asbestosstar.crashdetector.App;
import com.asbestosstar.crashdetector.CargadoresComun;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.Transformaciones;
import featurecreep.loader.FCLoaderBasic;
import java.io.File;
import java.lang.instrument.Instrumentation;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleLoader;

public class CrashDetectorFCMC {
    public static void premain(String args, Instrumentation instrument) {
        if (CrashDetectorFCMC.FCExiste()) {
            if (CrashDetectorFCMC.clase_existe("dangerzone.BaseMod")) {
                Statics.APP = App.DANGERZONE;
            }
            Transformaciones.init();
            CargadoresComun.init(CrashDetectorFCMC.obtenerPathsDeMods(), CargadoresComun.CDOrigin.FEATURECREEP);
        }
        instrument.addTransformer(new Transformaciones());
    }

    public static boolean FCExiste() {
        return CrashDetectorFCMC.clase_existe("featurecreep.loader.FCLoaderBasic");
    }

    @Nullable
    public static FCLoaderBasic obtenerFCLoaderBasic() {
        if (!CrashDetectorFCMC.FCExiste()) {
            return null;
        }
        ClassLoader cl = CrashDetectorFCMC.class.getClassLoader();
        if (cl instanceof ModuleClassLoader) {
            ModuleClassLoader mcl = (ModuleClassLoader)cl;
            ModuleLoader ml = mcl.getModule().getModuleLoader();
            if (ml instanceof FCLoaderBasic) {
                return (FCLoaderBasic)ml;
            }
            return null;
        }
        return null;
    }

    public static List<Path> obtenerPathsDeMods() {
        ArrayList<Path> paths = new ArrayList<Path>();
        FCLoaderBasic fc = CrashDetectorFCMC.obtenerFCLoaderBasic();
        if (fc != null) {
            for (Path path : fc.getCombindedModulePKZipLocations()) {
                paths.add(path);
            }
        }
        if (paths.isEmpty()) {
            paths.add(new File("mods/").toPath());
        }
        return paths;
    }

    public static boolean clase_existe(String clase) {
        try {
            Class.forName(clase);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

