/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector;

import com.asbestosstar.crashdetector.ConfigMundial;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.gui.tipos.consola.ConsolaDesarrolladorGUI;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;

public class CrashDetectorLogger {
    public static final String LOG_FILE_PATH = Statics.carpeta.resolve("log.txt").toString();
    public static final String LOG_ERR_FILE_PATH = Statics.carpeta.resolve("log_err.txt").toString();
    private static final List<String> buffer = new ArrayList<String>();

    public static synchronized void log(String message) {
        String linea = CrashDetectorLogger.getTimestamp() + " - " + message;
        try {
            Path logDir = Statics.carpeta;
            if (!Files.exists(logDir, new LinkOption[0])) {
                Files.createDirectories(logDir, new FileAttribute[0]);
            }
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(LOG_FILE_PATH, true));){
                writer.write(linea);
                writer.newLine();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        CrashDetectorLogger.enviarALaConsola(linea);
    }

    public static void logException(Throwable throwable) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            CrashDetectorLogger.log("EXCEPTION: " + sw.toString());
        }
        catch (Exception e) {
            System.err.println("Failed to log exception: " + e.getMessage());
        }
    }

    private static synchronized void enviarALaConsola(String linea) {
        if (!ConfigMundial.obtenerInstancia().obtenerConsolaDesarrollo()) {
            return;
        }
        ConsolaDesarrolladorGUI consola = CrashDetectorLogger.consola();
        if (consola == null) {
            buffer.add(linea);
            return;
        }
        if (!buffer.isEmpty()) {
            for (String l : buffer) {
                consola.agregarLinea(l);
            }
            buffer.clear();
        }
        consola.agregarLinea(linea);
    }

    @Nullable
    public static ConsolaDesarrolladorGUI consola() {
        try {
            return (ConsolaDesarrolladorGUI)MonitorDePID.consola_des;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static String getTimestamp() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dateFormat.format(new Date());
    }
}

