/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DescargarRegistors {
    private static final Pattern PATRON_STIKKED = Pattern.compile("^(https?://[^/]+)/(view|raw)/([a-f0-9]+)$");
    private static final Pattern PATRON_MCLO_GS = Pattern.compile("^(?:https?://)?(?:mclo\\.gs|gnomebot\\.dev/paste/mclogs)/([a-zA-Z0-9]+)$");
    private static final Pattern PATRON_GIST = Pattern.compile("^(?:https?://)?gist\\.githubusercontent.com/.*$");
    private static final Pattern PATRON_MCLO_GS_API = Pattern.compile("^(?:https?://)?api\\.mclo\\.gs/1/raw/([a-zA-Z0-9]+)$");

    public static Map<String, String> descargarRegistros(List<String> urls, File carpetaDestino) throws IOException {
        HashMap<String, String> resultados = new HashMap<String, String>();
        int contadorGenerico = 1;
        if (!carpetaDestino.exists()) {
            carpetaDestino.mkdirs();
        }
        for (String url : urls) {
            try {
                String urlProcesada = DescargarRegistors.procesarURL(url);
                String contenido = DescargarRegistors.descargarContenido(urlProcesada);
                String nombreArchivo = DescargarRegistors.obtenerNombreDeURL(urlProcesada);
                if (nombreArchivo == null || nombreArchivo.isEmpty()) {
                    nombreArchivo = "registro_" + contadorGenerico++ + ".log";
                }
                File archivoDestino = new File(carpetaDestino, nombreArchivo);
                DescargarRegistors.guardarContenido(contenido, archivoDestino);
                resultados.put(nombreArchivo, contenido);
            }
            catch (IOException e) {
                System.err.println("Error descargando " + url + ": " + e.getMessage());
            }
        }
        return resultados;
    }

    private static String procesarURL(String url) {
        Matcher matcherMcloGs = PATRON_MCLO_GS.matcher(url);
        if (matcherMcloGs.matches()) {
            return "https://api.mclo.gs/1/raw/" + matcherMcloGs.group(1);
        }
        Matcher matcherStikked = PATRON_STIKKED.matcher(url);
        if (matcherStikked.matches()) {
            return matcherStikked.group(1) + "/raw/" + matcherStikked.group(3);
        }
        Matcher matcherGist = PATRON_GIST.matcher(url);
        if (matcherGist.matches()) {
            return url;
        }
        Matcher matcherMcloGsAPI = PATRON_MCLO_GS_API.matcher(url);
        if (matcherMcloGsAPI.matches()) {
            return url;
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String descargarContenido(String url) throws IOException {
        HttpURLConnection conexion = null;
        StringBuilder contenido = new StringBuilder();
        try {
            conexion = (HttpURLConnection)new URL(url).openConnection();
            conexion.setRequestMethod("GET");
            conexion.setConnectTimeout(5000);
            conexion.setReadTimeout(5000);
            if (conexion.getResponseCode() != 200) {
                throw new IOException("Error HTTP: " + conexion.getResponseCode());
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(conexion.getInputStream()));){
                String linea;
                while ((linea = reader.readLine()) != null) {
                    contenido.append(linea).append("\n");
                }
            }
        }
        finally {
            if (conexion != null) {
                conexion.disconnect();
            }
        }
        return contenido.toString();
    }

    private static String obtenerNombreDeURL(String url) {
        Matcher matcherStikked = Pattern.compile("/([a-f0-9]{12})$").matcher(url);
        if (matcherStikked.find()) {
            return "registro_stikked_" + matcherStikked.group(1) + ".log";
        }
        Matcher matcherMcloGs = Pattern.compile("([a-zA-Z0-9]{6,})$").matcher(url);
        if (matcherMcloGs.find()) {
            return "registro_mclo_gs_" + matcherMcloGs.group(1) + ".log";
        }
        Matcher matcherGist = Pattern.compile("/([^/]+)$").matcher(url);
        if (matcherGist.find()) {
            return "registro_gist_" + matcherGist.group(1) + ".log";
        }
        return null;
    }

    private static void guardarContenido(String contenido, File archivo) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(archivo);){
            fos.write(contenido.getBytes(StandardCharsets.UTF_8));
        }
    }

    public static boolean esURLSoportada(String url) {
        return PATRON_STIKKED.matcher(url).matches() || PATRON_MCLO_GS.matcher(url).matches() || PATRON_GIST.matcher(url).matches() || PATRON_MCLO_GS_API.matcher(url).matches();
    }

    public static List<File> descargarYGuardarRegistros(List<String> urls, File carpetaDestino) throws IOException {
        ArrayList<File> archivosDescargados = new ArrayList<File>();
        Map<String, String> resultados = DescargarRegistors.descargarRegistros(urls, carpetaDestino);
        for (Map.Entry<String, String> entrada : resultados.entrySet()) {
            String nombreArchivo = entrada.getKey();
            String contenido = entrada.getValue();
            File archivo = new File(carpetaDestino, nombreArchivo);
            DescargarRegistors.guardarContenido(contenido, archivo);
            archivosDescargados.add(archivo);
        }
        return archivosDescargados;
    }

    public static String convertirARaw(String url) {
        if (url.contains("/raw/") || url.contains("api.mclo.gs")) {
            return url;
        }
        if (DescargarRegistors.esURLSoportada(url)) {
            return DescargarRegistors.procesarURL(url);
        }
        return url;
    }

    public static boolean pareceRegistro(String url) {
        if (url.endsWith(".log") || url.endsWith(".txt") || url.contains("launcher_log")) {
            return true;
        }
        return DescargarRegistors.esURLSoportada(url);
    }

    public static String extraerIDRegistro(String url) {
        Matcher matcherStikked = PATRON_STIKKED.matcher(url);
        if (matcherStikked.matches()) {
            return matcherStikked.group(3);
        }
        Matcher matcherMcloGs = PATRON_MCLO_GS.matcher(url);
        if (matcherMcloGs.matches()) {
            return matcherMcloGs.group(1);
        }
        Matcher matcherGist = Pattern.compile("/([^/]+)$").matcher(url);
        if (matcherGist.find()) {
            return "gist_" + matcherGist.group(1);
        }
        return null;
    }

    public static boolean esRegistroMinecraft(String contenido) {
        return contenido.contains("Minecraft") || contenido.contains("ModLauncher") || contenido.contains("Forge") || contenido.contains("Fabric") || contenido.contains("java.lang.Throwable");
    }

    public static String obtenerTipoRegistro(String url) {
        if (PATRON_STIKKED.matcher(url).matches()) {
            return "stikked";
        }
        if (PATRON_MCLO_GS.matcher(url).matches() || PATRON_MCLO_GS_API.matcher(url).matches()) {
            return "mclo.gs";
        }
        if (PATRON_GIST.matcher(url).matches()) {
            return "gist.github.com";
        }
        return "desconocido";
    }

    public static Map<String, String> descargarRegistrosPorTipo(List<String> urls, File carpetaDestino, String tipoFiltro) throws IOException {
        Map<String, String> todosLosRegistros = DescargarRegistors.descargarRegistros(urls, carpetaDestino);
        HashMap<String, String> registrosFiltrados = new HashMap<String, String>();
        for (Map.Entry<String, String> entrada : todosLosRegistros.entrySet()) {
            String url = entrada.getKey();
            String contenido = entrada.getValue();
            if (!tipoFiltro.equals("desconocido") && !tipoFiltro.equals(DescargarRegistors.obtenerTipoRegistro(url))) continue;
            registrosFiltrados.put(url, contenido);
        }
        return registrosFiltrados;
    }

    public static List<Consola> crearConsolasDesdeRegistros(List<String> urls, File carpetaDestino) throws IOException {
        ArrayList<Consola> consolas = new ArrayList<Consola>();
        for (File archivo : DescargarRegistors.descargarYGuardarRegistros(urls, carpetaDestino)) {
            try {
                String contenido = MonitorDePID.leer_archivo(archivo.toPath());
                Consola consola = new Consola(archivo.toPath());
                consola.finalizarContenidoInyectado(contenido);
                consolas.add(consola);
            }
            catch (IOException e) {
                System.err.println("Error procesando " + archivo.getName() + ": " + e.getMessage());
            }
        }
        return consolas;
    }

    public static void descargarArchivo(String url, File destino) throws IOException {
        try (InputStream input = new URL(url).openStream();){
            Files.copy(input, destino.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new IOException("Error al descargar archivo desde " + url, e);
        }
    }
}

