/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector;

import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.MonitorDePID;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.swing.JOptionPane;

public class EliminadorDeMod {
    public static void eliminarMod(String rutaJar) {
        try {
            if (EliminadorDeMod.esArchivoFisico(rutaJar)) {
                File archivo = new File(rutaJar);
                if (!archivo.exists()) {
                    EliminadorDeMod.logError(MonitorDePID.idioma.archivo_no_encontrado() + ": " + rutaJar);
                    return;
                }
                if (archivo.isDirectory()) {
                    EliminadorDeMod.eliminarDirectorio(archivo);
                    EliminadorDeMod.logExito(MonitorDePID.idioma.directorio_eliminado() + ": " + rutaJar);
                } else if (archivo.delete()) {
                    EliminadorDeMod.logExito(MonitorDePID.idioma.jar_eliminado_exitosamente() + ": " + rutaJar);
                } else {
                    EliminadorDeMod.logError(MonitorDePID.idioma.error_al_eliminar_jar() + ": " + rutaJar);
                }
            } else {
                EliminadorDeMod.eliminarJarAnidado(rutaJar);
            }
        }
        catch (IOException e) {
            CrashDetectorLogger.logException(e);
            EliminadorDeMod.logError(MonitorDePID.idioma.error_al_eliminar_jar_anidado() + ": " + rutaJar);
        }
    }

    public static void eliminarElementoEnMod(String rutaMod, String rutaDentroMod) {
        try {
            File archivoMod = new File(rutaMod);
            if (archivoMod.isDirectory()) {
                File elemento = new File(archivoMod, rutaDentroMod);
                if (!elemento.exists()) {
                    EliminadorDeMod.logError(MonitorDePID.idioma.archivo_interno_no_encontrado() + ": " + rutaMod + " -> " + rutaDentroMod);
                    return;
                }
                if (elemento.isDirectory()) {
                    EliminadorDeMod.eliminarDirectorio(elemento);
                    EliminadorDeMod.logExito(MonitorDePID.idioma.directorio_eliminado() + ": " + rutaDentroMod);
                } else if (elemento.delete()) {
                    EliminadorDeMod.logExito(MonitorDePID.idioma.archivo_eliminado() + ": " + rutaDentroMod);
                } else {
                    EliminadorDeMod.logError(MonitorDePID.idioma.error_al_eliminar_archivo() + ": " + rutaDentroMod);
                }
                return;
            }
            if (!archivoMod.exists() || !archivoMod.getName().endsWith(".jar")) {
                EliminadorDeMod.logError(MonitorDePID.idioma.archivo_externo_no_valido() + ": " + rutaMod);
                return;
            }
            File directorioTemporal = Files.createTempDirectory("crashdetector_mod_temp_", new FileAttribute[0]).toFile();
            directorioTemporal.deleteOnExit();
            File destinoExtraido = new File(directorioTemporal, "contenido");
            destinoExtraido.mkdirs();
            EliminadorDeMod.extraerZip(archivoMod, destinoExtraido);
            File elementoInterno = new File(destinoExtraido, rutaDentroMod);
            if (!elementoInterno.exists()) {
                EliminadorDeMod.logError(MonitorDePID.idioma.archivo_interno_no_encontrado() + ": " + rutaMod + " -> " + rutaDentroMod);
                EliminadorDeMod.limpiarTemporal(directorioTemporal);
                return;
            }
            if (elementoInterno.isDirectory()) {
                EliminadorDeMod.eliminarDirectorio(elementoInterno);
            } else {
                elementoInterno.delete();
            }
            File archivoTemporal = new File(directorioTemporal, "temp.jar");
            EliminadorDeMod.empaquetarZip(destinoExtraido, archivoTemporal);
            if (archivoMod.delete() && archivoTemporal.renameTo(archivoMod)) {
                EliminadorDeMod.logExito(MonitorDePID.idioma.elemento_mod_eliminado() + ": " + rutaDentroMod);
            } else {
                EliminadorDeMod.logError(MonitorDePID.idioma.error_al_reemplazar_jar_externo() + ": " + rutaMod);
            }
            EliminadorDeMod.limpiarTemporal(directorioTemporal);
        }
        catch (IOException e) {
            CrashDetectorLogger.logException(e);
            EliminadorDeMod.logError(MonitorDePID.idioma.error_al_eliminar_elemento_mod() + ": " + rutaDentroMod);
        }
    }

    private static void eliminarDirectorio(File directorio) {
        if (!directorio.exists()) {
            return;
        }
        File[] archivos = directorio.listFiles();
        if (archivos != null) {
            for (File archivo : archivos) {
                if (archivo.isDirectory()) {
                    EliminadorDeMod.eliminarDirectorio(archivo);
                    continue;
                }
                if (archivo.delete()) continue;
                EliminadorDeMod.logError(MonitorDePID.idioma.error_al_eliminar_archivo() + ": " + archivo.getAbsolutePath());
            }
        }
        if (!directorio.delete()) {
            EliminadorDeMod.logError(MonitorDePID.idioma.error_al_eliminar_directorio() + ": " + directorio.getAbsolutePath());
        }
    }

    private static void extraerZip(File archivoZip, File directorioDestino) throws IOException {
        try (ZipFile zip = new ZipFile(archivoZip);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File archivoDestino = new File(directorioDestino, entry.getName());
                if (entry.isDirectory()) {
                    archivoDestino.mkdirs();
                    continue;
                }
                archivoDestino.getParentFile().mkdirs();
                InputStream is = zip.getInputStream(entry);
                try (FileOutputStream fos = new FileOutputStream(archivoDestino);){
                    int len;
                    byte[] buffer = new byte[1024];
                    while ((len = is.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
    }

    private static void empaquetarZip(File directorio, File archivoSalida) throws IOException {
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(archivoSalida));){
            EliminadorDeMod.empaquetarDirectorio(directorio, zos, "");
        }
    }

    private static void empaquetarDirectorio(File directorio, ZipOutputStream zos, String prefijo) throws IOException {
        for (File archivo : directorio.listFiles()) {
            String nombre = prefijo + archivo.getName();
            if (archivo.isDirectory()) {
                zos.putNextEntry(new ZipEntry(nombre + "/"));
                EliminadorDeMod.empaquetarDirectorio(archivo, zos, nombre + "/");
                continue;
            }
            zos.putNextEntry(new ZipEntry(nombre));
            try (FileInputStream fis = new FileInputStream(archivo);){
                int len;
                byte[] buffer = new byte[1024];
                while ((len = fis.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
            }
            zos.closeEntry();
        }
    }

    private static void eliminarJarAnidado(String rutaJar) throws IOException {
        int indice = rutaJar.indexOf("!/");
        if (indice == -1) {
            EliminadorDeMod.logError(MonitorDePID.idioma.formato_invalido_para_jar_anidado() + ": " + rutaJar);
            return;
        }
        String rutaExterna = rutaJar.substring(0, indice);
        String rutaInterna = rutaJar.substring(indice + 2);
        File archivoExterno = new File(rutaExterna);
        if (!archivoExterno.exists() || !archivoExterno.getName().endsWith(".jar")) {
            EliminadorDeMod.logError(MonitorDePID.idioma.archivo_externo_no_valido() + ": " + rutaExterna);
            return;
        }
        File directorioTemporal = Files.createTempDirectory("crashdetector_mod_temp_", new FileAttribute[0]).toFile();
        directorioTemporal.deleteOnExit();
        File destinoExtraido = new File(directorioTemporal, "contenido");
        EliminadorDeMod.extraerZip(archivoExterno, destinoExtraido);
        File archivoInterno = new File(destinoExtraido, rutaInterna);
        if (archivoInterno.exists()) {
            if (!archivoInterno.delete()) {
                EliminadorDeMod.logError(MonitorDePID.idioma.error_al_eliminar_jar_anidado() + ": " + rutaJar);
                EliminadorDeMod.limpiarTemporal(directorioTemporal);
                return;
            }
        } else {
            EliminadorDeMod.logError(MonitorDePID.idioma.archivo_interno_no_encontrado() + ": " + rutaJar);
            EliminadorDeMod.limpiarTemporal(directorioTemporal);
            return;
        }
        File archivoTemporal = new File(directorioTemporal, "temp.jar");
        EliminadorDeMod.empaquetarZip(destinoExtraido, archivoTemporal);
        if (archivoExterno.delete() && archivoTemporal.renameTo(archivoExterno)) {
            EliminadorDeMod.logExito(MonitorDePID.idioma.jar_anidado_eliminado() + ": " + rutaJar);
        } else {
            EliminadorDeMod.logError(MonitorDePID.idioma.error_al_reemplazar_jar_externo() + ": " + rutaExterna);
        }
        EliminadorDeMod.limpiarTemporal(directorioTemporal);
    }

    private static void limpiarTemporal(File directorio) {
        try {
            Files.walk(Paths.get(directorio.getAbsolutePath(), new String[0]), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(path -> {
                try {
                    Files.delete(path);
                }
                catch (IOException e) {
                    System.err.println("No se pudo eliminar: " + path);
                }
            });
        }
        catch (IOException e) {
            EliminadorDeMod.logError(MonitorDePID.idioma.error_al_limpiar_temporales());
            CrashDetectorLogger.logException(e);
        }
    }

    public static boolean esArchivoFisico(String ruta) {
        return ruta != null && !ruta.contains(".jar!") && !ruta.contains(".zip!");
    }

    private static void logExito(String mensaje) {
        if (!EliminadorDeMod.esModoHeadless()) {
            EliminadorDeMod.mostrarMensajeExito(mensaje);
        } else {
            System.out.println("[\u00c9xito] " + mensaje);
        }
    }

    private static void logError(String mensaje) {
        if (!EliminadorDeMod.esModoHeadless()) {
            EliminadorDeMod.mostrarMensajeError(mensaje);
        } else {
            System.err.println("[Error] " + mensaje);
        }
    }

    private static void mostrarMensajeExito(String mensaje) {
        JOptionPane.showMessageDialog(null, mensaje, MonitorDePID.idioma.exito(), 1);
    }

    private static void mostrarMensajeError(String mensaje) {
        JOptionPane.showMessageDialog(null, mensaje, MonitorDePID.idioma.error(), 0);
    }

    public static boolean esModoHeadless() {
        return GraphicsEnvironment.isHeadless();
    }
}

