/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.DescargarRegistors;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EnlanceMD {
    public static File carpeta = Statics.carpeta.resolve(".tmp/tmp_registros").toFile();
    private static final AtomicInteger contadorGenerico = new AtomicInteger(1);
    private static final int HILOS_MAX = Math.max(2, Math.min(8, Runtime.getRuntime().availableProcessors()));

    public static void guardar(String textoDeMensaje) {
        EnlanceMD.limpiarCarpetaTemporal();
        contadorGenerico.set(1);
        Pattern patron = Pattern.compile(Pattern.quote("[") + "([^\\]]+)" + Pattern.quote("](") + "<?([^)>]+)>?" + Pattern.quote(")"));
        Matcher m = patron.matcher(textoDeMensaje);
        ArrayList<Enlace> enlaces = new ArrayList<Enlace>();
        while (m.find()) {
            String texto = m.group(1);
            String url = m.group(2);
            enlaces.add(new Enlace(texto, url));
        }
        if (enlaces.isEmpty()) {
            return;
        }
        ExecutorService pool = Executors.newFixedThreadPool(HILOS_MAX);
        ArrayList<Future<Consola>> tareas = new ArrayList<Future<Consola>>();
        for (Enlace e : enlaces) {
            tareas.add(pool.submit(new TareaDescarga(e)));
        }
        ArrayList<Consola> consolasNuevas = new ArrayList<Consola>();
        for (Future future : tareas) {
            try {
                Consola c = (Consola)future.get();
                if (c == null) continue;
                consolasNuevas.add(c);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException executionException) {}
        }
        pool.shutdown();
        if (!consolasNuevas.isEmpty()) {
            MonitorDePID.consolas.addAll(consolasNuevas);
            MonitorDePID.consola_de_launcher_inyectado = true;
        }
    }

    private static boolean contieneNombreLog(String texto) {
        String[] patrones;
        for (String p : patrones = new String[]{"latest\\.log", "launcher_log\\.txt", "debug\\.log", "tlauncher.*\\.log", "sklauncher_logs\\.txt", "hs_err_pid.*\\.log", "crash-.*\\.(?:log|txt)"}) {
            if (!texto.matches(".*" + p + ".*")) continue;
            return true;
        }
        return false;
    }

    private static String extraerNombreLog(String texto) {
        String ultimo;
        String[] patrones;
        for (String p : patrones = new String[]{"(latest\\.log)", "(launcher_log\\.txt)", "(debug\\.log)", "(tlauncher.*\\.log)", "(sklauncher_logs\\.txt)", "(hs_err_pid.*\\.log)", "(crash-.*\\.(?:log|txt))"}) {
            Matcher m = Pattern.compile(p).matcher(texto);
            if (!m.find()) continue;
            String nombre = m.group(1);
            if (nombre.startsWith("crash-")) {
                return nombre;
            }
            nombre = nombre.replaceFirst("(_\\d+)?\\.(log)$", ".log").replaceFirst("(_\\d+)?\\.(txt)$", ".txt");
            return nombre;
        }
        int slash = texto.lastIndexOf(47);
        if (slash != -1 && slash + 1 < texto.length() && (ultimo = texto.substring(slash + 1)).matches(".*\\.(log|txt)")) {
            return ultimo;
        }
        return "registro_generico_" + contadorGenerico.getAndIncrement() + ".log";
    }

    private static synchronized String obtenerNombreUnico(String nombreOriginal) {
        String base;
        String ext;
        File f;
        if (!carpeta.exists()) {
            carpeta.mkdirs();
        }
        if (!(f = new File(carpeta, nombreOriginal)).exists()) {
            return nombreOriginal;
        }
        Matcher m = Pattern.compile("\\.(log|txt)$").matcher(nombreOriginal);
        if (m.find()) {
            ext = m.group(1);
            base = nombreOriginal.substring(0, m.start());
        } else {
            ext = "";
            base = nombreOriginal;
        }
        int i = 2;
        do {
            String candidato = ext.isEmpty() ? base + "_" + i : base + "_" + i + "." + ext;
            f = new File(carpeta, candidato);
            ++i;
        } while (f.exists());
        return f.getName();
    }

    private static void limpiarCarpetaTemporal() {
        if (!carpeta.exists()) {
            carpeta.mkdirs();
            return;
        }
        File[] archivos = carpeta.listFiles();
        if (archivos == null) {
            return;
        }
        for (File a : archivos) {
            if (!a.isFile()) continue;
            try {
                a.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void descargarArchivo(String url, File destino) throws IOException {
        if (DescargarRegistors.esURLSoportada(url)) {
            List<String> urls = Collections.singletonList(url);
            List<File> descargados = DescargarRegistors.descargarYGuardarRegistros(urls, destino.getParentFile());
            if (descargados.isEmpty()) {
                throw new IOException("No se pudo descargar: " + url);
            }
            File origen = descargados.get(0);
            if (!origen.equals(destino) && !origen.renameTo(destino)) {
                Files.copy(origen.toPath(), destino.toPath(), new CopyOption[0]);
                try {
                    origen.delete();
                }
                catch (Exception exception) {}
            }
        } else {
            DescargarRegistors.descargarArchivo(url, destino);
        }
    }

    private static class Enlace {
        final String texto;
        final String url;

        Enlace(String texto, String url) {
            this.texto = texto;
            this.url = url;
        }
    }

    private static class TareaDescarga
    implements Callable<Consola> {
        private final Enlace enlace;

        TareaDescarga(Enlace enlace) {
            this.enlace = enlace;
        }

        @Override
        public Consola call() {
            String fuenteDeNombre;
            String texto = this.enlace.texto;
            String url = this.enlace.url;
            String string = fuenteDeNombre = EnlanceMD.contieneNombreLog(url) ? url : texto;
            if (!EnlanceMD.contieneNombreLog(fuenteDeNombre)) {
                return null;
            }
            try {
                String nombreFinal = EnlanceMD.extraerNombreLog(fuenteDeNombre);
                File destino = new File(carpeta, EnlanceMD.obtenerNombreUnico(nombreFinal));
                EnlanceMD.descargarArchivo(url, destino);
                Consola consola = new Consola(destino.toPath());
                consola.finalizarContenidoInyectado(MonitorDePID.leer_archivo(destino.toPath()));
                return consola;
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

