/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector;

import com.asbestosstar.crashdetector.App;
import com.asbestosstar.crashdetector.ConfigMundial;
import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.buscar.Buscardor;
import com.asbestosstar.crashdetector.cargador.Cargador;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorLanzer;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Entregar {
    public static File archivo = Statics.carpeta.resolve("entregar").toFile();
    private static final String MASK = "*********************************";
    public static App app_detecta;

    public static void comenzarEntregar() {
        long inicioApp;
        String lanzer;
        app_detecta = App.obtenerApp();
        String idApp = app_detecta != null ? app_detecta.id() : "";
        Buscardor.cargadoresPredetermindado();
        ArrayList<Cargador> activos_cargadores = new ArrayList<Cargador>();
        for (Cargador c : Cargador.cargadores) {
            try {
                if (!c.cargadorEsActivado()) continue;
                activos_cargadores.add(c);
            }
            catch (Throwable throwable) {}
        }
        String args = Entregar.obtenerArgsDelPrograma();
        if (!ConfigMundial.obtenerInstancia().obtenerHabilitarTokenDeAccesoEnLaEntregaDelMonitorDePID()) {
            args = Entregar.eliminarTokenDeAcceso(args);
        }
        Statics.lanzer_del_app = lanzer = DetectorLanzer.detectarLanzer(app_detecta, args);
        Statics.INICIO_DE_LA_APP = inicioApp = Entregar.obtenerInicioDeLaApp();
        String contenido = Entregar.construirContenidoArchivo(idApp, args, activos_cargadores, lanzer, inicioApp);
        Entregar.escribirArchivo(contenido);
    }

    public static void recibir() {
        if (!archivo.exists() || !archivo.isFile()) {
            CrashDetectorLogger.log("Archivo inexiste");
            return;
        }
        try {
            List<String> lineas = Files.readAllLines(archivo.toPath(), StandardCharsets.UTF_8);
            String idApp = "";
            String args = "";
            String idsCargadores = "";
            String lanzer = "";
            long inicioApp = 0L;
            for (String l : lineas) {
                int p = l.indexOf(58);
                if (p <= 0) continue;
                String k = l.substring(0, p).trim();
                String v = l.substring(p + 1).trim();
                if ("app".equals(k)) {
                    idApp = v;
                    continue;
                }
                if ("args".equals(k)) {
                    args = v;
                    continue;
                }
                if ("cargadores".equals(k)) {
                    idsCargadores = v;
                    continue;
                }
                if ("lanzer".equals(k)) {
                    lanzer = v;
                    continue;
                }
                if (!"inicio".equals(k)) continue;
                try {
                    inicioApp = Long.parseLong(v);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            Statics.APP = app_detecta = Entregar.buscarAppPorId(idApp);
            Statics.lanzer_del_app = lanzer != null ? lanzer : "";
            Statics.ARGS_DE_APP = args != null ? args : "";
            Statics.INICIO_DE_LA_APP = inicioApp;
            Buscardor.cargadoresPredetermindado();
            if (idsCargadores != null && !idsCargadores.isEmpty()) {
                String[] parts;
                for (String id : parts = idsCargadores.split(",")) {
                    Cargador inst;
                    String t = id.trim();
                    if (t.isEmpty() || (inst = Entregar.buscarCargadorPorId(t)) == null || Cargador.cargadores_activados.contains(inst)) continue;
                    Cargador.cargadores_activados.add(inst);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        archivo.delete();
    }

    private static String construirContenidoArchivo(String idApp, String args, List<Cargador> activos, String lanzer, long inicioApp) {
        StringBuilder ids = new StringBuilder();
        if (activos != null && !activos.isEmpty()) {
            for (Cargador c : activos) {
                try {
                    String id = c.id();
                    if (id == null || id.isEmpty()) continue;
                    if (ids.length() > 0) {
                        ids.append(',');
                    }
                    ids.append(id);
                }
                catch (Throwable throwable) {}
            }
        }
        StringBuilder out = new StringBuilder();
        out.append("app: ").append(idApp == null ? "" : idApp).append('\n');
        out.append("args: ").append(args == null ? "" : args).append('\n');
        out.append("lanzer: ").append(lanzer == null ? "" : lanzer).append('\n');
        out.append("inicio: ").append(inicioApp).append('\n');
        out.append("cargadores: ").append(ids.toString()).append('\n');
        return out.toString();
    }

    private static void escribirArchivo(String contenido) {
        try {
            File dir = archivo.getParentFile();
            if (dir != null && !dir.exists()) {
                dir.mkdirs();
            }
            Files.write(archivo.toPath(), contenido.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static long obtenerInicioDeLaApp() {
        try {
            return ManagementFactory.getRuntimeMXBean().getStartTime();
        }
        catch (Throwable t) {
            return 0L;
        }
    }

    private static App buscarAppPorId(String id) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        try {
            if (App.APPS instanceof Map) {
                Map mapa = (Map)((Object)App.APPS);
                return (App)mapa.get(id);
            }
            if (App.APPS instanceof Iterable) {
                for (Object t : App.APPS) {
                    if (!(t instanceof App) || !id.equals(((App)t).id())) continue;
                    return (App)t;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static Cargador buscarCargadorPorId(String id) {
        for (Cargador c : Cargador.cargadores) {
            try {
                if (!id.equals(c.id())) continue;
                return c;
            }
            catch (Throwable throwable) {
            }
        }
        return null;
    }

    private static String eliminarTokenDeAcceso(String args) {
        if (args == null || args.isEmpty()) {
            return "";
        }
        String out = args;
        out = out.replaceAll("(?i)(--accessToken\\s*=\\s*\")([^\"]*)(\")", "$1*********************************$3");
        out = out.replaceAll("(?i)(--accessToken\\s*=\\s*')([^']*)(')", "$1*********************************$3");
        out = out.replaceAll("(?i)(--accessToken\\s*=\\s*)(\\S+)", "$1*********************************");
        out = out.replaceAll("(?i)(--accessToken\\s+\")([^\"]*)(\")", "$1*********************************$3");
        out = out.replaceAll("(?i)(--accessToken\\s+')([^']*)(')", "$1*********************************$3");
        out = out.replaceAll("(?i)(--accessToken\\s+)(\\S+)", "$1*********************************");
        out = out.replaceAll("(?i)(\"accessToken\"\\s*:\\s*\")([^\"]*)(\")", "$1*********************************$3");
        out = out.replaceAll("(?i)('accessToken'\\s*:\\s*')([^']*)(')", "$1*********************************$3");
        return out;
    }

    private static String obtenerArgsDelPrograma() {
        try {
            String cmd = System.getProperty("sun.java.command", "");
            if (cmd == null || cmd.isEmpty()) {
                cmd = String.join((CharSequence)" ", ManagementFactory.getRuntimeMXBean().getInputArguments());
                return cmd != null ? cmd : "";
            }
            return cmd;
        }
        catch (Throwable t) {
            return "";
        }
    }
}

