/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector;

import com.asbestosstar.crashdetector.buscar.ArchivoDeMod;
import com.asbestosstar.crashdetector.buscar.Buscardor;
import java.util.ArrayList;
import java.util.List;

public class EscanerMCreator {
    public static String obtainerMCreatorMods() {
        StringBuilder resultado = new StringBuilder();
        Buscardor.cargar();
        ArrayList<ArchivoDeMod> todosLosMods = new ArrayList<ArchivoDeMod>();
        for (ArchivoDeMod mod : Buscardor.obtenerTodosLosModsYSubmodsRecursivos()) {
            EscanerMCreator.coleccionarModsAnidados(mod, todosLosMods);
        }
        ArrayList<ArchivoDeMod> altaPrioridad = new ArrayList<ArchivoDeMod>();
        ArrayList<ArchivoDeMod> menosAltaPrioridad = new ArrayList<ArchivoDeMod>();
        ArrayList<ArchivoDeMod> mediaPrioridad = new ArrayList<ArchivoDeMod>();
        for (ArchivoDeMod mod : todosLosMods) {
            boolean esAlta = false;
            boolean esMenosAlta = false;
            boolean esMedia = false;
            if (!esAlta && mod.MetaDataTieneReferenciaDeMCReator()) {
                esMenosAlta = true;
            }
            for (String clase : mod.clases()) {
                int ultimoPunto = clase.lastIndexOf(47);
                if (ultimoPunto == -1) continue;
                String paquete = clase.substring(0, ultimoPunto);
                if (paquete.startsWith("net/mcreator")) {
                    esAlta = true;
                    break;
                }
                if (esAlta || esMenosAlta || !paquete.endsWith("/procedures") && (!paquete.endsWith("/elements") || esAlta || esMenosAlta)) continue;
                esMedia = true;
            }
            if (esAlta) {
                altaPrioridad.add(mod);
                continue;
            }
            if (esMenosAlta) {
                menosAltaPrioridad.add(mod);
                continue;
            }
            if (!esMedia) continue;
            mediaPrioridad.add(mod);
        }
        resultado.append("Resultados del an\u00e1lisis MCreator:\n");
        if (!altaPrioridad.isEmpty()) {
            resultado.append("\n--- Alta Prioridad (net.mcreator) ---\n");
            for (ArchivoDeMod mod : altaPrioridad) {
                resultado.append(Buscardor.rutaParaPublicar(mod.ubicacion())).append("\n");
            }
        }
        if (!menosAltaPrioridad.isEmpty()) {
            resultado.append("\n--- Menos Alta Prioridad (Referencia a mcreator en fabric.mod.json/mods.toml/modules.xml/descriptor.mod/neoforge.mods.toml) ---\n");
            for (ArchivoDeMod mod : menosAltaPrioridad) {
                resultado.append(Buscardor.rutaParaPublicar(mod.ubicacion())).append("\n");
            }
        }
        if (!mediaPrioridad.isEmpty()) {
            resultado.append("\n--- Media Prioridad (procedures/elements) ---\n");
            for (ArchivoDeMod mod : mediaPrioridad) {
                resultado.append(Buscardor.rutaParaPublicar(mod.ubicacion())).append("\n");
            }
        }
        if (altaPrioridad.isEmpty() && menosAltaPrioridad.isEmpty() && mediaPrioridad.isEmpty()) {
            resultado.append("\nNo se encontraron mods de MCreator");
        }
        return resultado.toString();
    }

    private static void coleccionarModsAnidados(ArchivoDeMod mod, List<ArchivoDeMod> coleccion) {
        coleccion.add(mod);
        for (ArchivoDeMod submod : mod.mods_en_mods()) {
            EscanerMCreator.coleccionarModsAnidados(submod, coleccion);
        }
    }
}

