/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector;

import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.api_sito_registro.APIdeSitioDeRegistro;
import com.asbestosstar.crashdetector.api_sito_registro.DemasiadoGrande;
import com.asbestosstar.crashdetector.api_sito_registro.ErrorConPublicar;
import com.asbestosstar.crashdetector.api_sito_registro.LimteDeTasa;
import com.asbestosstar.crashdetector.api_sito_registro.NoAPIdeRegistro;
import com.asbestosstar.crashdetector.config.ConfigString;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class GeneradorDeInformacion {
    public static File generarLocal(List<Consola> consolas, Instant instant) {
        try {
            StringBuilder cons = new StringBuilder();
            cons.append("<center>").append(MonitorDePID.idioma.ubicacionesDeLogs()).append("<br>");
            for (Consola co : consolas) {
                cons.append("<a href='file://").append(co.archivo.toAbsolutePath().toUri().toString()).append("'><font color='").append(Config.obtenerInstancia().obtenerColorEnlace()).append("'>").append(co.archivo.toString().trim()).append("</font></a><br>");
            }
            cons.append(GeneradorDeInformacion.generarTextoArcoiris("Feliz mes del orgullo"));
            cons.append("</center>");
            String pantilla = MonitorDePID.leer_archivo(Statics.carpeta.resolve("pantilla.htm"));
            String carp = Statics.carpeta.resolve(".informes").toString() + "/";
            File carp_file = new File(carp);
            carp_file.mkdirs();
            File ret = new File(carp + instant.toString().replace(":", "") + ".htm");
            FileWriter escribidor = new FileWriter(ret);
            escribidor.write(pantilla.replace("{constructor}", cons.toString() + "<br>" + MonitorDePID.idioma.infoDeVerificaciones() + "<br>" + MonitorDePID.contenidoInforme.toString() + GeneradorDeInformacion.imagenesLocales()).replace("{mensaje_ayudar}", MonitorDePID.idioma.mensajeAyudar()));
            escribidor.close();
            return ret;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String imagenesLocales() {
        StringBuilder cons = new StringBuilder();
        File imagenDir = Statics.carpeta.resolve("imagenes").toFile();
        String guraUrl = new File(imagenDir, "gura.png").toURI().toString();
        String mumeiUrl = new File(imagenDir, "nanashi_mumei.png").toURI().toString();
        String shionUrl = new File(imagenDir, "shion.png").toURI().toString();
        cons.append("<center>").append("<img src='").append(guraUrl).append("' width='200' height='112'>").append("&nbsp;&nbsp;&nbsp;").append("<img src='").append(mumeiUrl).append("' width='200' height='112'>").append("&nbsp;&nbsp;&nbsp;").append("<img src='").append(shionUrl).append("' width='200' height='112'>").append("</center>");
        return cons.toString();
    }

    public static String compartir(List<Consola> consolas, Instant instant) throws DemasiadoGrande, ErrorConPublicar, NoAPIdeRegistro, LimteDeTasa {
        try {
            int MAX_HILOS = 6;
            ExecutorService pool = Executors.newFixedThreadPool(Math.min(6, Math.max(1, consolas.size())));
            ArrayList<Future<ResultadoEnlaces>> tareas = new ArrayList<Future<ResultadoEnlaces>>(consolas.size());
            for (int i = 0; i < consolas.size(); ++i) {
                int idx = i;
                Consola consola = consolas.get(i);
                tareas.add(pool.submit(() -> {
                    APIdeSitioDeRegistro api = APIdeSitioDeRegistro.obtenerAPIdeConfig();
                    String nombre = co.archivo != null ? co.archivo.toString().trim() : "log.txt";
                    String gid = nombre + ":" + instant.toString();
                    api.registrarGrupoActual(gid);
                    List<String> enlaces = co.obtainerEnlaces();
                    return new ResultadoEnlaces(idx, nombre, enlaces);
                }));
            }
            pool.shutdown();
            ResultadoEnlaces[] resultados = new ResultadoEnlaces[consolas.size()];
            for (Future future : tareas) {
                try {
                    ResultadoEnlaces r;
                    resultados[r.index] = r = (ResultadoEnlaces)future.get();
                }
                catch (ExecutionException ex) {
                    Throwable causa = ex.getCause();
                    if (causa instanceof DemasiadoGrande) {
                        throw (DemasiadoGrande)causa;
                    }
                    if (causa instanceof ErrorConPublicar) {
                        throw (ErrorConPublicar)causa;
                    }
                    if (causa instanceof NoAPIdeRegistro) {
                        throw (NoAPIdeRegistro)causa;
                    }
                    if (causa instanceof LimteDeTasa) {
                        throw (LimteDeTasa)causa;
                    }
                    CrashDetectorLogger.logException(causa);
                    throw new IOException(causa.getMessage(), causa);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Operaci\u00f3n interrumpida", ie);
                }
            }
            StringBuilder cons = new StringBuilder();
            cons.append("<center>").append(MonitorDePID.idioma.ubicacionesDeLogs()).append("<br>");
            for (ResultadoEnlaces r : resultados) {
                if (r == null) continue;
                List<String> enlaces = r.enlaces;
                String nombre = r.nombreArchivo;
                if (enlaces != null && enlaces.size() == 1) {
                    cons.append("<a href='").append(enlaces.get(0)).append("'><font color='").append(Config.obtenerInstancia().obtenerColorEnlace()).append("'>").append(nombre).append("</font></a><br>");
                    continue;
                }
                if (enlaces != null && enlaces.size() > 1) {
                    cons.append("<span><font color='").append(Config.obtenerInstancia().obtenerColorEnlace()).append("'>").append(nombre).append("</font>: ");
                    for (int i = 0; i < enlaces.size(); ++i) {
                        String url = enlaces.get(i);
                        cons.append("<a href='").append(url).append("'>").append("(p ").append(i + 1).append(")").append("</a>");
                        if (i >= enlaces.size() - 1) continue;
                        cons.append(" ");
                    }
                    cons.append("</span><br>");
                    continue;
                }
                cons.append("<span><font color='").append(Config.obtenerInstancia().obtenerColorEnlace()).append("'>").append(nombre).append("</font></span><br>");
            }
            cons.append(GeneradorDeInformacion.generarTextoArcoiris("Feliz mes del orgullo"));
            cons.append("</center>");
            String string = MonitorDePID.leer_archivo(Statics.carpeta.resolve("pantilla.htm"));
            String constructorHtml = cons.toString() + "<br>" + MonitorDePID.idioma.infoDeVerificaciones() + "<br>" + MonitorDePID.contenidoInforme.toString() + GeneradorDeInformacion.imagenesParaCompartir();
            constructorHtml = GeneradorDeInformacion.postProcesarLinks(constructorHtml, instant);
            String ret = GeneradorDeInformacion.enviarInforme(string.replace("{constructor}", constructorHtml).replace("{mensaje_ayudar}", ""));
            CrashDetectorLogger.log(ret);
            return ret;
        }
        catch (IOException e) {
            CrashDetectorLogger.logException(e);
            return null;
        }
    }

    private static String postProcesarLinks(String html, Instant instant) {
        try {
            String etiqueta;
            APIdeSitioDeRegistro api = APIdeSitioDeRegistro.obtenerAPIdeConfig();
            Pattern pLectador = Pattern.compile("(?i)<a\\b[^>]*href=[\"']lectador://(.*?):(\\d+)[\"'][^>]*>(.*?)</a>");
            Matcher m = pLectador.matcher(html);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                String urlLinea;
                String ruta = m.group(1);
                int linea = Integer.parseInt(m.group(2));
                String inner = m.group(3);
                String gid = ruta.trim() + ":" + instant.toString();
                api.registrarGrupoActual(gid);
                String replacement = api.soporteEnlacesALinea() ? ((urlLinea = api.obtenerEnlaceDeLinea(linea)) != null && !urlLinea.isEmpty() ? "<a href='" + urlLinea + "'>" + inner + "</a>" : "") : "";
                m.appendReplacement(sb, Matcher.quoteReplacement(replacement));
            }
            m.appendTail(sb);
            html = sb.toString();
            html = html.replaceAll("\\s*[-\u2013\u2014]\\s*(?=(</a>|</span>|</div>|<br\\s*/?>|$))", "");
            if (!api.soporteEnlacesALinea() && (etiqueta = MonitorDePID.idioma.verEnConsola()) != null && !etiqueta.isEmpty()) {
                String q = Pattern.quote(etiqueta);
                html = html.replaceAll("\\s*[-\u2013\u2014]?\\s*" + q, "");
            }
            return html;
        }
        catch (Throwable t) {
            return html;
        }
    }

    public static String imagenesParaCompartir() {
        StringBuilder cons = new StringBuilder();
        String enlace_a_imagen_gura = ConfigString.de("enlace_imagen_gura", "http://asbestosstar.egoism.jp/crash_detector/gura.png").obtener();
        String enlace_a_imagen_mumei = ConfigString.de("enlace_imagen_mumei", "http://asbestosstar.egoism.jp/crash_detector/nanashi_mumei.png").obtener();
        String enlace_a_imagen_shion = ConfigString.de("enlace_imagen_shion", "http://asbestosstar.egoism.jp/crash_detector/shion.png").obtener();
        cons.append("<center>").append("<img src='").append(enlace_a_imagen_gura).append("' width='200' height='112'>").append("&nbsp;&nbsp;&nbsp;").append("<img src='").append(enlace_a_imagen_mumei).append("' width='200' height='112'>").append("&nbsp;&nbsp;&nbsp;").append("<img src='").append(enlace_a_imagen_shion).append("' width='200' height='112'>").append("</center>");
        return cons.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String enviarInforme(String html) throws IOException {
        try {
            String servidor = Config.obtenerInstancia().obtenerSitoDeInformes();
            String parametros = "html_content=" + URLEncoder.encode(html, "UTF-8");
            HttpURLConnection conexion = (HttpURLConnection)new URL(servidor).openConnection();
            conexion.setRequestMethod("POST");
            conexion.setDoOutput(true);
            conexion.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            try (OutputStream os = conexion.getOutputStream();){
                os.write(parametros.getBytes(StandardCharsets.UTF_8));
            }
            int codigoRespuesta = conexion.getResponseCode();
            if (codigoRespuesta == 200) {
                try (Scanner scanner = new Scanner(conexion.getInputStream(), StandardCharsets.UTF_8.name());){
                    String string = scanner.useDelimiter("\\A").next().trim();
                    return string;
                }
            }
            String mensajeError = "Error HTTP " + codigoRespuesta + ": ";
            try (Scanner scanner = new Scanner(conexion.getErrorStream());){
                if (!scanner.hasNext()) throw new IOException(mensajeError);
                mensajeError = mensajeError + scanner.useDelimiter("\\A").next();
                throw new IOException(mensajeError);
            }
        }
        catch (SSLException e) {
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(null, MonitorDePID.idioma.errorSSL()));
            CrashDetectorLogger.logException(e);
            throw new IOException("Error SSL: " + e.getMessage(), e);
        }
    }

    private static String generarTextoArcoiris(String texto) {
        String[] coloresArcoiris = new String[]{"#FF0000", "#FFA500", "#FFFF00", "#00FF00", "#0000FF", "#4B0082", "#EE82EE"};
        StringBuilder html = new StringBuilder();
        int indiceColor = 0;
        for (char c : texto.toCharArray()) {
            if (c == ' ') {
                html.append(' ');
                continue;
            }
            html.append("<span style='color:").append(coloresArcoiris[indiceColor % coloresArcoiris.length]).append("'>").append(c).append("</span>");
            ++indiceColor;
        }
        return html.toString();
    }

    private static final class ResultadoEnlaces {
        final int index;
        final String nombreArchivo;
        final List<String> enlaces;

        ResultadoEnlaces(int index, String nombreArchivo, List<String> enlaces) {
            this.index = index;
            this.nombreArchivo = nombreArchivo;
            this.enlaces = enlaces;
        }
    }
}

