/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector;

import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.ConfigMundial;
import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.config.ConfigString;
import com.asbestosstar.crashdetector.idioma.Arabe;
import com.asbestosstar.crashdetector.idioma.Chino;
import com.asbestosstar.crashdetector.idioma.Coreano;
import com.asbestosstar.crashdetector.idioma.Espanol;
import com.asbestosstar.crashdetector.idioma.Esperanto;
import com.asbestosstar.crashdetector.idioma.Ingles;
import com.asbestosstar.crashdetector.idioma.Japones;
import com.asbestosstar.crashdetector.idioma.Persa;
import com.asbestosstar.crashdetector.idioma.Portuges;
import com.asbestosstar.crashdetector.idioma.Ruso;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public interface Idioma {
    public static final Config config = Config.obtenerInstancia();
    @Deprecated
    public static final File archivo = new File(System.getProperty("user.home"), "crash_detector/idioma");
    public static final ConfigString idioma_respaldo = ConfigString.de("idioma_respaldo", "es");
    public static final Idioma espanol = new Espanol();
    public static final Idioma ingles = new Ingles();
    public static final Idioma arabe = new Arabe();
    public static final Idioma portuges = new Portuges();
    public static final Idioma persa = new Persa();
    public static final Idioma ruso = new Ruso();
    public static final Idioma chino = new Chino();
    public static final Idioma esperanto = new Esperanto();
    public static final Idioma japones = new Japones();
    public static final Idioma coreano = new Coreano();

    public static Idioma detectar() {
        String id = ConfigMundial.obtenerInstancia().obtenerIdioma();
        if (id != null && Idioma.tenemosIdiomaCodigo(id)) {
            return Idioma.desdeCodigo(id);
        }
        id = Idioma.leerIdiomaDesdeArchivo();
        if (id != null && Idioma.tenemosIdiomaCodigo(id)) {
            return Idioma.desdeCodigo(id);
        }
        id = Locale.getDefault().getLanguage().toLowerCase();
        if (Idioma.tenemosIdiomaCodigo(id)) {
            return Idioma.desdeCodigo(id);
        }
        id = idioma_respaldo.obtener();
        if (id != null && Idioma.tenemosIdiomaCodigo(id)) {
            return Idioma.desdeCodigo(id);
        }
        return espanol;
    }

    public static Idioma desdeCodigo(String codigo) {
        switch (codigo) {
            case "es": {
                return espanol;
            }
            case "en": {
                return ingles;
            }
            case "ar": {
                return arabe;
            }
            case "pt": {
                return portuges;
            }
            case "fa": {
                return persa;
            }
            case "ru": {
                return ruso;
            }
            case "zh": {
                return chino;
            }
            case "eo": {
                return esperanto;
            }
            case "ja": {
                return japones;
            }
            case "ko": {
                return coreano;
            }
            case "uk": {
                return ruso;
            }
        }
        return espanol;
    }

    public static String nombreDeIdiomaDesdeCondigo(String codigo) {
        switch (codigo) {
            case "es": {
                return "Espa\u00f1ol";
            }
            case "en": {
                return "English";
            }
            case "ar": {
                return "\u0627\u0644\u0639\u0631\u0628\u064a\u0629";
            }
            case "pt": {
                return "Portugu\u00eas";
            }
            case "fa": {
                return "\u0641\u0627\u0631\u0633\u06cc";
            }
            case "ru": {
                return "\u0420\u0443\u0441\u0441\u043a\u0438\u0439";
            }
            case "zh": {
                return "\u4e2d\u6587";
            }
            case "eo": {
                return "Esperanto";
            }
            case "ja": {
                return "\u65e5\u672c\u8a9e";
            }
            case "ko": {
                return "\ud55c\uad6d\uc5b4";
            }
            case "uk": {
                return "\u0420\u0443\u0441\u0441\u043a\u0438\u0439";
            }
        }
        return "Espa\u00f1ol";
    }

    public static boolean tenemosIdiomaCodigo(String codigo) {
        HashSet<String> CODIGOS_IDIOMA = new HashSet<String>(Arrays.asList("es", "en", "ar", "pt", "fa", "ru", "zh", "eo", "ja", "ko"));
        return CODIGOS_IDIOMA.contains(codigo);
    }

    public static String leerIdiomaDesdeArchivo() {
        if (!archivo.exists() || !archivo.canRead()) {
            return null;
        }
        try {
            String texto = Idioma.leer_archivo(archivo.toPath());
            String codigo = texto.trim().toLowerCase();
            HashSet<String> soportados = new HashSet<String>(Arrays.asList("es", "en", "ar", "pt", "fa", "ru", "zh", "eo", "ja", "ko"));
            if (soportados.contains(codigo)) {
                ConfigMundial.obtenerInstancia().guardarIdioma(codigo);
                return codigo;
            }
            return null;
        }
        catch (IOException e) {
            CrashDetectorLogger.logException(e);
            return null;
        }
    }

    public static String leer_archivo(Path path) throws IOException {
        return new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
    }

    public String carpeta_de_mods_no_valido();

    public String no_se_donde_esta_jar();

    public String buscando_para_pid(long var1);

    public String pid_esta_muerto(long var1);

    public String no_tenemos_jvm();

    public String problema_con_graficas_ati();

    public String problema_con_graficas_nouveau();

    public String problema_con_graficas_general();

    public String fmlEarlyWindow();

    public String no_tienes_las_dependencias_necesarias();

    public String linea_de_dependencia(String var1);

    public String local_headless(String var1);

    public String texto_de_gui();

    public String texto_de_boton_local_enlace();

    public String texto_debajo_de_buton_local_enlace();

    public String texto_de_buton_compartir_enlace();

    public String texto_debajo_de_buton_compartir_enlace();

    public String problematico_jar();

    public String nivel();

    public String posibilidad_fatal();

    public String modids_problematicos();

    public String packages_problematicos();

    public String falta_de_clases_fatales();

    public String corchetes_ondulados();

    public String config_spongemixin_problematico();

    public String module_resolution_exception();

    public String modlauncher_mods_duplicado(String var1);

    public String mcforge_mod_sospechoso();

    public String lithostichctov();

    public String necesitasSodiumParaIris();

    public String kubeJSResourcePack(String var1);

    default public String obtenerRutaJava() {
        String javaBinary = MonitorDePID.jvm();
        return javaBinary;
    }

    public String problema_con_graficas_nvidia_windows_viejo();

    public String problema_con_graficas_nvidia_windows_nuevo();

    public String segundo60Tick();

    public String noTieneMemoria();

    public String theseus();

    public String noTieneConsolaDeLauncherCursedForge();

    public String faltar_de_clases_advertencia();

    public String noResultados();

    public String ubicacionesDeLogs();

    public String infoDeVerificaciones();

    public String versionDeJava();

    public String java22();

    public String javaObsoleta();

    public String jpms_modules_faltas(String var1, String var2);

    public String null_pointer_error(String var1, String var2);

    public String analisisAvanzado();

    public String seleccionarCarpeta();

    public String cadenaBusqueda();

    public String usarRegex();

    public String ignorarMayusculas();

    public String buscar();

    public String busquedaEnProgreso();

    public String noSeEncontraronResultados();

    public String errorBusqueda();

    public String noRegistroDeLauncher();

    public String omitirYCerrar();

    public String guardarYCerrar();

    public String pegaLosRegistrosAqui();

    public String archivo();

    public String incluir();

    public String abrir();

    public String endpointDeInforme();

    public String sitoDeLogging();

    public String apiDeLogging();

    public String anonimizarRegistros();

    public String botonDeCompartirInforme();

    public String arco();

    public String enlaceDelReporte();

    public String guardarConfigDeCompartir();

    public String registroDemasiadoGrande();

    public String errorConPublicarRegistro(String var1);

    public String apiDeRegistroNoExiste();

    public String errorSSL();

    public String errorJavaFMLVersion(String var1, String var2);

    public String errorProveedorVersion(String var1, String var2, String var3, String var4);

    public String errorJavaFML_MCForge();

    public String error_clase_no_encontrada_mcforge_mod_suspechoso(String var1, String var2);

    public String waterMediaTL();

    public String optifineObsoleta();

    public String servicioMLNoPudoCargar(String var1);

    public String errorConJSONDeRegistro(String var1, String var2);

    public String errorVersionDependencia(String var1, String var2, String var3, String var4);

    public String gpu_no_compatible();

    public String recomendacionMemoria();

    public String error32BitMemoria();

    public String permGenError();

    public String errorCompatibilidadJava8();

    public String errorJava9NoSoportado();

    public String errorJava8Requerido();

    public String errorDeBloqueTeselado();

    public String errorMonitorLWJGL();

    public String errorOpcionesGCJava();

    public String errorConfigMCForge();

    public String problema_con_graficas_intel();

    public String nombre_de_faltar_de_clases_advertencia();

    public String nombre_de_bloque_teselado();

    public String nombre_de_contenido_de_stacktrace();

    public String nombre_de_cursed_consola();

    public String nombre_de_early_window();

    public String nombre_de_drivers();

    public String nombre_de_error_de_config_mcforge();

    public String nombre_de_error_de_monitor_lwjgl();

    public String nombre_de_fabricmc_runtime_error_provided_by();

    public String nombre_de_falta_module_jmps();

    public String nombre_de_faltar_de_clases();

    public String nombre_de_faltas_dependencias_de_modlauncher();

    public String nombre_de_java_versiones();

    public String nombre_de_faltar_de_kubejs_resourcepack();

    public String nombre_de_lenguaje_proveedor_check();

    public String nombre_de_faltar_de_liyhostictchctov();

    public String nombre_de_malware_falso_crash_assistant();

    public String nombre_de_mcforge_mod_sespechoso();

    public String nombre_de_mods_duplicados_modlauncher();

    public String nombre_de_modules_duplicados_jmps();

    public String nombre_de_necesitas_sodium();

    public String nombre_de_no_puede_analizar_json_de_registro();

    public String nombre_de_no_tiene_memoria();

    public String nombre_de_null_pointer();

    public String nombre_de_opciones_java_gc_invalidas();

    public String nombre_de_optifine_obsoleta();

    public String nombre_de_60_segundo_trick();

    public String nombre_de_servicio_de_modlauncher_no_funciona();

    public String nombre_de_spongemixin_configs_problematicos();

    public String nombre_de_theseus();

    public String nombre_de_watermedia_tl();

    public String auditorias_transformer();

    public String auditorias_transformer_detectadas();

    public String descripcionEscanerMCreator();

    public String escanear();

    public String cargando();

    public String codigo();

    public String inicioApp();

    public String ajustesCrashDetector();

    public String confidencialidad();

    public String tooltip();

    public String config();

    public String abrirCarpeta();

    public String actualizar();

    public String anadirRegistro();

    public String usarIdiomaDelSistema();

    public String volver();

    public String colorFondo();

    public String colorTexto();

    public String colorBoton();

    public String colorCajaTexto();

    public String colorEnlace();

    public String colorTitulosConsolas();

    public String colorError();

    public String colorAdvertencia();

    public String colorInfo();

    public String colorTitulo();

    public String colorEnlaceTexto();

    public String transformacionDeMinecraftCodigo0();

    public String activar_parche();

    public String noHaySolucionDisponible();

    public String error();

    public String error_al_eliminar_jar();

    public String jar_eliminado_exitosamente();

    public String exito();

    public String eliminar();

    public String error_al_eliminar_paquete();

    public String paquete_eliminado_exitosamente();

    public String eliminar_paquete();

    public String no_se_encontraron_mods_con_paquete();

    public String no_se_puede_eliminar_paquete();

    public String eliminar_jar();

    public String no_se_encontraron_mods_duplicados();

    public String archivo_no_encontrado();

    public String directorio_eliminado();

    public String error_al_eliminar_jar_anidado();

    public String archivo_interno_no_encontrado();

    public String archivo_eliminado();

    public String error_al_eliminar_archivo();

    public String archivo_externo_no_valido();

    public String elemento_mod_eliminado();

    public String error_al_reemplazar_jar_externo();

    public String error_al_eliminar_elemento_mod();

    public String error_al_eliminar_directorio();

    public String formato_invalido_para_jar_anidado();

    public String jar_anidado_eliminado();

    public String error_al_limpiar_temporales();

    public String mensaje_de_trace_fatal_ultima_no_traductado();

    public String mensaje_de_trace_ultima_no_traductado();

    public String solucionParaAdvertenciaFaltasClases();

    public String solucionFaltasClases();

    public String solucionParaJavaInstallar();

    public String error_animacion_no_encontrada();

    public String nombre_de_error_animacion_minecraft();

    public String no_se_encontraron_mods_para_eliminar();

    public String opcionesGCInvalidas();

    public String aumentarMemoriaHeap();

    public String aumentarMemoriaPermgen();

    public String utilizarJVM64Bits();

    public String optimizarCodigo();

    public String utilizarRecolectorBasuraEficiente();

    public String modulos();

    public String paquete();

    public String solucionRegistrosMalMapeados();

    public String nombre_de_registros_mal_mapeados();

    public String mensajeCierreAuthMe();

    public String nombreProblemaCierreAuthMe();

    public String solucionCierreAuthMe();

    public String solucionConfigurarPluginAuthMe();

    public String solucionInstalarVersionDiferenteAuthMe();

    public String solucionEliminarPluginAuthMe();

    public String mensajeProblemaCargaMultiverso(String var1);

    public String nombreProblemaCargaMultiverso();

    public String solucionRepararMundo(String var1);

    public String solucionEliminarCarpetaMundo(String var1);

    public String mensajeConfiguracionPermissionsEx();

    public String nombreProblemaConfiguracionPermissionsEx();

    public String solucionConfigurarPermissionsEx();

    public String solucionEliminarPluginPermissionsEx();

    public String mensajeNombrePluginAmbiguo(String var1, String var2, String var3);

    public String nombreProblemaNombrePluginAmbiguo();

    public String solucionEliminarPlugin(String var1);

    public String mensajeCargaChunk();

    public String nombreProblemaCargaChunk();

    public String solucionEliminarChunk();

    public String mensajeExcepcionComandoPlugin(String var1, String var2);

    public String nombreProblemaExcepcionComandoPlugin();

    public String solucionInstalarVersionDiferentePlugin(String var1);

    public String mensajeDependenciaPluginMultiples(String var1, List<String> var2);

    public String mensajeDependenciaPluginUnica(String var1, String var2);

    public String nombreProblemaDependenciaPlugin();

    public String solucionInstalarPlugin(String var1);

    public String mensajeVersionAPIIncompatible(String var1, String var2);

    public String nombreProblemaVersionAPIIncompatible();

    public String solucionInstalarVersionServidor(String var1);

    public String mensajeMundoDuplicado(String var1);

    public String nombreProblemaMundoDuplicado();

    public String solucionEliminarUID(String var1);

    public String solucionEliminarMundo(String var1);

    public String mensajeTickingEntidadBloque(String var1, String var2, int[] var3);

    public String nombreProblemaTickingEntidadBloque();

    public String solucionEliminarEntidadBloque(String var1, int[] var2);

    public String mensajeModDuplicadoFabric(String var1);

    public String nombreProblemaModDuplicadoFabric();

    public String solucionEliminarModDuplicado(String var1);

    public String mensajeModIncompatible(String var1, String var2);

    public String nombreProblemaModIncompatibleFabric();

    public String solucionEliminarMod(String var1);

    public String nombreProblemaModFatal();

    public String mensajeModFatal(String var1);

    public String nombreProblemaDependenciaMod();

    public String solucionInstalarModConVersion(String var1, String var2);

    public String solucionInstalarMod(String var1);

    public String mensajeModDependenciaPlural(List<String> var1);

    public String mensajeDependenciaModFaltante(String var1, String var2, String var3);

    public String mensajePluginTickingRegionalPlural(List<String> var1);

    public String mensajePluginTickingRegionalSingular(String var1);

    public String nombreProblemaPluginTickingRegional();

    public String solucionInstalarSoftwareSinTickingRegional(String var1);

    public String mensajeModFaltanteEnDatapackPlural(List<String> var1);

    public String mensajeModFaltanteEnDatapackSingular(String var1);

    public String nombreProblemaModFaltanteEnDatapack();

    public String mensajeModExcepcionPlural(List<String> var1);

    public String mensajeModExcepcionSingular(String var1);

    public String nombreProblemaModExcepcion();

    public String solucionInstalarVersionDiferenteMod(String var1);

    public String mensajeModIncompatibleConMinecraftPlural(List<String> var1, List<String> var2);

    public String mensajeModIncompatibleConMinecraftSingular(String var1, String var2);

    public String nombreProblemaModIncompatibleConMinecraft();

    public String solucionInstalarVersionForge(String var1);

    public String mensajeDependenciaModFaltante(String var1);

    public String nombreProblemaDependenciaModFaltante();

    public String mensajeWorldModFaltantePlural(List<String> var1);

    public String mensajeWorldModFaltanteSingular(String var1);

    public String nombreProblemaWorldModFaltante();

    public String nombreProblemaVersionModMundo();

    public String mensajeVersionModMundoPlural(List<String> var1, List<String> var2, List<String> var3);

    public String mensajeVersionModMundoSingular(String var1, String var2, String var3);

    public String mensajeVersionDowngrade();

    public String nombreProblemaVersionDowngrade();

    public String solucionVersionDowngrade();

    public String solucionGenerarNuevoMundo();

    public String nombreProblemaDependenciaPluginFaltante();

    public String mensajeDependenciaPluginFaltanteSingular(String var1, String var2);

    public String mensajeDependenciaPluginFaltantePlural(List<String> var1, List<String> var2);

    public String mensajePluginIncompatiblePlural(List<String> var1);

    public String mensajePluginIncompatibleSingular(String var1);

    public String nombreProblemaPluginIncompatible();

    public String mensajePluginEjecucionPlural(List<String> var1);

    public String mensajePluginEjecucionSingular(String var1);

    public String nombreProblemaPluginEjecucion();

    public String nombreLegacyRandomSourceMultiHilos();

    public String mensajeLegacyRandomSourceMultiHilos();

    public String desdeUltimoExito();

    public String noHayCambios();

    public String desdeUltimoIntento();

    public String fallo();

    public String diferentesDeLasMods();

    public String historialDeMods();

    public String archivo0();

    public String archivo1();

    public String comparar();

    public String seleccionarDosArchivos();

    public String archivoExito();

    public String archivoFalla();

    public String errorComparandoArchivos();

    public String comparando();

    public String con();

    public String descripcionPanelHistoriaMods();

    public String tieneErrorIPV6();

    public String parcheIPv4();

    public String carpetaHMCL();

    public String noRegistroLauncherTitulo();

    public String descripcionCurseforge();

    public String descripcionPrism();

    public String descripcionHMCL();

    public String descripcionFenix();

    public String descripcionATLauncher();

    public String descripcionGDLauncher();

    public String descripcionLinksMarkdown();

    public String imagenNoEncontrada();

    public String faltar_de_clases_create();

    public String faltar_de_clases_epicfight();

    public String openJ9NoSoportado();

    public String necesitasJDK11();

    public String memoriaExcesiva();

    public String recomendacionMemoriaExcesiva();

    public String disminuirMemoriaHeap();

    public String forgeArchivosFaltantes(String var1);

    public String forgeVersionNoEncontrada(String var1, String var2);

    public String forgeTargetFmlclientNoEncontrado();

    public String forgeClaseMinecraftFaltante();

    public String forgeInstallacionNoCompleta();

    public String nombre_de_forge_instalacion_no_completa();

    public String solucion_para_forge_instalacion_no_completa();

    public String descargar_forge_oficial();

    public String reinstalar_forge_correctamente();

    public String instrucciones_reinstalar_forge();

    public String titulo_instrucciones_reinstaler_mcforge();

    public String error_enlace_insatisfecho(String var1);

    public String nombre_de_error_enlace_insatisfecho();

    public String solucion_para_error_enlace_insatisfecho();

    public String conflicto_id_colision_especifico(String var1, String var2, String var3);

    public String conflicto_id_maximo();

    public String nombre_de_conflicto_ids();

    public String instalar_justenoughids();

    public String instalar_endlessids();

    public String usar_idfix_minus();

    public String usar_minecraft_id_resolver();

    public String ver_documentacion_jp();

    public String solucion_maximo_rango();

    public String solucion_colision_id();

    public String escanearDeMCreator();

    public String tituloArbolDeMods();

    public String tipoBusqueda();

    public String filtroTodos();

    public String filtroPaquetes();

    public String filtroClases();

    public String filtroMetodos();

    public String filtroCampos();

    public String filtroReferenciasCampo();

    public String filtroReferenciasMetodo();

    public String filtroReferenciasClase();

    public String tipBuscar();

    public String botonBuscar();

    public String botonResetearArbol();

    public String modsCargados();

    public String clases();

    public String metodos();

    public String campos();

    public String referencias();

    public String resultadosBusqueda();

    public String buscarReferencias();

    public String referenciasMod();

    public String referenciasClase();

    public String referenciasMetodo();

    public String referenciasCampo();

    public String noSeEncontraronReferencias();

    public String detalleMod();

    public String ubicacion();

    public String nombres();

    public String modulo();

    public String detalleClase();

    public String detalleMetodo();

    public String detalleCampo();

    public String clase();

    public String tipo();

    public String referenciasAMetodos();

    public String referenciasACampos();

    public String arbolDeMods();

    public String metodo();

    public String campo();

    public String descompilar();

    public String exportar();

    public String importar();

    public String errorImportar();

    public String estructuraImportada();

    public String estructuraExportada();

    public String errorExportar();

    public String exportando();

    public String exportacionTardara();

    public String porFavorEspere();

    public String noTienesVLCBin();

    public String descargar_vlc();

    public String errorCaracteresInvalidosEnNombre(String var1, String var2);

    public String nombre_de_error_caracteres_invalidos();

    public String paso1_caracteres_invalidos(String var1, String var2);

    public String paso2_caracteres_invalidos(String var1);

    public String paso3_caracteres_invalidos();

    public String errorDependenciaModFaltante(String var1);

    public String nombre_de_error_dependencia_mod_faltante();

    public String paso1_dependencia_mod_faltante(String var1);

    public String paso2_dependencia_mod_faltante(String var1);

    public String paso3_dependencia_mod_faltante();

    public String errorAccessTransformerInvalido(String var1);

    public String nombre_de_error_access_transformer_invalido();

    public String paso1_access_transformer_invalido(String var1);

    public String paso2_access_transformer_invalido(String var1);

    public String paso3_access_transformer_invalido();

    public String errorDiscrepanciaModID(String var1);

    public String nombre_de_error_discrepancia_mod_id();

    public String paso1_discrepancia_mod_id(String var1);

    public String paso2_discrepancia_mod_id();

    public String paso3_discrepancia_mod_id();

    public String errorModEnPlataformaIncorrecta(String var1, String var2);

    public String nombre_de_error_mod_plataforma_incorrecta();

    public String paso1_mod_plataforma_incorrecta(String var1, String var2);

    public String paso2_mod_plataforma_incorrecta(String var1);

    public String paso3_mod_plataforma_incorrecta();

    public String errorMetadataModsTomlFaltante(String var1, List<String> var2);

    public String nombre_de_error_metadata_mods_toml_faltante();

    public String paso1_metadata_mods_toml_faltante(String var1, List<String> var2);

    public String paso2_metadata_mods_toml_faltante(String var1);

    public String paso3_metadata_mods_toml_faltante(String var1);

    public String errorSistemaSonido();

    public String nombre_de_error_sistema_sonido();

    public String paso1_sistema_sonido();

    public String paso2_sistema_sonido();

    public String paso3_sistema_sonido();

    public String errorSinListenersEnClase(String var1, List<String> var2);

    public String nombre_de_error_sin_listeners_en_clase();

    public String paso1_sin_listeners_en_clase(String var1, List<String> var2);

    public String paso2_sin_listeners_en_clase(String var1);

    public String paso3_sin_listeners_en_clase(String var1, List<String> var2);

    public String errorUnionFileSystemCorrupto(String var1);

    public String nombre_de_error_union_filesystem_corrupto();

    public String paso1_union_filesystem_corrupto(String var1);

    public String paso2_union_filesystem_corrupto();

    public String paso3_union_filesystem_corrupto();

    public String habilitarProxySysOutSysErrMensaje();

    public String confirmacionTitulo();

    public String proxyHabilitadoMensaje();

    public String informacionTitulo();

    public String errorAzureGeckoLibInicializoPronto(boolean var1, boolean var2, boolean var3);

    public String nombre_de_error_azure_geckolib_inicializo_pronto();

    public String paso1_azure_geckolib_inicializo_pronto();

    public String paso2_azure_geckolib_inicializo_pronto();

    public String errorCompatibilidadC2ME();

    public String nombre_de_error_compatibilidad_c2me();

    public String paso1_compatibilidad_c2me();

    public String paso2_compatibilidad_c2me();

    public String paso3_compatibilidad_c2me();

    public String errorJEIPluginFallido(String var1, String var2, String var3);

    public String nombre_de_error_jei_plugin_fallido();

    public String paso1_jei_plugin_fallido(String var1);

    public String paso2_jei_plugin_fallido(String var1);

    public String paso3_jei_plugin_fallido(String var1);

    public String tituloLectador();

    public String obtenerTituloLeyenda();

    public String obtenerErrorEnLeyenda();

    public String obtenerStacktraceEnLeyenda();

    public String obtenerErrorAlProcesarLinea();

    public String obtenerTituloError();

    public String obtenerNombreError();

    public String obtenerDescripcionError();

    public String obtenerSeleccionarConsola();

    public String obtenerErrorLecturaArchivo();

    public String obtenerNombreErrorPorDefecto();

    public String obtenerDescripcionErrorPorDefecto();

    public String obtenerEtiquetaBotonLectador();

    public String errorRegistroSuscriptoresAutomaticos(String var1, String var2, List<String> var3);

    public String nombre_de_error_registro_suscriptores_automaticos();

    public String paso1_registro_suscriptores_automaticos(String var1, String var2);

    public String paso2_registro_suscriptores_automaticos(String var1, String var2, List<String> var3);

    public String paso3_registro_suscriptores_automaticos(String var1);

    public String paso4_registro_suscriptores_automaticos();

    public String limpiado();

    public String original();

    public String verEnConsola();

    public String advertencia();

    public String fatal();

    public String noRegistroDeBattly();

    public String noRegistroDeNightWorld();

    public String noRegistroDeMCServidor();

    public String errorLexForgeMLTransformerEnNeoForge(String var1, String var2, String var3, List<String> var4);

    public String nombre_de_LexForgeMLTransformerEnNeoForge();

    public String paso1_LexForgeMLTransformerEnNeoForge(String var1, String var2, String var3);

    public String paso2_LexForgeMLTransformerEnNeoForge(List<String> var1);

    public String paso3_LexForgeMLTransformerEnNeoForge();

    public String paso4_LexForgeMLTransformerEnNeoForge();

    public String errorWaterMediaXenonIncompatible(String var1, String var2, List<String> var3);

    public String nombreDeWaterMediaXenonIncompatible();

    public String paso1WaterMediaXenonIncompatible(String var1, String var2);

    public String paso2WaterMediaXenonIncompatible(List<String> var1);

    public String paso3WaterMediaXenonIncompatible();

    public String nombreDeTaczDeflaterCerrado();

    public String errorTaczDeflaterCerrado(List<String> var1);

    public String pasoTaczDeflaterCerrado();

    public String errorFuncionesDeDensidadNoVinculadas(List<String> var1);

    public String nombreDeFuncionesDeDensidadNoVinculadas();

    public String pasoFuncionesDeDensidadNoVinculadas();

    public String nombreDeRailwaysCreate6Alfa();

    public String pasoRailwaysCreate6Alfa();

    public String errorRailwaysCreate6Alfa(String var1);

    public String errorConflictoMultiworldRendimiento();

    public String nombreDeConflictoMultiworldRendimiento();

    public String pasoConflictoMultiworldRendimiento();

    public String problema_con_graficas_sodium();

    public String errorContextoOpenGL();

    public String nombreErrorContextoOpenGL();

    public String paso1ErrorContextoOpenGL();

    public String copiadoAlPortapapeles();

    public String buscarDentroDeComprimidos();

    public String error_resolucion_textura(String var1, String var2);

    public String nombre_de_error_resolucion_textura();

    public String solucion_resolucion_textura();

    public String error_modlauncher_path();

    public String nombre_error_modlauncher_path();

    public String solucion_modlauncher_path();

    public String tituloEditorCodice();

    public String nuevo();

    public String actualizarSeleccionado();

    public String eliminarSeleccionado();

    public String exportarJSON();

    public String guardarTodo();

    public String general();

    public String id();

    public String paraBuscar();

    public String filtro();

    public String criticalidad();

    public String prioridad();

    public String lista();

    public String colIdioma();

    public String colNombre();

    public String colResultado();

    public String vistaJson();

    public String idiomas();

    public String elegirFiltro();

    public String eligeFiltroMsg();

    public String eligeFiltroTitulo();

    public String faltanCampos();

    public String critInvalida();

    public String filtroNoExiste();

    public String faltanIdiomas();

    public String verificacionInvalida();

    public String guardadoOk();

    public String editorCodiceBoton();

    public String descripcionEditorCodice();

    public String guardarAntesDeSalir();

    public String salirSinGuardar();

    public String descartarCambios();

    public String confirmacion();

    public String nombre_error_configuracion_servicio();

    public String paso1_configuracion_servicio(List<String> var1);

    public String paso2_configuracion_servicio();

    public String errorConfiguracionServicio(String var1, List<String> var2);

    public String errorCampoInexistente(String var1, String var2);

    public String nombre_error_campo_inexistente();

    public String paso1_campo_inexistente();

    public String paso2_campo_inexistente();

    public String errorMetodoInexistente(String var1, String var2);

    public String nombre_error_metodo_inexistente();

    public String paso1_metodo_inexistente();

    public String paso2_metodo_inexistente();

    default public String escapeHtml(String s) {
        return s.replace("&", "&amp;").replace("<", "<").replace(">", ">").replace("\"", "&quot;");
    }

    public String mensajeAyudar();

    public String restablecerPlantilla();

    public String restablecer();

    public String restablecerImagenMensjae(String var1);

    public String restablecerPlantillaMensaje();

    public String faltar_de_clases_azurelib();

    public String errorHealightINT();

    public String solucionHealightINT();

    public String nombreErrorHealightINT();

    public String errorMetodoAbstractoNoImplementadoDetallado(String var1, String var2, String var3, String var4);

    public String solucionMetodoAbstractoNoImplementado();

    public String nombreErrorMetodoAbstractoNoImplementado();

    public String errorMetadataAnimacionEnServidor();

    public String solucionErrorMetadataAnimacionEnServidor();

    public String nombreErrorMetadataAnimacionEnServidor();

    public String errorConfiguracionConnectorCorrupta();

    public String solucionConfiguracionConnectorCorrupta();

    public String nombreErrorConfiguracionConnectorCorrupta();

    public String errorJarCorruptoConNombre(String var1);

    public String solucionJarCorrupto();

    public String nombreErrorJarCorruptoConNombre();

    public String errorCargaNBTMundoCorruptoConByte(String var1);

    public String solucionErrorCargaNBTMundoCorrupto();

    public String nombreErrorCargaNBTMundoCorrupto();

    public String problema_con_openAL();

    public String errorArchivoBloqueadoPorOtroProceso();

    public String solucionErrorArchivoBloqueadoPorOtroProceso();

    public String nombreErrorArchivoBloqueadoPorOtroProceso();

    public String errorClaseFinalExtendida(String var1, String var2);

    public String solucionErrorClaseFinalExtendida();

    public String nombreErrorClaseFinalExtendida();

    public String errorRubidiumObsoletoConIris();

    public String solucionRubidiumObsoletoConIris();

    public String nombreErrorRubidiumObsoletoConIris();

    public String errorVoiceChatPuertoOcupado();

    public String solucionErrorVoiceChatPuertoOcupado();

    public String nombreErrorVoiceChatPuertoOcupado();

    public String errorBlockItemNuloCreate(String var1);

    public String solucionErrorBlockItemNuloCreate();

    public String nombreErrorBlockItemNuloCreate();

    public String modIncompatibleConCargadorActivo(List<String> var1);

    public String solucionModIncompatibleConCargadorActivo();

    public String nombreModIncompatibleConCargadorActivo();

    public String errorCreacionModeloFallida(String var1, String var2);

    public String solucionErrorCreacionModeloFallida();

    public String nombreErrorCreacionModeloFallida();

    public String solucionConflictoMoonlightIceberg();

    public String nombreConflictoMoonlightIceberg();

    public String conflictoMoonlightIceberg();

    public String instantanea();

    public Object desdeUltimaInstantanea();

    public String seleccionarUnArchivo();

    public String instantaneaCreadaCorrectamente();

    public String errorCreandoInstantanea();

    public String consejo();

    public String resultadoMuestra();

    public String historaDeModsDesc();

    public String texto_de_boton_compartir_markdown();

    public String error_inesperado_al_compartir();

    public String error_inesperado_al_generar_enlaces();

    public String texto_de_boton_compartir_enlace();

    public String columna_url();

    public String titulo_configuracion();

    public String sin_archivo_para_abrir();

    public String archivo_no_existe_prefijo();

    public String no_se_pudo_abrir_se_copia_ruta();

    public String escritorio_no_soportado_se_copia_ruta();

    public String no_se_pudo_editar_se_copia_ruta();

    public String error_inesperado_al_procesar_boton();

    public String limite_de_solicitudes();

    public String infoDeTrazos();

    public String buscador_canario_de_orden_label();

    public String buscador_canario_de_orden_mensaje_proximamente();

    public String buscador_canario_de_orden_titulo_proximamente();

    public String nombre_de_mods_incompatibles_crash_assistant();

    public String nombre_de_modpack_incompatible_crash_assistant();

    public String advertenciaCrashAssistantModpackIncompatibleFalso();

    public String advertenciaCrashAssistantModsIncompatibles();

    public String advertenciaMalwareFalso();

    public String errorDependenciaSimple(String var1, String var2, String var3);

    public String errorDependenciaNoInstalada(String var1, String var2, String var3);

    public String errorSuperbWarfareIncompatible(String var1, String var2, String var3);

    public String fallo_ejecucion_tarea_descripcion(String var1);

    public String recomendacion_fallos_ejecucion();

    public String info_clase_problematica();

    public String nombre_fallos_ejecucion_tareas();

    public String no_se_encontraron_clases_problema();

    public String errorConflictoOptiFineEMF();

    public String nombreDeConflictoOptiFineEMF();

    public String pasoConflictoOptiFineEMF();

    public String errorConflictoOptiFineFusion();

    public String nombreDeConflictoOptiFineFusion();

    public String pasoConflictoOptiFineFusion();

    public String errorConflictoFlywheelSodium();

    public String nombreDeConflictoFlywheelSodium();

    public String pasoConflictoFlywheelSodium();

    public String errorConflictoOptiFineEpicFight();

    public String nombreDeConflictoOptiFineEpicFight();

    public String pasoConflictoOptiFineEpicFight();

    public String errorConflictoOptiFineRubidium();

    public String nombreDeConflictoOptiFineRubidium();

    public String pasoConflictoOptiFineRubidium();

    public String errorFreeCamServidor();

    public String nombreDeErrorFreeCamServidor();

    public String pasoErrorFreeCamServidor();

    public String errorEntityTextureFeaturesServidor();

    public String nombreDeErrorEntityTextureFeaturesServidor();

    public String pasoErrorEntityTextureFeaturesServidor();

    public String errorEULANoAceptado();

    public String nombreDeErrorEULANoAceptado();

    public String pasoErrorEULANoAceptado();

    public String errorOptiFineServidor();

    public String nombreDeErrorOptiFineServidor();

    public String pasoErrorOptiFineServidor();

    public String errorIronSpellbooksVersion();

    public String nombreDeErrorIronSpellbooksVersion();

    public String pasoErrorIronSpellbooksVersion();

    public String errorConflictoOptiFineEmbeddium();

    public String nombreDeConflictoOptiFineEmbeddium();

    public String pasoConflictoOptiFineEmbeddium();

    public String noPuedeAnalizarJSON();

    public String errorControllableServidor();

    public String nombreDeErrorControllableServidor();

    public String pasoErrorControllableServidor();

    public String errorSupplementariesCargaServidor();

    public String nombreDeErrorSupplementariesCargaServidor();

    public String pasoErrorSupplementariesCargaServidor();

    public String errorGroovyModloaderModuloFaltante();

    public String nombreDeErrorGroovyModloaderModuloFaltante();

    public String pasoErrorGroovyModloaderModuloFaltante();

    public String errorEveryCompatNombreInvalido();

    public String nombreDeErrorEveryCompatNombreInvalido();

    public String pasoErrorEveryCompatNombreInvalido();

    public String nombreDeErrorCodigo1073741819();

    public String pasoErrorCodigo1073741819();

    public String errorCodigo1073741819();

    public String pasoErrorImmersiveTooltipsSinDependencia();

    public String nombreDeErrorImmersiveTooltipsSinDependencia();

    public String errorImmersiveTooltipsSinDependencia();

    public String errorMedievalOriginsCast();

    public String nombreDeErrorMedievalOriginsCast();

    public String pasoErrorMedievalOriginsCast();

    public String errorReignOfNetherMusicManager();

    public String nombreDeErrorReignOfNetherMusicManager();

    public String pasoErrorReignOfNetherMusicManager();

    public String errorYesSteveModelLinux();

    public String nombreDeErrorYesSteveModelLinux();

    public String pasoErrorYesSteveModelLinux();

    public String errorConflictoMovingElevatorsOptiFine();

    public String nombreDeConflictoMovingElevatorsOptiFine();

    public String pasoConflictoMovingElevatorsOptiFine();

    public String errorConflictoFabricAPIOptiFine();

    public String nombreDeConflictoFabricAPIOptiFine();

    public String pasoConflictoFabricAPIOptiFine();

    public String errorModLauncherTransformationService(String var1);

    public String nombreDeErrorModLauncherTransformationService();

    public String pasoErrorModLauncherTransformationService(String var1);

    public String errorVersionInvalidaMod(String var1);

    public String nombreDeErrorVersionInvalidaMod();

    public String pasoErrorVersionInvalidaMod();

    public String errorStackSmashingDetected();

    public String nombreDeErrorStackSmashingDetected();

    public String pasoErrorStackSmashingDetected();

    public String errorVersionClaseGregTechEasyCore();

    public String nombreDeErrorVersionClaseGregTechEasyCore();

    public String pasoErrorVersionClaseGregTechEasyCore();

    public String errorConflictoMoniLabsConnectorExtras();

    public String nombreDeConflictoMoniLabsConnectorExtras();

    public String pasoConflictoMoniLabsConnectorExtras();

    public String pasoErrorCompatibilidadIrisDH();

    public String nombreDeErrorCompatibilidadIrisDH();

    public String errorCompatibilidadIrisDH();

    public String faltar_de_clases_minecraft();

    public String faltar_de_clases_dangerzone();

    public String faltar_de_clases_featurecreep();

    public String faltar_de_clases_modlauncher();

    public String faltar_de_clases_minecraftforge();

    public String faltar_de_clases_neoforged();

    public String faltar_de_clases_fabricloader();

    public String faltar_de_clases_pillowmc();

    public String uraniumLag();

    public String errorFallingAttackVersion();

    public String nombreDeErrorFallingAttackVersion();

    public String pasoErrorFallingAttackVersion();

    public String necesitasInstalarCfr();

    public String cfrNoHayRetrato();

    public String cfrClaseNoEncontrada(String var1);

    public String tituloCfrSakura();

    public String cfrClaseActual();

    public String cfrRetratoDeSakura();

    public String cfrErrorCargarRetrato();

    public String noticiaLegalCFR();

    public String botonDescargarCfr();

    public String botonAbrirCarpetaCfr();

    public String colorFondoPrincipal();

    public String colorTextoBotonReset();

    public String colorTextoCampoBuscar();

    public String colorTextoComboFiltro();

    public String colorTextoRenderer();

    public String colorTextoOverlayCarga();

    public String colorBorde();

    public String colorFondoRetrato();

    public String colorEnlaceCompartir();

    public String colorFondoCampoCompartir();

    public String rosaFondo();

    public String rosaSuave();

    public String moradoAcento();

    public String textoOscuro();

    public String bordeSuave();

    public String fondoCampo();

    public String fondoVistaPrevia();

    public String sintaxisConstructor();

    public String sintaxisMensajeAyudar();

    public String sintaxisEtiquetasHtml();

    public String colorFondoVentana();

    public String colorPanel();

    public String colorBotonTexto();

    public String colorCampo();

    public String colorBordeDestacado();

    public String colorSeleccionTexto();

    public String colorTextoSeleccionado();

    public String colorEstadoExito();

    public String colorEstadoFallo();

    public String colorEstadoInstantanea();

    public String colorResultadoAnadido();

    public String colorResultadoEliminado();

    public String colorBordeScroll();

    public String colorFondoPanel();

    public String colorBeigeListas();

    public String colorTextoListas();

    public String colorBordeListas();

    public String colorBotonFondo();

    public String colorBordeBoton();

    public String colorDoradoTexto();

    public String colorPila();

    public String colorTextoPanel();

    public String colorTextoNegro();

    public String colorTextoPrincipal();

    public String colorEstado();

    public String colorFondoResultados();

    public String colorTextoDescripcion();

    public String colorTextoEstado();

    public String colorTextoExtra();

    public String colorSeparador();

    public String problema_safe_fetch32_jdk17();

    public String nombre_problema_safe_fetch32_jdk17();

    public String solucion_actualizar_jdk_macos();

    public String solucion_usar_lanzador_con_jdk_actualizado();

    public String solucion_desactivar_spark_mod();

    public String problema_mcef_inicializacion_html();

    public String nombre_problema_mcef_inicializacion();

    public String solucion_eliminar_mod_mcef();

    public String solucion_verificar_compatibilidad_mcef();

    public String conflicto_iris_optifine_html();

    public String nombre_conflicto_iris_optifine();

    public String solucion_eliminar_optifine();

    public String solucion_usar_iris_sin_optifine();

    public String conflicto_modernfix_optifine_html();

    public String nombre_conflicto_modernfix_optifine();

    public String solucion_eliminar_optifine_o_modernfix();

    public String solucion_usar_alternativa_modernfix();

    public String error_clave_registro_mayusculas_html(String var1);

    public String nombre_error_clave_registro_mayusculas();

    public String solucion_buscar_clave_en_archivos();

    public String solucion_eliminar_mod_reciente();

    public String error_entrypoint_fabric_html(String var1);

    public String nombre_error_entrypoint_fabric();

    public String solucion_eliminar_mod(String var1);

    public String solucion_actualizar_mod(String var1);

    public String error_en_garde_html();

    public String nombre_error_en_garde();

    public String solucion_actualizar_en_garde();

    public String solucion_eliminar_conflicto_mod_combate();

    public String error_idletweaks_html();

    public String nombre_error_idletweaks();

    public String solucion_actualizar_idletweaks();

    public String solucion_eliminar_idletweaks();

    public String mensagjePirataMC();

    public String infoDeDerechosMiranda();

    public String nombrePirataMC();

    public String desactivarVerificacionPirata();

    public String comprarMC();

    public String lanzer_no_animado_cambiar_a_animado();

    public String nombre_lanzer_no_animado();

    public String lanzer_no_animado_titulo(String var1);

    public String lanzer_no_animado_problemas_comunes();

    public String lanzer_no_animado_usar_animados();

    public String lanzer_desanimado_titulo(String var1);

    public String lanzer_desanimado_problemas_comunes();

    public String lanzer_desanimado_usar_animados();

    public String nombre_lanzer_desanimado();

    public String lanzer_desanimado_cambiar_lanzer();

    public String falta_mod_animado_titulo();

    public String nombre_falta_mod_animado();

    public String falta_mod_animado_instalar();

    public String tienes_mod_desanimado_titulo();

    public String nombre_tienes_mod_desanimado();

    public String tienes_mod_desanimado_eliminar();

    public String antimanipulacion_titulo();

    public String nombre_antimanipulacion();

    public String antimanipulacion_reinstalar();

    public String configuracionCorporativa();

    public String idiomaRespaldo();

    public String buscardorHabilitado();

    public String nombreHerramienta();

    public String condenarPirateria();

    public String lanzadoresRecomendados();

    public String lanzadoresDesaconsejados();

    public String modsRecomendados();

    public String modsDesaconsejados();

    public String errorCargandoImagen();

    public String proximamente();

    public String informacion();

    public String antiTamper();

    public String configuracionBasica();

    public String derechosMiranda();

    public String funcionalidades();

    public String gestionVerificaciones();

    public String idVerificacion();

    public String nombreVerificacion();

    public String codigoVerificacion();

    public String documentacionVerificacion();

    public String mensajeAmaneKanata();

    public String verificacionesHabilitadas();

    public String verificacionesDeshabilitadas();

    public String deshabilitarNoCorporativas();

    public String verCodigo();

    public String verDocumentacion();

    public String seleccionaVerificacionDeshabilitar();

    public String seleccionaVerificacionHabilitar();

    public String verificacionesNoCorporativasDeshabilitadas();

    public String operacionCompletada();

    public String noVerificacionesNoCorporativas();

    public String colorVerificacionCorporativa();

    public String nombreLanzador();

    public String motivo();

    public String moverADesaconsejados();

    public String moverARecomendados();

    public String guardarCambios();

    public String cancelar();

    public String lanzadoresNoRecomendados();

    public String seleccionaLanzadorMover();

    public String cambiosGuardadosExitosamente();

    public String motivoDesaconsejoPredeterminadoEn(String var1);

    public String motivoDesaconsejoPredeterminadoEs(String var1);

    public String motivoDesaconsejoPredeterminadoPt(String var1);

    public String razones();

    public String agregarLanzador();

    public String quitarLanzador();

    public String editarRazones();

    public String seleccionaLanzadorQuitar();

    public String seleccionaLanzadorEditar();

    public String editarRazonesPara(String var1);

    public String agregarNuevoIdioma();

    public String aceptar();

    public String seleccionaCodigoIdioma();

    public String lanzadoresRecomendadosAviso();

    public String colorResultadoCorrecto();

    public String modsNoRecomendados();

    public String modId();

    public String rutaMod();

    public String agregarMod();

    public String quitarMod();

    public String errorDebeIndicarMod();

    public String modsNoRecomendadosAviso();

    public String anularNormal();

    public String anularNormalDescripcion();

    public String modsRecomendadosAviso();

    public String descripcionDerechosPirateria();

    public String editar();

    public String rutaArchivo();

    public String errorRutaFueraDirectorio();

    public String advertenciaHashLento();

    public String agregarArchivo();

    public String agregarCarpeta();

    public String quitar();

    public String mensajeDeSylentBell();

    public String gmlIPV6();

    public String mensajeIndependenteFlywheel(Set<String> var1);

    public String nombreIndependenteFlywheel();

    public String mensajeFloralEnchantments();

    public String nombreFloralEnchantments();

    public String mixinExtrasDuplicados();

    public String mensajeIrisSombrasTerreno();

    public String nombreIrisSombrasTerreno();

    public String mensajeTickLargoServidor();

    public String nombreTickLargoServidor();

    public String tituloLFPDPPP();

    public String aceptarPermanentemente();

    public String actaProteccionIdiomaCultural();

    public String leerLeyCompleta();

    public String errorAbriendoEnlace();

    public String enlaceDocumentacionIdiomaCoreano();

    public String mensajeAdvertenciaIdiomaCoreano();

    public String canarioTitulo();

    public String canario1984Titulo();

    public String revisar();

    public String cerrar();

    public String canarioTodoSeguro();

    public String canarioComprometido(int var1);

    public String colorAlerta();

    public String consolaDesarrollo();

    public String mundial();

    public String ningun();

    public String opcionesMunidiales();

    public String consentimientoLFPDPPP();

    public String habilitarTokenAccesoEnEntregar();

    public String bajar();

    public String logsSoporte();

    public String detenerProceso();

    public String copiarSeleccion();

    public String seleccionarTodo();

    public String copiarTodo();

    public String guardarTodoComoArchivo();

    public String obtenerEnlaceSoporte();

    public String borrarTodo();

    public String consentimientoConfirmadoPendienteImplementacion();

    public String usarSakuraOriginal();

    public String canario1984Descripcion();

    public String gui();

    public String sinOpciones();

    public String confirmacionReEstablarTodos();

    public String seleccionaColor();

    public String botonRestablecerTodo();

    public String botonGuardarTodo();

    public String botonMostrarGUI();

    public String mensajeLuckPermsNoCargado();

    public String nombreLuckPermsNoCargado();

    public String mensajeIrisShaderpackNoEncontrado(String var1);

    public String nombreIrisShaderpackNoEncontrado();

    public String mensajeNightConfigNoSePuedeEscribir(String var1);

    public String nombreNightConfigNoSePuedeEscribir();

    public String mensajeAccesoDenegadoBackupConfig(String var1, String var2);

    public String nombreAccesoDenegadoBackupConfig();
}

