/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector;

import com.asbestosstar.crashdetector.CSVParser;
import com.asbestosstar.crashdetector.CargadorExtensiones;
import com.asbestosstar.crashdetector.ConfigMundial;
import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.Entregar;
import com.asbestosstar.crashdetector.GeneradorDeInformacion;
import com.asbestosstar.crashdetector.Idioma;
import com.asbestosstar.crashdetector.ProxySysOutSysErrCDProceso;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.Transformaciones;
import com.asbestosstar.crashdetector.analizador.Analizador;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.buscar.Buscardor;
import com.asbestosstar.crashdetector.canario.CanarioDeOrdenJudicial;
import com.asbestosstar.crashdetector.canario.pordefecto.CDInformesAsbestosstarEgoismJPCanario;
import com.asbestosstar.crashdetector.canario.pordefecto.CDPasteAsbestosstarEgoismJPCanario;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorLanzer;
import com.asbestosstar.crashdetector.grepr.BusquedaArchivos;
import com.asbestosstar.crashdetector.gui.tipos.TipoGUI;
import com.asbestosstar.crashdetector.gui.tipos.antimanipulacion.AntiManipulacionGUIPanko;
import com.asbestosstar.crashdetector.gui.tipos.aplic.ActaDeProteccionDelIdiomaCulturalDePyongyangGUIKimJongUn;
import com.asbestosstar.crashdetector.gui.tipos.arbol.ArbolDeModsGUIHamu;
import com.asbestosstar.crashdetector.gui.tipos.canario.CanarioDeOrdenJudicialGUI1984;
import com.asbestosstar.crashdetector.gui.tipos.cfr.BuscarParaCFR;
import com.asbestosstar.crashdetector.gui.tipos.cfr.CfrSakuraRiddle;
import com.asbestosstar.crashdetector.gui.tipos.compartir.DialogoCompartirLegacy;
import com.asbestosstar.crashdetector.gui.tipos.config.ConfigPanelEstiloTL;
import com.asbestosstar.crashdetector.gui.tipos.consola.ConsolaDesarrolladorGUI;
import com.asbestosstar.crashdetector.gui.tipos.consola.ConsolaDesarrolladorGUITL;
import com.asbestosstar.crashdetector.gui.tipos.corpo.CorpoSAO;
import com.asbestosstar.crashdetector.gui.tipos.deshablicarverificaciones.DeshabilitarVerificacionesAmaneKanata;
import com.asbestosstar.crashdetector.gui.tipos.editor.EditorCodiceGUIIronMouse;
import com.asbestosstar.crashdetector.gui.tipos.editor_plantilla.EditorPlantillaModioNoche;
import com.asbestosstar.crashdetector.gui.tipos.editor_plantilla.EditorPlantillaPredeterminado;
import com.asbestosstar.crashdetector.gui.tipos.editorgui.CDSkinCape;
import com.asbestosstar.crashdetector.gui.tipos.grepr.BusquedaGUISaliorMoon;
import com.asbestosstar.crashdetector.gui.tipos.historia.ClioOfficeGUI;
import com.asbestosstar.crashdetector.gui.tipos.historia.HistoriaModsGUILegacy;
import com.asbestosstar.crashdetector.gui.tipos.lanzeresbuenos.LanzerBuenoGUIMaidMint;
import com.asbestosstar.crashdetector.gui.tipos.lanzeresmalos.LanzerMaloGUISylentBell;
import com.asbestosstar.crashdetector.gui.tipos.lectador.LectadorDeConsolasHoloTalk;
import com.asbestosstar.crashdetector.gui.tipos.lfpdppp.LeyFederalDeProteccionDeDatosPersonalesEnPosesionDeLosParticularesGUIConLogos;
import com.asbestosstar.crashdetector.gui.tipos.mcreator.EscanerMCreatorGUIRosemiLoveLock;
import com.asbestosstar.crashdetector.gui.tipos.miranda.DerechosPiratasGUIOnePiece;
import com.asbestosstar.crashdetector.gui.tipos.modapi.CDModsEstiloTL;
import com.asbestosstar.crashdetector.gui.tipos.modsbuenas.ModsBuenasGUIReiBubbles;
import com.asbestosstar.crashdetector.gui.tipos.modsmalas.GUIModsMalasRimaEvenstar;
import com.asbestosstar.crashdetector.gui.tipos.no_registro_lanzador.NoRegistroDeLauncherVShojo;
import com.asbestosstar.crashdetector.gui.tipos.no_registro_lanzador.NoRegistroLanzadorGUI;
import com.asbestosstar.crashdetector.gui.tipos.principal.PrincipalGUI;
import com.asbestosstar.crashdetector.gui.tipos.principal.PrincipalGUIEstiloLanzer;
import com.asbestosstar.crashdetector.gui.tipos.quickfix.ElementoQuickFixDemonSlayers;
import com.asbestosstar.crashdetector.gui.tipos.quickfix.PanelQuickFixDemonSlayers;
import com.sun.management.OperatingSystemMXBean;
import java.awt.GraphicsEnvironment;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class MonitorDePID {
    public static final String mensaje_de_registro_lanzer_completo = "Puedes ignorar esta linea, solo es para CrashDetector, este mensaje es siempre en espanol";
    public static File ArchivoDeCodigoError0 = Statics.carpeta.resolve("ArchivoDeCodigoError0").toFile();
    public static Path ultimo_mods = Statics.carpeta.resolve("ultima_mods");
    public static List<Consola> consolas = new ArrayList<Consola>();
    public static String nl = System.lineSeparator();
    public static Idioma idioma = Idioma.detectar();
    public static String local;
    public static String enlace;
    public static long pid;
    public static boolean resultados;
    public static boolean consola_de_launcher_inyectado;
    public static StringBuilder contenidoInforme;
    public static Analizador analizador;
    public static Object consola_des;
    public static Instant utc;

    public static void main(String[] args) {
        String jar;
        MonitorDePID.registrarGUISPredeterminado();
        DetectorLanzer.registrarLanzeresDefectos();
        if (args.length > 0 && args[0].equals("--monitor")) {
            long pid = Long.parseLong(args[1]);
            MonitorDePID.monitor_proceso(pid);
            return;
        }
        if (args.length > 0 && (args[0].equals("grepr") || args[0].equals("fgrepr"))) {
            int index;
            boolean useRegex = args[0].equals("grepr");
            boolean caseInsensitive = false;
            String searchString = "";
            String directory = System.getProperty("user.dir");
            for (index = 1; index < args.length; ++index) {
                String arg = args[index];
                if (arg.equals("-i")) {
                    caseInsensitive = true;
                    continue;
                }
                if (!arg.equals("--help")) break;
                MonitorDePID.mostrarAyudaCLI();
                return;
            }
            if (index >= args.length) {
                System.out.println("Error: Falta cadena de b\u00fasqueda");
                MonitorDePID.mostrarAyudaCLI();
                return;
            }
            searchString = args[index++];
            if (index < args.length) {
                directory = args[index];
            }
            List<String> resultados = BusquedaArchivos.buscar(directory, searchString, useRegex, caseInsensitive);
            for (String res : resultados) {
                System.out.println(res);
            }
            return;
        }
        ArchivoDeCodigoError0.delete();
        String mods = "";
        if (ultimo_mods.toFile().exists()) {
            try {
                mods = MonitorDePID.leer_archivo(ultimo_mods);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        File html = Statics.carpeta.resolve("pantilla.htm").toFile();
        MonitorDePID.copiarACarpetaDesdeJar("/pantilla.htm", html);
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/gura.png", Statics.carpeta.resolve("imagenes/gura.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/clio.png", Statics.carpeta.resolve("imagenes/clio.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/hamu.png", Statics.carpeta.resolve("imagenes/hamu.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/nanashi_mumei.png", Statics.carpeta.resolve("imagenes/nanashi_mumei.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/shion.png", Statics.carpeta.resolve("imagenes/shion.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/vshojo.png", Statics.carpeta.resolve("imagenes/vshojo.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/rosemi.png", Statics.carpeta.resolve("imagenes/rosemi.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/kiara_ame.png", Statics.carpeta.resolve("imagenes/kiara_ame.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/ironmouse.png", Statics.carpeta.resolve("imagenes/ironmouse.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/padoru.gif", Statics.carpeta.resolve("imagenes/padoru.gif").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/demonslayers.png", Statics.carpeta.resolve("imagenes/demonslayers.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/boton_agregar.png", Statics.carpeta.resolve("imagenes/boton_agregar.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/boton_compartir.png", Statics.carpeta.resolve("imagenes/boton_compartir.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/boton_compartir_icon.png", Statics.carpeta.resolve("imagenes/boton_compartir_icon.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/boton_actualizar.png", Statics.carpeta.resolve("imagenes/boton_actualizar.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/boton_archivos.png", Statics.carpeta.resolve("imagenes/boton_archivos.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/boton_config.png", Statics.carpeta.resolve("imagenes/boton_config.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/boton_cdmods.png", Statics.carpeta.resolve("imagenes/boton_cdmods.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/cd_chars.png", Statics.carpeta.resolve("imagenes/cd_chars.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/cd_logo.png", Statics.carpeta.resolve("imagenes/cd_logo.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/profeco.jpg", Statics.carpeta.resolve("imagenes/profeco.jpg").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/edps.png", Statics.carpeta.resolve("imagenes/edps.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/ppc_jp.png", Statics.carpeta.resolve("imagenes/ppc_jp.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/dprk.png", Statics.carpeta.resolve("imagenes/dprk.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/kimjongun.png", Statics.carpeta.resolve("imagenes/kimjongun.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/saliormoongrep.png", Statics.carpeta.resolve("imagenes/saliormoongrep.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/bandera_mexico.png", Statics.carpeta.resolve("imagenes/bandera_mexico.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/bandera_inglaterra.png", Statics.carpeta.resolve("imagenes/bandera_inglaterra.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/bandera_arabia.png", Statics.carpeta.resolve("imagenes/bandera_arabia.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/bandera_brasil.png", Statics.carpeta.resolve("imagenes/bandera_brasil.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/bandera_iran.png", Statics.carpeta.resolve("imagenes/bandera_iran.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/bandera_rusia.png", Statics.carpeta.resolve("imagenes/bandera_rusia.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/bandera_china.png", Statics.carpeta.resolve("imagenes/bandera_china.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/bandera_esperanto.png", Statics.carpeta.resolve("imagenes/bandera_esperanto.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/bandera_japon.png", Statics.carpeta.resolve("imagenes/bandera_japon.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/bandera_corea.png", Statics.carpeta.resolve("imagenes/bandera_corea.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/mod.png", Statics.carpeta.resolve("imagenes/mod.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/clase.png", Statics.carpeta.resolve("imagenes/clase.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/metodo.png", Statics.carpeta.resolve("imagenes/metodo.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/campo.png", Statics.carpeta.resolve("imagenes/campo.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/paquete.png", Statics.carpeta.resolve("imagenes/paquete.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/referencia_metodo.png", Statics.carpeta.resolve("imagenes/referencia_metodo.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/referencia_campo.png", Statics.carpeta.resolve("imagenes/referencia_campo.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/sabalifecruel.png", Statics.carpeta.resolve("imagenes/sabalifecruel.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/sakura_riddle.png", Statics.carpeta.resolve("imagenes/sakura_riddle.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/sao.png", Statics.carpeta.resolve("imagenes/sao.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/amane_kanata.png", Statics.carpeta.resolve("imagenes/amane_kanata.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/rima_evenstar.png", Statics.carpeta.resolve("imagenes/rima_evenstar.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/maid_mint.png", Statics.carpeta.resolve("imagenes/maid_mint.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/sylent_bell.png", Statics.carpeta.resolve("imagenes/sylent_bell.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/onepeice.png", Statics.carpeta.resolve("imagenes/onepeice.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/rei_bubbles.png", Statics.carpeta.resolve("imagenes/rei_bubbles.png").toFile());
        MonitorDePID.copiarACarpetaDesdeJar("/imagenes/panko.png", Statics.carpeta.resolve("imagenes/panko.png").toFile());
        StringBuilder actuales = new StringBuilder();
        boolean primera = true;
        for (Path ub : Statics.carpetas_de_mods) {
            File dir = ub.toFile();
            if (!dir.exists() || !dir.isDirectory()) {
                CrashDetectorLogger.log(dir.getAbsolutePath() + idioma.carpeta_de_mods_no_valido());
                continue;
            }
            File[] archivosMods = dir.listFiles();
            if (archivosMods == null) {
                CrashDetectorLogger.log(dir.getAbsolutePath() + idioma.carpeta_de_mods_no_valido());
                continue;
            }
            for (File archivoMod : archivosMods) {
                if (!archivoMod.isFile()) continue;
                if (primera) {
                    primera = false;
                } else {
                    actuales.append(nl);
                }
                String pathCompleta = archivoMod.getAbsolutePath();
                actuales.append(pathCompleta);
            }
        }
        File um_archivo = new File(ultimo_mods.toString());
        um_archivo.delete();
        try {
            um_archivo.createNewFile();
            FileWriter escribidor = new FileWriter(ultimo_mods.toFile());
            escribidor.write(actuales.toString());
            escribidor.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        CargadorExtensiones.cargarExtensionesProcesoApp(um_archivo);
        Entregar.comenzarEntregar();
        long pid = MonitorDePID.obtenerPID();
        System.out.println("PID: " + pid);
        try {
            URI uriJar = MonitorDePID.class.getProtectionDomain().getCodeSource().getLocation().toURI();
            String uriJarString = uriJar.toString();
            if (uriJarString.startsWith("union:")) {
                uriJarString = uriJarString.replace("union:", "file://");
            }
            if (uriJarString.startsWith("jar:")) {
                uriJarString = uriJarString.substring(4);
            }
            CrashDetectorLogger.log(uriJarString);
            URI cd_uri = new URI(uriJarString);
            String cd_uri_path = cd_uri.getPath();
            CrashDetectorLogger.log(cd_uri_path);
            jar = new File(cd_uri_path).getAbsolutePath().split(".jar")[0] + ".jar";
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(idioma.no_se_donde_esta_jar());
            return;
        }
        String javaBinary = MonitorDePID.jvm();
        if (javaBinary == null || javaBinary.isEmpty()) {
            System.err.println("CD NO PUEDE OBTENER JVM");
            return;
        }
        System.out.println("JVM " + javaBinary);
        try {
            String cp = MonitorDePID.obtenerClassPath(jar);
            ProcessBuilder pb = new ProcessBuilder(javaBinary, MonitorDePID.obtenerXMXPorMitadDeRAM(), "-cp", cp, "com.asbestosstar.crashdetector.MonitorDePID", "--monitor", String.valueOf(pid));
            pb.start();
        }
        catch (Exception e) {
            System.out.println("error con comenzando el proceso CD");
            e.printStackTrace();
        }
        System.out.println("completa con comenzando el proceso CD");
    }

    public static String obtenerClassPath(String jar) {
        StringBuilder classPath = new StringBuilder(System.getProperty("java.class.path"));
        if (jar != null && !jar.isEmpty()) {
            classPath.append(File.pathSeparator).append(jar);
        }
        try {
            File cfrJar = BuscarParaCFR.encontrarCfr();
            if (cfrJar != null && cfrJar.exists()) {
                String rutaCfr = cfrJar.getAbsolutePath();
                if (!classPath.toString().contains(rutaCfr)) {
                    classPath.append(File.pathSeparator).append(rutaCfr);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return classPath.toString();
    }

    public static void registrarGUISPredeterminado() {
        TipoGUI.PRINCIPAL.registrarGUI(PrincipalGUIEstiloLanzer.ID, () -> new PrincipalGUIEstiloLanzer());
        TipoGUI.CONFIG_PANEL.registrarGUI(ConfigPanelEstiloTL.ID, () -> new ConfigPanelEstiloTL());
        TipoGUI.TODOS_QUICKFIXES.registrarGUI(PanelQuickFixDemonSlayers.ID, () -> new PanelQuickFixDemonSlayers());
        TipoGUI.NO_REGISTRO_LANZER.registrarGUI(NoRegistroDeLauncherVShojo.ID, () -> new NoRegistroDeLauncherVShojo());
        TipoGUI.ESCANER_MCREATOR.registrarGUI("rosemi_lovelock", () -> new EscanerMCreatorGUIRosemiLoveLock());
        TipoGUI.LECTADOR_DE_CONSOLAS.registrarGUI(LectadorDeConsolasHoloTalk.ID, () -> new LectadorDeConsolasHoloTalk());
        TipoGUI.HISTORIA_DE_MODS.registrarGUI(HistoriaModsGUILegacy.ID, () -> new HistoriaModsGUILegacy());
        TipoGUI.HISTORIA_DE_MODS.registrarGUI(ClioOfficeGUI.ID, () -> new ClioOfficeGUI());
        TipoGUI.GREPR.registrarGUI("saliormoon_grep", () -> new BusquedaGUISaliorMoon());
        TipoGUI.EDITOR_FIRMAS.registrarGUI(EditorCodiceGUIIronMouse.ID, () -> new EditorCodiceGUIIronMouse());
        TipoGUI.ARBOL_DE_MODS.registrarGUI(ArbolDeModsGUIHamu.ID, () -> new ArbolDeModsGUIHamu());
        TipoGUI.EDITOR_PLANTILLA.registrarGUI("editor_plantilla_predeterminado", () -> new EditorPlantillaPredeterminado());
        TipoGUI.EDITOR_PLANTILLA.registrarGUI("editor_plantilla_modio_noche", () -> new EditorPlantillaModioNoche());
        TipoGUI.DIALOGO_COMPARTIR.registrarGUI(DialogoCompartirLegacy.ID, () -> new DialogoCompartirLegacy());
        TipoGUI.EDITOR_GUI.registrarGUI(CDSkinCape.ID, () -> new CDSkinCape());
        TipoGUI.MOD_API_PANEL.registrarGUI(CDModsEstiloTL.ID, () -> new CDModsEstiloTL());
        TipoGUI.CFR.registrarGUI("sakura_riddle", () -> new CfrSakuraRiddle());
        TipoGUI.CORPO.registrarGUI(CorpoSAO.ID, () -> new CorpoSAO());
        TipoGUI.DESHABLICAR_VERIFICACIONES.registrarGUI(DeshabilitarVerificacionesAmaneKanata.ID, () -> new DeshabilitarVerificacionesAmaneKanata());
        TipoGUI.LANZER_MALO.registrarGUI(LanzerMaloGUISylentBell.ID, () -> new LanzerMaloGUISylentBell());
        TipoGUI.LANZER_BUENO.registrarGUI(LanzerBuenoGUIMaidMint.ID, () -> new LanzerBuenoGUIMaidMint());
        TipoGUI.MODS_MALAS.registrarGUI("rima_evenstar", () -> new GUIModsMalasRimaEvenstar());
        TipoGUI.MODS_BUENAS.registrarGUI("rei_bubbles", () -> new ModsBuenasGUIReiBubbles());
        TipoGUI.MIRANDA.registrarGUI("one_piece", () -> new DerechosPiratasGUIOnePiece());
        TipoGUI.ANTI_MANIPULACION.registrarGUI("komachi_panko", () -> new AntiManipulacionGUIPanko());
        TipoGUI.LFPDPPP.registrarGUI(LeyFederalDeProteccionDeDatosPersonalesEnPosesionDeLosParticularesGUIConLogos.ID, () -> new LeyFederalDeProteccionDeDatosPersonalesEnPosesionDeLosParticularesGUIConLogos());
        TipoGUI.APLIC.registrarGUI(ActaDeProteccionDelIdiomaCulturalDePyongyangGUIKimJongUn.ID, () -> new ActaDeProteccionDelIdiomaCulturalDePyongyangGUIKimJongUn());
        TipoGUI.CANARIO.registrarGUI(CanarioDeOrdenJudicialGUI1984.ID, () -> new CanarioDeOrdenJudicialGUI1984());
        TipoGUI.CONSOLA_DESARROLLADOR.registrarGUI(ConsolaDesarrolladorGUITL.ID, () -> new ConsolaDesarrolladorGUITL());
        TipoGUI.QUICKFIX.registrarGUI("demonslayers_elemento", () -> new ElementoQuickFixDemonSlayers());
    }

    private static void monitor_proceso(long pid) {
        block16: {
            MonitorDePID.abrirConsola();
            ProxySysOutSysErrCDProceso.init();
            MonitorDePID.pid = pid;
            try {
                Transformaciones.init();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (ultimo_mods.toFile().exists()) {
                CargadorExtensiones.cargarExtensionesProcesoMonitor(ultimo_mods.toFile());
            }
            System.out.println(idioma.buscando_para_pid(pid));
            Entregar.recibir();
            if (Statics.INICIO_DE_LA_APP > 0L) {
                try {
                    utc = Instant.ofEpochMilli(Statics.INICIO_DE_LA_APP);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            CountDownLatch latch = new CountDownLatch(1);
            while (MonitorDePID.viva(pid)) {
            }
            System.out.println(idioma.pid_esta_muerto(pid));
            System.out.println(mensaje_de_registro_lanzer_completo);
            CrashDetectorLogger.log(idioma.pid_esta_muerto(pid));
            CrashDetectorLogger.log("Finalizando Contento de Consolas");
            List<Consola> consolas_sin_processando = Consola.obtenerConsolas();
            if (!ArchivoDeCodigoError0.exists() && !Consola.tiene_registro_de_launcher(consolas_sin_processando)) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break block16;
                }
            }
            for (Consola consola : consolas_sin_processando) {
                consola.finalizarContenido(utc, false);
                if (!consola.nueva) continue;
                consolas.add(consola);
            }
            if (MonitorDePID.activar() && !GraphicsEnvironment.isHeadless() && !Consola.tiene_registro_de_launcher(consolas)) {
                MonitorDePID.obtenerConsolaDeLauncher(utc);
            }
            MonitorDePID.historia_mods();
            Instant luego = Instant.now();
            MonitorDePID.recargar(true, luego);
            System.gc();
            if (MonitorDePID.activar()) {
                CrashDetectorLogger.log("activar ");
                if (GraphicsEnvironment.isHeadless()) {
                    CrashDetectorLogger.log("headless ");
                    System.out.println(idioma.local_headless(enlace));
                    MonitorDePID.fin(latch);
                } else {
                    MonitorDePID.registrarCanariosPorDefecto();
                    CrashDetectorLogger.log("no headless ");
                    PrincipalGUI gui = TipoGUI.PRINCIPAL.obtenerGUIPredeterminado(PrincipalGUIEstiloLanzer.ID, () -> new PrincipalGUIEstiloLanzer());
                    CrashDetectorLogger.log("tiene principal gui");
                    SwingUtilities.invokeLater(() -> gui.constructir(utc, latch));
                }
            } else {
                MonitorDePID.fin(latch);
            }
        }
    }

    public static void abrirConsola() {
        if (!GraphicsEnvironment.isHeadless() && consola_des == null) {
            if (ConfigMundial.obtenerInstancia().obtenerConsolaDesarrollo()) {
                ConsolaDesarrolladorGUI cons = TipoGUI.CONSOLA_DESARROLLADOR.obtenerGUIPredeterminado(ConsolaDesarrolladorGUITL.ID, () -> new ConsolaDesarrolladorGUITL());
                consola_des = cons;
                cons.init();
            }
        } else {
            System.out.println("No se puede abrir la consola: se ha detectado un entorno sin interfaz gr\u00e1fica.");
        }
    }

    private static void registrarCanariosPorDefecto() {
        CanarioDeOrdenJudicial.canarios.add(new CDPasteAsbestosstarEgoismJPCanario());
        CanarioDeOrdenJudicial.canarios.add(new CDInformesAsbestosstarEgoismJPCanario());
    }

    public static void fin(CountDownLatch latch) {
        ArchivoDeCodigoError0.delete();
        latch.countDown();
        System.exit(0);
    }

    public static void historia_mods() {
        try {
            Path directorioHistorial = Statics.carpeta.resolve("historia_mods");
            Files.createDirectories(directorioHistorial, new FileAttribute[0]);
            File[] archivosHistorial = directorioHistorial.toFile().listFiles();
            int siguienteNumero = 0;
            if (archivosHistorial != null) {
                for (File archivo : archivosHistorial) {
                    int num;
                    String nombre = archivo.getName();
                    if (!nombre.matches("\\d{6}\\.falla") && !nombre.matches("\\d{6}\\.exito") || (num = Integer.parseInt(nombre.substring(0, 6))) < siguienteNumero) continue;
                    siguienteNumero = num + 1;
                }
            }
            String extension = MonitorDePID.activar() ? "falla" : "exito";
            String nombreArchivo = String.format("%06d.%s", siguienteNumero, extension);
            Path archivoHistorial = directorioHistorial.resolve(nombreArchivo);
            if (ultimo_mods.toFile().exists()) {
                String contenido = new String(Files.readAllBytes(ultimo_mods), StandardCharsets.UTF_8);
                Files.write(archivoHistorial, contenido.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
        }
        catch (IOException e) {
            CrashDetectorLogger.log("Error al crear historial de modlist: " + e.getMessage());
        }
    }

    private static void finalizarConsolasLentas(Instant luego) {
        if (Consola.tiene_registro_de_launcher(consolas) && !consola_de_launcher_inyectado) {
            Duration duration = Duration.between(luego, Instant.now());
            CrashDetectorLogger.log("reincinar finalizacion " + duration.getSeconds());
            for (Consola consola : consolas) {
                consola.finalizarContenido(utc, false);
            }
        }
    }

    public static String analizar(List<Consola> consolas) {
        analizador = new Analizador();
        analizador.analizar(consolas);
        return analizador.toString();
    }

    public static String leer_archivo(Path path) throws IOException {
        return new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
    }

    public static boolean activar() {
        for (Consola cons : consolas) {
            if (cons.archivo.toString().contains("crash-reports")) {
                return true;
            }
            for (Verificaciones ver : Analizador.verificaciones) {
                if (!ver.activado() || !ver.anularNormal()) continue;
                return true;
            }
        }
        return !ArchivoDeCodigoError0.exists();
    }

    public static void obtenerConsolaDeLauncher(Instant utc) {
        JFrame frame_blanco = new JFrame();
        frame_blanco.setUndecorated(true);
        frame_blanco.setSize(0, 0);
        frame_blanco.setLocationRelativeTo(null);
        frame_blanco.setVisible(true);
        final CountDownLatch templach = new CountDownLatch(1);
        NoRegistroLanzadorGUI noreg = TipoGUI.NO_REGISTRO_LANZER.obtenerGUIPredeterminado(NoRegistroDeLauncherVShojo.ID, () -> new NoRegistroDeLauncherVShojo());
        SwingUtilities.invokeLater(() -> {
            noreg.preparar(frame_blanco, utc);
            noreg.init();
            noreg.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    templach.countDown();
                }
            });
        });
        try {
            templach.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        frame_blanco.dispose();
    }

    private static void mostrarAyudaCLI() {
        System.out.println("Uso: java -jar CrashDetectorMC.jar [grepr|fgrepr] [-i] <cadena> [directorio]");
        System.out.println("  grepr: Busca usando regex (por defecto)");
        System.out.println("  fgrepr: Busca sin regex");
        System.out.println("  -i: Ignorar may\u00fasculas/min\u00fasculas");
    }

    public static long obtenerPID() {
        String nombre = ManagementFactory.getRuntimeMXBean().getName();
        return Long.parseLong(nombre.split("@")[0]);
    }

    public static String jvm() {
        try {
            Method isPresentMethod;
            boolean isPresent;
            Class<?> processHandleClass = Class.forName("java.lang.ProcessHandle");
            Method ofMethod = processHandleClass.getMethod("of", Long.TYPE);
            Object optionalHandle = ofMethod.invoke(null, MonitorDePID.obtenerPID());
            if (optionalHandle != null && (isPresent = ((Boolean)(isPresentMethod = optionalHandle.getClass().getMethod("isPresent", new Class[0])).invoke(optionalHandle, new Object[0])).booleanValue())) {
                Method isPresentOpt;
                boolean commandPresent;
                Method getMethod = optionalHandle.getClass().getMethod("get", new Class[0]);
                Object processHandle = getMethod.invoke(optionalHandle, new Object[0]);
                Method infoMethod = processHandleClass.getMethod("info", new Class[0]);
                Object processInfo = infoMethod.invoke(processHandle, new Object[0]);
                Class<?> infoClass = Class.forName("java.lang.ProcessHandle$Info");
                Method commandMethod = infoClass.getMethod("command", new Class[0]);
                Object commandOpt = commandMethod.invoke(processInfo, new Object[0]);
                if (commandOpt != null && (commandPresent = ((Boolean)(isPresentOpt = commandOpt.getClass().getMethod("isPresent", new Class[0])).invoke(commandOpt, new Object[0])).booleanValue())) {
                    Method getOpt = commandOpt.getClass().getMethod("get", new Class[0]);
                    return (String)getOpt.invoke(commandOpt, new Object[0]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return MonitorDePID.obtenerRutaEjecutable8();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String obtenerRutaEjecutable8() {
        try {
            String sistemaOperativo = System.getProperty("os.name").toLowerCase();
            if (sistemaOperativo.contains("win")) {
                String linea;
                ProcessBuilder pb = new ProcessBuilder("powershell", "Get-WmiObject -Class Win32_Process -Filter \"ProcessId = " + MonitorDePID.obtenerPID() + "\" | Select-Object -ExpandProperty ExecutablePath");
                Process proceso = pb.start();
                try (BufferedReader lector = new BufferedReader(new InputStreamReader(proceso.getInputStream()));){
                    while ((linea = lector.readLine()) != null) {
                        String limpiado = linea.trim();
                        if (limpiado.isEmpty()) continue;
                        String string = limpiado;
                        return string;
                    }
                }
                pb = new ProcessBuilder("tasklist", "/FI", "PID eq " + MonitorDePID.obtenerPID(), "/FO", "CSV", "/NH");
                proceso = pb.start();
                lector = new BufferedReader(new InputStreamReader(proceso.getInputStream()));
                try {
                    while ((linea = lector.readLine()) != null) {
                        if (linea.trim().isEmpty()) continue;
                        String[] valores = new CSVParser().parsear(linea);
                        if (valores.length <= 0 || valores[0].trim().isEmpty()) continue;
                        String string = valores[0].trim();
                        return string;
                    }
                }
                finally {
                    lector.close();
                }
            }
            ProcessBuilder pb = new ProcessBuilder("ps", "-p", String.valueOf(MonitorDePID.obtenerPID()), "-o", "comm=");
            Process proceso = pb.start();
            try (BufferedReader lector = new BufferedReader(new InputStreamReader(proceso.getInputStream()));){
                String linea;
                while ((linea = lector.readLine()) != null) {
                    String limpiado = linea.trim();
                    if (limpiado.isEmpty()) continue;
                    String string = limpiado;
                    return string;
                }
            }
            return null;
        }
        catch (Exception e) {
            System.err.println("Error al obtener ruta ejecutable: " + e.getMessage());
            return null;
        }
    }

    public static boolean viva(long pid) {
        try {
            Method isPresentMethod;
            boolean existe;
            Class<?> processHandleClase = Class.forName("java.lang.ProcessHandle");
            Method meth = processHandleClase.getMethod("of", Long.TYPE);
            Object optionalHandle = meth.invoke(null, pid);
            if (optionalHandle != null && (existe = ((Boolean)(isPresentMethod = optionalHandle.getClass().getMethod("isPresent", new Class[0])).invoke(optionalHandle, new Object[0])).booleanValue())) {
                Method getMethod = optionalHandle.getClass().getMethod("get", new Class[0]);
                Object processHandle = getMethod.invoke(optionalHandle, new Object[0]);
                Method estaViviaMeth = processHandle.getClass().getMethod("isAlive", new Class[0]);
                return (Boolean)estaViviaMeth.invoke(processHandle, new Object[0]);
            }
            return false;
        }
        catch (Exception e) {
            return MonitorDePID.viva8(pid);
        }
    }

    public static boolean viva8(long pid) {
        block4: {
            try {
                String os = System.getProperty("os.name").toLowerCase();
                if (os.contains("win")) {
                    ProcessBuilder pb = new ProcessBuilder("powershell", "try { Get-Process -Id " + pid + " -ErrorAction Stop; exit 0 } catch { exit 1 }");
                    Process proceso = pb.start();
                    int codigoSalida = proceso.waitFor();
                    if (codigoSalida == 0) {
                        return true;
                    }
                    break block4;
                }
                ProcessBuilder pb = new ProcessBuilder("ps", "-p", String.valueOf(pid));
                Process proceso = pb.start();
                int codigoSalida = proceso.waitFor();
                return codigoSalida == 0;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static void copiarACarpetaDesdeJar(String ubicacionEnJar, File resultado) {
        block25: {
            if (resultado.exists()) {
                if (resultado.length() > 0L) {
                    return;
                }
                if (resultado.length() == 0L && !resultado.delete()) {
                    CrashDetectorLogger.log("No se pudo eliminar el archivo vac\u00edo para recrearlo: " + resultado.getAbsolutePath());
                    return;
                }
            } else {
                resultado.getParentFile().mkdirs();
            }
            File archivoTemporal = null;
            try {
                CrashDetectorLogger.log("Cargando imagen " + resultado.getAbsolutePath());
                archivoTemporal = new File(resultado.getParentFile(), resultado.getName() + ".tmp");
                try (InputStream inputStream = MonitorDePID.class.getResourceAsStream(ubicacionEnJar);
                     FileOutputStream outputStream = new FileOutputStream(archivoTemporal);){
                    int bytesRead;
                    if (inputStream == null) {
                        throw new RuntimeException("Recurso no encontrado en el JAR: " + ubicacionEnJar);
                    }
                    byte[] buffer = new byte[8192];
                    while ((bytesRead = inputStream.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, bytesRead);
                    }
                }
                if (archivoTemporal.length() == 0L) {
                    throw new IOException("El recurso se escribi\u00f3 como archivo vac\u00edo: " + ubicacionEnJar);
                }
                if (resultado.exists() && !resultado.delete()) {
                    CrashDetectorLogger.log("No se pudo eliminar archivo previo para reemplazar: " + resultado.getAbsolutePath());
                    return;
                }
                if (!archivoTemporal.renameTo(resultado)) {
                    Files.copy(archivoTemporal.toPath(), resultado.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    Files.delete(archivoTemporal.toPath());
                }
            }
            catch (Exception e) {
                CrashDetectorLogger.log("Error al extraer recurso " + ubicacionEnJar + " al disco: " + e.getMessage());
                if (archivoTemporal == null || !archivoTemporal.exists()) break block25;
                try {
                    Files.delete(archivoTemporal.toPath());
                }
                catch (IOException ex) {
                    CrashDetectorLogger.log("No se pudo limpiar el archivo temporal: " + archivoTemporal.getAbsolutePath());
                }
            }
        }
    }

    public static void recargar(boolean finalizar_contento, Instant luego) {
        StringBuilder constructor = new StringBuilder();
        Buscardor.mods.clear();
        Buscardor.cargado = false;
        Buscardor.cargadotodos = false;
        if (finalizar_contento) {
            MonitorDePID.finalizarConsolasLentas(luego);
        }
        for (Consola consola : consolas) {
            consola.verificacion_de_stacktrace = new VerificacionDeStackTrace(consola);
            consola.enlaces.clear();
        }
        CrashDetectorLogger.log("Analyzador Consolas");
        String res = MonitorDePID.analizar(consolas);
        if (res.replace(" ", "").equals("")) {
            constructor.append(idioma.noResultados());
        } else {
            constructor.append(res);
            resultados = true;
        }
        contenidoInforme = constructor;
        local = GeneradorDeInformacion.generarLocal(consolas, utc).getAbsolutePath();
    }

    public static String obtenerXMXPorMitadDeRAM() {
        try {
            OperatingSystemMXBean os = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            long memoriaTotalBytes = os.getTotalPhysicalMemorySize();
            if (memoriaTotalBytes <= 0L) {
                System.out.println("0 ram");
                return "-Xmx4096m";
            }
            long mitadMemoriaBytes = memoriaTotalBytes / 2L;
            long mitadMemoriaMB = mitadMemoriaBytes / 0x100000L;
            if (mitadMemoriaMB < 512L) {
                mitadMemoriaMB = 512L;
            }
            System.out.println("ram " + mitadMemoriaMB);
            return "-Xmx" + mitadMemoriaMB + "m";
        }
        catch (Exception e) {
            System.out.println("fgb ram");
            return "-Xmx4096m";
        }
    }

    static {
        resultados = false;
        consola_de_launcher_inyectado = false;
        analizador = new Analizador();
        consola_des = null;
        utc = Instant.now();
    }
}

