/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class MultiMap<K, V> {
    private final Map<K, List<V>> mapa = new ConcurrentHashMap<K, List<V>>();

    public void put(K clave, V valor) {
        this.mapa.computeIfAbsent(clave, k -> new CopyOnWriteArrayList()).add(valor);
    }

    public List<V> get(K clave) {
        List<V> lista = this.mapa.get(clave);
        return lista == null ? new CopyOnWriteArrayList() : new CopyOnWriteArrayList<V>(lista);
    }

    public boolean removeValue(K clave, V valor) {
        List<V> lista = this.mapa.get(clave);
        if (lista == null) {
            return false;
        }
        boolean eliminado = lista.remove(valor);
        if (lista.isEmpty()) {
            this.mapa.remove(clave);
        }
        return eliminado;
    }

    public void remove(K clave) {
        this.mapa.remove(clave);
    }

    public void clear() {
        this.mapa.clear();
    }

    public boolean containsKey(K clave) {
        return this.mapa.containsKey(clave);
    }

    public int size() {
        return this.mapa.size();
    }
}

