/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector;

import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.gui.tipos.no_registro_lanzador.NoRegistroDeLauncherVShojo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class ProxySysOutSysErr {
    public static File archivoLog = NoRegistroDeLauncherVShojo.cd_launcherlog;
    public static FileOutputStream flujoArchivo;
    public static OutputStream flujoSincronizadoSeguro;

    public static void init() {
        Config config = Config.obtenerInstancia();
        boolean condicion = config.obtenerProxySysOutSysErr() || !config.propiedadesConfig.containsKey("0351");
        System.err.println("[ProxySysOutSysErr] Condici\u00f3n de init: " + condicion + " (proxyHabilitado=" + config.obtenerProxySysOutSysErr() + ", tiene0351=" + config.propiedadesConfig.containsKey("0351") + ")");
        try {
            flujoSincronizadoSeguro = new OutputStream(){
                private final Object cerrojo = new Object();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void write(int b) throws IOException {
                    Object object = this.cerrojo;
                    synchronized (object) {
                        try {
                            flujoArchivo.write(b);
                        }
                        catch (IOException e) {
                            ProxySysOutSysErr.manejarErrorRegistro(e, "archivo");
                            throw e;
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    Object object = this.cerrojo;
                    synchronized (object) {
                        try {
                            flujoArchivo.write(b, off, len);
                        }
                        catch (IOException e) {
                            ProxySysOutSysErr.manejarErrorRegistro(e, "archivo");
                            throw e;
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void flush() throws IOException {
                    Object object = this.cerrojo;
                    synchronized (object) {
                        flujoArchivo.flush();
                    }
                }

                @Override
                public void close() {
                }
            };
            PrintStream salidaOriginal = System.out;
            PrintStream errorOriginal = System.err;
            OutputStream flujoSalidaCombinado = ProxySysOutSysErr.crearFlujoCombinado(flujoSincronizadoSeguro, salidaOriginal, "salida");
            OutputStream flujoErrorCombinado = ProxySysOutSysErr.crearFlujoCombinado(flujoSincronizadoSeguro, errorOriginal, "error");
            System.setOut(new PrintStream(flujoSalidaCombinado, true));
            System.setErr(new PrintStream(flujoErrorCombinado, true));
            config.guardarProxySysOutSysErr(true);
            if (!config.propiedadesConfig.containsKey("0351")) {
                config.propiedadesConfig.put("0351", "true");
            }
            System.err.println("[ProxySysOutSysErr] Proxy inicializado. Escribiendo en: " + archivoLog.getAbsolutePath());
        }
        catch (Throwable t) {
            System.err.println("[CR\u00cdTICO] Fall\u00f3 inicializaci\u00f3n de ProxySysOutSysErr: " + t.getMessage());
            t.printStackTrace();
        }
    }

    private static OutputStream crearFlujoCombinado(final OutputStream flujoArchivo, final PrintStream flujoConsola, final String tipoFlujo) {
        return new OutputStream(){

            @Override
            public void write(int b) {
                try {
                    flujoArchivo.write(b);
                }
                catch (IOException e) {
                    ProxySysOutSysErr.manejarErrorRegistro(e, tipoFlujo + "-archivo");
                }
                ProxySysOutSysErr.escribirEnConsolaSeguro(flujoConsola, b);
            }

            @Override
            public void write(byte[] b, int off, int len) {
                try {
                    flujoArchivo.write(b, off, len);
                }
                catch (IOException e) {
                    ProxySysOutSysErr.manejarErrorRegistro(e, tipoFlujo + "-archivo");
                }
                try {
                    flujoConsola.write(b, off, len);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }

            @Override
            public void flush() {
                try {
                    flujoArchivo.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                flujoConsola.flush();
            }
        };
    }

    private static void escribirEnConsolaSeguro(PrintStream flujo, int b) {
        try {
            flujo.write(b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void manejarErrorRegistro(IOException e, String origen) {
        try {
            String mensaje = String.format("[REGISTRO FALLIDO][%s] %s: %s", Thread.currentThread().getName(), origen, e.getMessage());
            System.err.println(mensaje);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        try {
            archivoLog.delete();
            archivoLog.createNewFile();
            flujoArchivo = new FileOutputStream(archivoLog, false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

