/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector;

import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.ConfigMundial;
import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.gui.tipos.consola.ConsolaDesarrolladorGUI;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class ProxySysOutSysErrCDProceso {
    private static final StringBuilder lineaActual = new StringBuilder();
    private static final List<String> bufferConsola = new ArrayList<String>();

    public static void init() {
        if (!Config.obtenerInstancia().obtenerProxySysOutSysErr()) {
            return;
        }
        File archivoLog = new File(CrashDetectorLogger.LOG_FILE_PATH);
        try {
            final FileOutputStream flujoArchivo = new FileOutputStream(archivoLog, false);
            final OutputStream flujoArchivoSeguro = new OutputStream(){
                private final Object cerrojo = new Object();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void write(int b) throws IOException {
                    Object object = this.cerrojo;
                    synchronized (object) {
                        flujoArchivo.write(b);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void flush() throws IOException {
                    Object object = this.cerrojo;
                    synchronized (object) {
                        flujoArchivo.flush();
                    }
                }

                @Override
                public void close() throws IOException {
                    this.flush();
                }
            };
            final PrintStream salidaOriginal = System.out;
            final PrintStream errorOriginal = System.err;
            OutputStream flujoSalidaCombinado = new OutputStream(){

                @Override
                public void write(int b) {
                    try {
                        flujoArchivoSeguro.write(b);
                    }
                    catch (IOException e) {
                        ProxySysOutSysErrCDProceso.manejarErrorRegistro(e, "salida");
                    }
                    ProxySysOutSysErrCDProceso.escribirEnConsolaSeguro(salidaOriginal, b);
                    ProxySysOutSysErrCDProceso.consumirByteParaConsola(b);
                }

                @Override
                public void flush() {
                    try {
                        flujoArchivoSeguro.flush();
                    }
                    catch (IOException e) {
                        ProxySysOutSysErrCDProceso.manejarErrorRegistro(e, "salida");
                    }
                    salidaOriginal.flush();
                }
            };
            OutputStream flujoErrorCombinado = new OutputStream(){

                @Override
                public void write(int b) {
                    try {
                        flujoArchivoSeguro.write(b);
                    }
                    catch (IOException e) {
                        ProxySysOutSysErrCDProceso.manejarErrorRegistro(e, "error");
                    }
                    ProxySysOutSysErrCDProceso.escribirEnConsolaSeguro(errorOriginal, b);
                    ProxySysOutSysErrCDProceso.consumirByteParaConsola(b);
                }

                @Override
                public void flush() {
                    try {
                        flujoArchivoSeguro.flush();
                    }
                    catch (IOException e) {
                        ProxySysOutSysErrCDProceso.manejarErrorRegistro(e, "error");
                    }
                    errorOriginal.flush();
                }
            };
            System.setOut(new PrintStream(flujoSalidaCombinado, true));
            System.setErr(new PrintStream(flujoErrorCombinado, true));
        }
        catch (FileNotFoundException e) {
            System.err.println("ERROR: No se pudo abrir archivo de registro: " + e.getMessage());
        }
    }

    private static synchronized void consumirByteParaConsola(int b) {
        if (b == 10) {
            String linea = lineaActual.toString();
            lineaActual.setLength(0);
            if (!linea.trim().isEmpty()) {
                ProxySysOutSysErrCDProceso.enviarALaConsola(linea);
            }
            return;
        }
        if (b != 13) {
            lineaActual.append((char)b);
        }
    }

    private static synchronized void enviarALaConsola(String linea) {
        try {
            if (!ConfigMundial.obtenerInstancia().obtenerConsolaDesarrollo()) {
                return;
            }
            ConsolaDesarrolladorGUI consola = ProxySysOutSysErrCDProceso.consola();
            if (consola == null) {
                bufferConsola.add(linea);
                return;
            }
            if (!bufferConsola.isEmpty()) {
                for (String l : bufferConsola) {
                    consola.agregarLinea(l);
                }
                bufferConsola.clear();
            }
            consola.agregarLinea(linea);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static ConsolaDesarrolladorGUI consola() {
        try {
            return (ConsolaDesarrolladorGUI)MonitorDePID.consola_des;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static void escribirEnConsolaSeguro(PrintStream flujo, int dato) {
        try {
            flujo.write(dato);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void manejarErrorRegistro(IOException e, String tipoFlujo) {
        try {
            System.err.println("[CRITICO] Fallo en registro de " + tipoFlujo + ": " + e.getMessage());
        }
        catch (Throwable t) {
            try {
                new FileOutputStream(FileDescriptor.err).write(("[FALLA TOTAL] Registro " + tipoFlujo + " inaccesible\n").getBytes());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

