/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector;

import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.parches.Parche;
import com.asbestosstar.crashdetector.parches.TransASM;
import com.asbestosstar.crashdetector.parches.minecraft.ParcheWaterMediaTL;
import com.asbestosstar.crashdetector.parches.minecraft.PreferIPv4StackParch;
import com.asbestosstar.crashdetector.parches.minecraft.TransformacionDeMinecraftCodigo0;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;

public class Transformaciones
implements ClassFileTransformer {
    public static void init() {
        if (Transformaciones.hayASM()) {
            Parche.parches.add(new TransformacionDeMinecraftCodigo0());
            Parche.parches.add(new ParcheWaterMediaTL());
            Parche.parches.add(new PreferIPv4StackParch());
        }
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        byte[] bytes = Parche.aplicarParches(classfileBuffer, className);
        if (Transformaciones.hayASM()) {
            bytes = TransASM.obtenerBytes(className, bytes);
        }
        return bytes;
    }

    public static boolean hayASM() {
        try {
            Class.forName("org.objectweb.asm.tree.ClassNode", false, Transformaciones.class.getClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            CrashDetectorLogger.log("No ASM");
            return false;
        }
    }
}

