/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.analizador.Criticalidad;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.AuditorTransformer;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.AzureGeckoLibInicializoPronto;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.BloqueTeselado;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ConflictoDeIDsMinecraft;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ConflictoFabricAPIOptiFine;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ConflictoFlywheelRubidium;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ConflictoIrisOptifine;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ConflictoModernFixOptifine;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ConflictoMoniLabsConnectorExtras;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ConflictoMoonlightIceberg;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ConflictoMovingElevatorsOptiFine;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ConflictoMultiworldRendimiento;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ConflictoOptiFineEMF;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ConflictoOptiFineEmbeddium;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ConflictoOptiFineEpicFight;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ConflictoOptiFineFusion;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ConflictoOptiFineRubidium;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.CursedConsola;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.EarlyWindow;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorAccessTransformerInvalido;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorBlockItemNuloCreate;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorCargaClaseEntornoInvalido;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorCargaNBTMundoCorrupto;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorClaveRegistroMayusculas;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorCodigo1073741819;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorCompatibilidadIrisDH;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorConfiguracionConnectorCorrupta;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorConfiguracionMCForge;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorConfiguracionServicioIDependencyLocator;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorControllableServidor;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorCreacionModeloFallida;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorDependenciaModFaltante;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorDiscrepanciaModID;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorEULANoAceptado;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorEnGarde;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorEntityTextureFeaturesServidor;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorEveryCompatNombreInvalido;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorFallingAttackVersion;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorFreeCamServidor;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorGroovyModloaderModuloFaltante;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorHealightINT;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorIdleTweaks;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorImmersiveTooltipsSinDependencia;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorIronSpellbooksVersion;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorJEIPluginFallido;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorMedievalOriginsCast;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorMetadataAnimacionEnServidor;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorMetadataModsTomlFaltante;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorModLauncherTransformationService;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorOptiFineServidor;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorRegistroSuscriptoresAutomaticos;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorReignOfNetherMusicManager;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorResolucionDeTextura;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorRubidiumObsoletoConIris;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorRutaModLauncher;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorSinListenersEnClase;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorSistemaSonido;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorSupplementariesCargaServidor;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorUnionFileSystemCorrupto;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorVersionClaseGregTechEasyCore;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorVoiceChatPuertoOcupado;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ErrorYesSteveModelLinux;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.FabricMCRuntimeErrorProvidedBy;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.FaltasDependenciasModLaunche;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.FloralEnchantmentsTagKeyNull;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.FuncionesDeDensidadNoVinculadas;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.IndependenteFlywheel;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.IrisShaderpackNoEncontrado;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.IrisSombrasTerreno;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.KubeJSResourcePack;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.LegacyRandomSourceMultiHilos;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.LenguajeProveedorCheck;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.LexForgeMLTransformerEnNeoForge;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.LuckPermsNoCargado;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.MCForgeInstallacionNoEstaCompleta;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.MCForgeModsSuspechoso;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.MalwareFalsoCrashAssistant;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ModsDuplicadosModLauncher;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.NecesitasSodium;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.NightConfigNoSePuedeEscribir;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.NoPuedeAnalizarJSONDeRegistro;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.NoSuchElementAnimacionMinecraft;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.OptifineObsoleta;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.PirataMC;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ProblemaCargaChunk;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ProblemaCargaMultiverso;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ProblemaCierreAuthMe;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ProblemaConfiguracionPermissionsEx;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ProblemaDependenciaModFabric;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ProblemaDependenciaPTRLib;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ProblemaDependenciaPlugin;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ProblemaDependenciaPluginPocketMine;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ProblemaEjecucionPlugin;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ProblemaExcepcionComandoPlugin;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ProblemaMCEFInicializacion;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ProblemaModDuplicadoFabric;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ProblemaModFaltanteEnDatapack;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ProblemaModFaltanteEnMundo;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ProblemaModIncompatibleConMinecraft;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ProblemaModIncompatibleFabric;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ProblemaMundoDuplicado;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ProblemaNombrePluginAmbiguo;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ProblemaSpongeMixinFabric;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ProblemaTickingEntidadBloque;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ProblemaTickingRegionalPlugin;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ProblemaVersionAPIIncompatible;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ProblemaVersionDowngrade;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ProblemaVersionModMundo;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.RailwaysCreate6Alfa;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.RegistrosMalMapeados;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.SCOErrorCompatibilidadC2ME;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.Segundo60Tick;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.ServicioDeModLauncherNoFunciona;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.TaczDeflaterCerrado;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.Theseus;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.TickLargoServidorMinecraft;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.UraniumLag;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.WaterMediaTL;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.WaterMediaVLC;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.WaterMediaXenonIncompatible;
import com.asbestosstar.crashdetector.analizador.firmas.CargadorDeCodice;
import com.asbestosstar.crashdetector.analizador.general.AccesoDenegadoBackupConfig;
import com.asbestosstar.crashdetector.analizador.general.AdvertenciaFaltasClases;
import com.asbestosstar.crashdetector.analizador.general.AntiManipulacion;
import com.asbestosstar.crashdetector.analizador.general.ContenidoDeTrazos;
import com.asbestosstar.crashdetector.analizador.general.DifDeMods;
import com.asbestosstar.crashdetector.analizador.general.Drivers;
import com.asbestosstar.crashdetector.analizador.general.ErrorArchivoBloqueadoPorOtroProceso;
import com.asbestosstar.crashdetector.analizador.general.ErrorCampoInexistente;
import com.asbestosstar.crashdetector.analizador.general.ErrorCaracteresInvalidosEnNombre;
import com.asbestosstar.crashdetector.analizador.general.ErrorClaseFinalExtendida;
import com.asbestosstar.crashdetector.analizador.general.ErrorContextoOpenGL;
import com.asbestosstar.crashdetector.analizador.general.ErrorDeEnlaceInsatisfecho;
import com.asbestosstar.crashdetector.analizador.general.ErrorDeMonitorLWJGL;
import com.asbestosstar.crashdetector.analizador.general.ErrorEntrypointFabric;
import com.asbestosstar.crashdetector.analizador.general.ErrorJarCorruptoConNombre;
import com.asbestosstar.crashdetector.analizador.general.ErrorMetodoAbstractoNoImplementado;
import com.asbestosstar.crashdetector.analizador.general.ErrorMetodoInexistente;
import com.asbestosstar.crashdetector.analizador.general.ErrorStackSmashingDetected;
import com.asbestosstar.crashdetector.analizador.general.ErrorVersionInvalidaModMaven;
import com.asbestosstar.crashdetector.analizador.general.FallosEjecucionTareas;
import com.asbestosstar.crashdetector.analizador.general.FaltaModAnimado;
import com.asbestosstar.crashdetector.analizador.general.FaltaModuleJPMS;
import com.asbestosstar.crashdetector.analizador.general.FaltasClases;
import com.asbestosstar.crashdetector.analizador.general.JavaVersiones;
import com.asbestosstar.crashdetector.analizador.general.LanzerDesAnimado;
import com.asbestosstar.crashdetector.analizador.general.LanzerNoAnimado;
import com.asbestosstar.crashdetector.analizador.general.ModIncompatibleConCargadorActivo;
import com.asbestosstar.crashdetector.analizador.general.ModulesDuplicadosJavaModulePlatform;
import com.asbestosstar.crashdetector.analizador.general.NoTieneMemoria;
import com.asbestosstar.crashdetector.analizador.general.NullPointer;
import com.asbestosstar.crashdetector.analizador.general.OpcionesJavaGCInvalidas;
import com.asbestosstar.crashdetector.analizador.general.PreferIPV4Trace;
import com.asbestosstar.crashdetector.analizador.general.ProblemaSafeFetch32JDK17;
import com.asbestosstar.crashdetector.analizador.general.SpongeMixinConfigsProblematicos;
import com.asbestosstar.crashdetector.analizador.general.TienesModDesAnimado;
import com.asbestosstar.crashdetector.buscar.Buscardor;
import com.asbestosstar.crashdetector.config.ConfigStringArray;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nullable;

public class Analizador {
    public static HashSet<Verificaciones> verificaciones = new HashSet();
    public HashSet<Verificaciones> verificaciones_normales_activadas = new LinkedHashSet<Verificaciones>();
    public HashSet<Verificaciones> verificaciones_tardias_activadas = new LinkedHashSet<Verificaciones>();
    public HashSet<Verificaciones> verificaciones_activados = new LinkedHashSet<Verificaciones>();
    private static final String CONFIG_CLAVE_LISTA_DENEGACION = "verificaciones.lista_de_denegacion";
    public static final ConfigStringArray CONFIG_LISTA_DENEGACION = ConfigStringArray.de("verificaciones.lista_de_denegacion", new ArrayList<String>());
    private static final Set<Class<? extends Verificaciones>> CLASES_TARDIAS_REGISTRADAS = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final Set<String> IDS_TARDIAS_REGISTRADAS = Collections.newSetFromMap(new ConcurrentHashMap());

    public static void registrarVerificacionTardia(Class<? extends Verificaciones> clase) {
        if (clase != null) {
            CLASES_TARDIAS_REGISTRADAS.add(clase);
        }
    }

    public static void registrarVerificacionesTardias(List<Class<? extends Verificaciones>> clases) {
        if (clases != null) {
            for (Class<? extends Verificaciones> c : clases) {
                if (c == null) continue;
                CLASES_TARDIAS_REGISTRADAS.add(c);
            }
        }
    }

    public static void registrarVerificacionTardiaPorId(String idOClase) {
        if (idOClase != null && !idOClase.isEmpty()) {
            IDS_TARDIAS_REGISTRADAS.add(idOClase);
        }
    }

    public Analizador() {
        Object denegadas = CONFIG_LISTA_DENEGACION.obtener();
        for (Verificaciones ver : verificaciones) {
            boolean esTardia;
            String id = ver.id();
            if (denegadas.contains(id)) {
                CrashDetectorLogger.log("Verificaci\u00f3n '" + id + "' est\u00e1 en la lista de denegaci\u00f3n; se desactiva.");
                continue;
            }
            Verificaciones instancia = ver.nueva();
            boolean bl = esTardia = CLASES_TARDIAS_REGISTRADAS.contains(instancia.getClass()) || IDS_TARDIAS_REGISTRADAS.contains(id) || IDS_TARDIAS_REGISTRADAS.contains(instancia.getClass().getName()) || IDS_TARDIAS_REGISTRADAS.contains(instancia.getClass().getSimpleName());
            if (esTardia) {
                this.verificaciones_tardias_activadas.add(instancia);
                continue;
            }
            this.verificaciones_normales_activadas.add(instancia);
        }
        this.verificaciones_activados.addAll(this.verificaciones_normales_activadas);
        this.verificaciones_activados.addAll(this.verificaciones_tardias_activadas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analizar(List<Consola> consolas) {
        Buscardor.cargar();
        CrashDetectorLogger.log("Iniciando an\u00e1lisis de " + consolas.size() + " registros");
        int hilos = Math.max(1, 2 * Runtime.getRuntime().availableProcessors());
        CrashDetectorLogger.log("Analizador paralelo (normales) con hilos=" + hilos);
        ThreadFactory fabrica = r -> {
            Thread t = new Thread(r, "Analizador-Normal-" + r.hashCode());
            t.setDaemon(true);
            return t;
        };
        ExecutorService pool = Executors.newFixedThreadPool(hilos, fabrica);
        try {
            for (Consola consola : consolas) {
                int end;
                int start;
                CrashDetectorLogger.log("comenz analiz");
                consola.verificacion_de_stacktrace.reiniciar();
                CrashDetectorLogger.log("reinciar vdst");
                CrashDetectorLogger.log("Analizando registro: " + consola.archivo.getFileName());
                String[] lineas = consola.contenido_verificar.split(Verificaciones.nl);
                ArrayList<Callable<Void>> tareasPre = new ArrayList<Callable<Void>>(this.verificaciones_normales_activadas.size());
                for (Verificaciones ver : this.verificaciones_normales_activadas) {
                    tareasPre.add(() -> {
                        try {
                            CrashDetectorLogger.log(consola.archivo + " " + ver.nombre());
                            ver.verificar(consola);
                        }
                        catch (Exception e) {
                            CrashDetectorLogger.logException(e);
                        }
                        return null;
                    });
                }
                try {
                    pool.invokeAll(tareasPre);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    CrashDetectorLogger.logException(ie);
                }
                Verificaciones[] normales = this.verificaciones_normales_activadas.toArray(new Verificaciones[0]);
                int total = lineas.length;
                int chunks = Math.min(total, Math.max(hilos * 4, 1));
                int chunkSize = (total + chunks - 1) / chunks;
                ArrayList<Callable<Void>> tareasLineas = new ArrayList<Callable<Void>>(chunks);
                for (int c = 0; c < chunks && (start = c * chunkSize) < (end = Math.min(total, start + chunkSize)); ++c) {
                    tareasLineas.add(() -> {
                        for (int i = start; i < end; ++i) {
                            String linea = lineas[i];
                            for (Verificaciones ver : normales) {
                                try {
                                    Verificaciones verificaciones = ver;
                                    synchronized (verificaciones) {
                                        ver.verificar(consola, linea, i);
                                    }
                                }
                                catch (Exception e) {
                                    CrashDetectorLogger.logException(e);
                                }
                            }
                        }
                        return null;
                    });
                }
                try {
                    pool.invokeAll(tareasLineas);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    CrashDetectorLogger.logException(ie);
                }
                for (Verificaciones ver : this.verificaciones_tardias_activadas) {
                    try {
                        CrashDetectorLogger.log(consola.archivo + " (tard\u00eda) " + ver.nombre());
                        ver.verificar(consola);
                    }
                    catch (Exception e) {
                        CrashDetectorLogger.logException(e);
                    }
                }
                for (Verificaciones ver : this.verificaciones_tardias_activadas) {
                    for (int i = 0; i < lineas.length; ++i) {
                        try {
                            ver.verificar(consola, lineas[i], i);
                            continue;
                        }
                        catch (Exception e) {
                            CrashDetectorLogger.logException(e);
                        }
                    }
                }
            }
        }
        finally {
            pool.shutdown();
        }
    }

    public Set<Verificaciones> organizar(Set<Verificaciones> vers) {
        ArrayList<Verificaciones> ret = new ArrayList<Verificaciones>(vers);
        ret.sort((v1, v2) -> Float.compare(v2.prioridad(), v1.prioridad()));
        return new LinkedHashSet<Verificaciones>(ret);
    }

    public Set<Verificaciones> obtenerVerificacionesUnion() {
        LinkedHashSet<Verificaciones> union = new LinkedHashSet<Verificaciones>();
        union.addAll(this.verificaciones_normales_activadas);
        union.addAll(this.verificaciones_tardias_activadas);
        return this.organizar(union);
    }

    public Set<Verificaciones> obtenerActivados() {
        LinkedHashSet<Verificaciones> act = new LinkedHashSet<Verificaciones>();
        for (Verificaciones ver : this.obtenerVerificacionesUnion()) {
            if (!ver.activado()) continue;
            act.add(ver);
        }
        return act;
    }

    public String toString() {
        StringBuilder constructor = new StringBuilder();
        constructor.append("<ol>");
        for (Verificaciones ver : this.obtenerActivados()) {
            constructor.append("<li>").append(ver.comoString()).append("</li>");
            CrashDetectorLogger.log("razon " + ver.mensaje());
        }
        constructor.append("</ol>");
        return constructor.toString();
    }

    public List<QuickFix> obtenerSoluciones() {
        ArrayList<QuickFix> soluciones = new ArrayList<QuickFix>();
        for (Verificaciones ver : this.obtenerActivados()) {
            if (ver.solucion() == null || ver.solucion().equals(QuickFix.NINGUN)) continue;
            soluciones.add(ver.solucion());
        }
        return soluciones;
    }

    @Nullable
    public QuickFix obtenerQuickFixConEnlace(String enlace) {
        for (QuickFix sol : this.obtenerSoluciones()) {
            if (!sol.obtenerEnlace().equals(enlace)) continue;
            return sol;
        }
        return null;
    }

    static {
        Analizador.registrarVerificacionTardia(ContenidoDeTrazos.class);
        Analizador.registrarVerificacionTardia(AdvertenciaFaltasClases.class);
        CrashDetectorLogger.log(Criticalidad.ADVERTENCIA.toString() + " buscando para advertencias ");
        verificaciones.add(new SpongeMixinConfigsProblematicos());
        verificaciones.add(new NoSuchElementAnimacionMinecraft());
        verificaciones.add(new PreferIPV4Trace());
        verificaciones.add(new RegistrosMalMapeados());
        verificaciones.add(new ModulesDuplicadosJavaModulePlatform());
        verificaciones.add(new FaltaModuleJPMS());
        verificaciones.add(new ModsDuplicadosModLauncher());
        verificaciones.add(new LenguajeProveedorCheck());
        verificaciones.add(new WaterMediaTL());
        verificaciones.add(new WaterMediaVLC());
        verificaciones.add(new NoPuedeAnalizarJSONDeRegistro());
        verificaciones.add(new BloqueTeselado());
        verificaciones.add(new OptifineObsoleta());
        verificaciones.add(new ServicioDeModLauncherNoFunciona());
        verificaciones.add(new FabricMCRuntimeErrorProvidedBy());
        verificaciones.add(new MCForgeModsSuspechoso());
        verificaciones.add(new JavaVersiones());
        verificaciones.add(new FaltasClases());
        verificaciones.add(new Drivers());
        verificaciones.add(new ErrorDeMonitorLWJGL());
        verificaciones.add(new OpcionesJavaGCInvalidas());
        verificaciones.add(new ErrorConfiguracionMCForge());
        verificaciones.add(new EarlyWindow());
        verificaciones.add(new NecesitasSodium());
        verificaciones.add(new FaltasDependenciasModLaunche());
        verificaciones.add(new KubeJSResourcePack());
        verificaciones.add(new Segundo60Tick());
        verificaciones.add(new NoTieneMemoria());
        verificaciones.add(new Theseus());
        verificaciones.add(new CursedConsola());
        verificaciones.add(new NullPointer());
        verificaciones.add(new ContenidoDeTrazos());
        verificaciones.add(new AuditorTransformer());
        verificaciones.add(new AdvertenciaFaltasClases());
        verificaciones.add(new MalwareFalsoCrashAssistant());
        verificaciones.add(new LegacyRandomSourceMultiHilos());
        verificaciones.add(new ProblemaCargaChunk());
        verificaciones.add(new ProblemaCierreAuthMe());
        verificaciones.add(new ProblemaCargaMultiverso());
        verificaciones.add(new ProblemaConfiguracionPermissionsEx());
        verificaciones.add(new ProblemaDependenciaPlugin());
        verificaciones.add(new ProblemaDependenciaPluginPocketMine());
        verificaciones.add(new ProblemaDependenciaPTRLib());
        verificaciones.add(new ProblemaEjecucionPlugin());
        verificaciones.add(new ProblemaExcepcionComandoPlugin());
        verificaciones.add(new ProblemaSpongeMixinFabric());
        verificaciones.add(new ProblemaModDuplicadoFabric());
        verificaciones.add(new ProblemaModFaltanteEnDatapack());
        verificaciones.add(new ProblemaModFaltanteEnMundo());
        verificaciones.add(new ProblemaModIncompatibleConMinecraft());
        verificaciones.add(new ProblemaModIncompatibleFabric());
        verificaciones.add(new ProblemaMundoDuplicado());
        verificaciones.add(new ProblemaNombrePluginAmbiguo());
        verificaciones.add(new ProblemaTickingEntidadBloque());
        verificaciones.add(new ProblemaTickingRegionalPlugin());
        verificaciones.add(new ProblemaVersionAPIIncompatible());
        verificaciones.add(new ProblemaVersionDowngrade());
        verificaciones.add(new ProblemaVersionModMundo());
        verificaciones.add(new ProblemaDependenciaModFabric());
        verificaciones.add(new MCForgeInstallacionNoEstaCompleta());
        verificaciones.add(new ErrorDeEnlaceInsatisfecho());
        verificaciones.add(new ConflictoDeIDsMinecraft());
        verificaciones.add(new ErrorCaracteresInvalidosEnNombre());
        verificaciones.add(new ErrorDependenciaModFaltante());
        verificaciones.add(new ErrorAccessTransformerInvalido());
        verificaciones.add(new ErrorDiscrepanciaModID());
        verificaciones.add(new ErrorCargaClaseEntornoInvalido());
        verificaciones.add(new ErrorMetadataModsTomlFaltante());
        verificaciones.add(new ErrorSistemaSonido());
        verificaciones.add(new ErrorSinListenersEnClase());
        verificaciones.add(new ErrorUnionFileSystemCorrupto());
        verificaciones.add(new ErrorRegistroSuscriptoresAutomaticos());
        verificaciones.add(new AzureGeckoLibInicializoPronto());
        verificaciones.add(new SCOErrorCompatibilidadC2ME());
        verificaciones.add(new ErrorJEIPluginFallido());
        verificaciones.add(new LexForgeMLTransformerEnNeoForge());
        verificaciones.add(new WaterMediaXenonIncompatible());
        verificaciones.add(new TaczDeflaterCerrado());
        verificaciones.add(new FuncionesDeDensidadNoVinculadas());
        verificaciones.add(new RailwaysCreate6Alfa());
        verificaciones.add(new ConflictoMultiworldRendimiento());
        verificaciones.add(new ErrorContextoOpenGL());
        verificaciones.add(new ErrorResolucionDeTextura());
        verificaciones.add(new ErrorRutaModLauncher());
        verificaciones.add(new ErrorConfiguracionServicioIDependencyLocator());
        verificaciones.add(new ErrorCampoInexistente());
        verificaciones.add(new ErrorMetodoInexistente());
        verificaciones.add(new ErrorHealightINT());
        verificaciones.add(new ErrorMetodoAbstractoNoImplementado());
        verificaciones.add(new ErrorMetadataAnimacionEnServidor());
        verificaciones.add(new ErrorConfiguracionConnectorCorrupta());
        verificaciones.add(new ErrorJarCorruptoConNombre());
        verificaciones.add(new ErrorCargaNBTMundoCorrupto());
        verificaciones.add(new ErrorArchivoBloqueadoPorOtroProceso());
        verificaciones.add(new ErrorClaseFinalExtendida());
        verificaciones.add(new ErrorRubidiumObsoletoConIris());
        verificaciones.add(new ErrorVoiceChatPuertoOcupado());
        verificaciones.add(new ErrorBlockItemNuloCreate());
        verificaciones.add(new ModIncompatibleConCargadorActivo());
        verificaciones.add(new ErrorCreacionModeloFallida());
        verificaciones.add(new ConflictoMoonlightIceberg());
        verificaciones.add(new FallosEjecucionTareas());
        verificaciones.add(new ConflictoOptiFineEMF());
        verificaciones.add(new ConflictoOptiFineFusion());
        verificaciones.add(new ConflictoFlywheelRubidium());
        verificaciones.add(new ConflictoOptiFineEpicFight());
        verificaciones.add(new ConflictoOptiFineRubidium());
        verificaciones.add(new ErrorFreeCamServidor());
        verificaciones.add(new ErrorEntityTextureFeaturesServidor());
        verificaciones.add(new ErrorEULANoAceptado());
        verificaciones.add(new ErrorOptiFineServidor());
        verificaciones.add(new ErrorIronSpellbooksVersion());
        verificaciones.add(new ConflictoOptiFineEmbeddium());
        verificaciones.add(new ErrorControllableServidor());
        verificaciones.add(new ErrorSupplementariesCargaServidor());
        verificaciones.add(new ErrorGroovyModloaderModuloFaltante());
        verificaciones.add(new ErrorEveryCompatNombreInvalido());
        verificaciones.add(new ErrorCodigo1073741819());
        verificaciones.add(new ErrorImmersiveTooltipsSinDependencia());
        verificaciones.add(new ErrorMedievalOriginsCast());
        verificaciones.add(new ErrorReignOfNetherMusicManager());
        verificaciones.add(new ErrorYesSteveModelLinux());
        verificaciones.add(new ConflictoMovingElevatorsOptiFine());
        verificaciones.add(new ConflictoFabricAPIOptiFine());
        verificaciones.add(new ErrorModLauncherTransformationService());
        verificaciones.add(new ErrorVersionInvalidaModMaven());
        verificaciones.add(new ErrorStackSmashingDetected());
        verificaciones.add(new ErrorVersionClaseGregTechEasyCore());
        verificaciones.add(new ConflictoMoniLabsConnectorExtras());
        verificaciones.add(new ErrorCompatibilidadIrisDH());
        verificaciones.add(new UraniumLag());
        verificaciones.add(new ErrorFallingAttackVersion());
        verificaciones.add(new ProblemaSafeFetch32JDK17());
        verificaciones.add(new ProblemaMCEFInicializacion());
        verificaciones.add(new ConflictoIrisOptifine());
        verificaciones.add(new ConflictoModernFixOptifine());
        verificaciones.add(new ErrorClaveRegistroMayusculas());
        verificaciones.add(new ErrorEntrypointFabric());
        verificaciones.add(new ErrorEnGarde());
        verificaciones.add(new ErrorIdleTweaks());
        verificaciones.add(new IndependenteFlywheel());
        verificaciones.add(new FloralEnchantmentsTagKeyNull());
        verificaciones.add(new IrisSombrasTerreno());
        verificaciones.add(new TickLargoServidorMinecraft());
        verificaciones.add(new LuckPermsNoCargado());
        verificaciones.add(new IrisShaderpackNoEncontrado());
        verificaciones.add(new NightConfigNoSePuedeEscribir());
        verificaciones.add(new AccesoDenegadoBackupConfig());
        verificaciones.add(new PirataMC());
        verificaciones.add(new LanzerNoAnimado());
        verificaciones.add(new LanzerDesAnimado());
        verificaciones.add(new FaltaModAnimado());
        verificaciones.add(new TienesModDesAnimado());
        verificaciones.add(new AntiManipulacion());
        verificaciones.addAll(CargadorDeCodice.cargarVerificaciones());
        CrashDetectorLogger.log("N\u00famero de c\u00f3dices " + String.valueOf(CargadorDeCodice.cargarVerificaciones().size()));
        verificaciones.add(new DifDeMods());
    }
}

