/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador;

import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.gui.CrashDetectorGUI;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class QuickFix {
    public boolean tieneMantener = false;
    public final String etiqueta;
    public boolean tieneCheckbox = false;
    public List<ComponenteGUI> componentes = new ArrayList<ComponenteGUI>();
    public static QuickFix NINGUN = new Builder("NINGUN").agregarEtiqueta(MonitorDePID.idioma.noHaySolucionDisponible()).construir();

    private QuickFix(Builder builder) {
        this.etiqueta = builder.etiqueta;
        this.tieneCheckbox = builder.tieneCheckbox;
        this.componentes = builder.componentes;
    }

    public String obtenerEnlace() {
        return "quickfix://" + this.etiqueta + "/";
    }

    public static class Builder {
        private final String etiqueta;
        private boolean tieneCheckbox = false;
        public final List<ComponenteGUI> componentes = new ArrayList<ComponenteGUI>();

        public Builder(String etiqueta) {
            this.etiqueta = etiqueta;
        }

        public Builder conRetener() {
            this.tieneCheckbox = true;
            return this;
        }

        public Builder agregarBoton(String texto, AccionBoton accion, boolean desactivarOtros) {
            this.componentes.add(new BotonGUI(texto, accion, desactivarOtros));
            return this;
        }

        public Builder agregarBoton(String texto, AccionBoton accion) {
            return this.agregarBoton(texto, accion, false);
        }

        public Builder agregarEtiqueta(String texto) {
            this.componentes.add(new EtiquetaGUI(texto));
            return this;
        }

        public Builder agregarComponente(ComponenteGUI componente) {
            this.componentes.add(componente);
            return this;
        }

        public QuickFix construir() {
            return new QuickFix(this);
        }
    }

    @FunctionalInterface
    public static interface AccionBoton {
        public void ejecutar(boolean var1);
    }

    public static class SelectorGUI
    implements ComponenteGUI {
        private final JComboBox<String> comboBox;

        public SelectorGUI(JComboBox<String> comboBox) {
            this.comboBox = comboBox;
            if (!CrashDetectorGUI.esMac()) {
                comboBox.setFont(new Font("Segoe UI", 0, 14));
                comboBox.setBackground(Color.WHITE);
                comboBox.setForeground(Color.DARK_GRAY);
                comboBox.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
            }
        }

        @Override
        public JComponent crearComponente(Supplier<Boolean> estadoRetener) {
            return this.comboBox;
        }
    }

    static class EtiquetaGUI
    implements ComponenteGUI {
        private final String texto;

        public EtiquetaGUI(String texto) {
            this.texto = texto;
        }

        @Override
        public JComponent crearComponente(Supplier<Boolean> estadoRetener) {
            JLabel label = new JLabel(this.texto);
            if (!CrashDetectorGUI.esMac()) {
                label.setFont(new Font("Segoe UI", 0, 14));
                label.setBackground(Config.convertirAColor(Config.obtenerInstancia().obtenerColorBoton()));
                label.setForeground(Config.convertirAColor(Config.obtenerInstancia().obtenerColorTexto()));
                label.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
            }
            return label;
        }
    }

    static class BotonGUI
    implements ComponenteGUI {
        private final String texto;
        private final AccionBoton accion;
        private final boolean desactivarOtros;

        public BotonGUI(String texto, AccionBoton accion, boolean desactivarOtros) {
            this.texto = texto;
            this.accion = accion;
            this.desactivarOtros = desactivarOtros;
        }

        @Override
        public JComponent crearComponente(Supplier<Boolean> estadoRetener) {
            JButton boton = new JButton(this.texto);
            this.estilizarBoton(boton);
            boton.addActionListener(e -> {
                this.accion.ejecutar((Boolean)estadoRetener.get());
                JOptionPane.showMessageDialog(null, "\u00a1Listo!", "Informaci\u00f3n", 1);
            });
            return boton;
        }

        @Override
        public boolean debeDesactivarOtros() {
            return this.desactivarOtros;
        }

        private void estilizarBoton(JButton boton) {
            if (!CrashDetectorGUI.esMac()) {
                boton.setBackground(Config.convertirAColor(Config.obtenerInstancia().obtenerColorBoton()));
                boton.setForeground(Config.convertirAColor(Config.obtenerInstancia().obtenerColorTexto()));
                boton.setFont(new Font("Segoe UI", 0, 14));
                boton.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
            }
        }
    }

    public static interface ComponenteGUI {
        public JComponent crearComponente(Supplier<Boolean> var1);

        default public boolean debeDesactivarOtros() {
            return false;
        }
    }
}

