/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.analizador.ListaDenegadosTrace;
import com.asbestosstar.crashdetector.analizador.apps.minecraft.StackTracesDenegadosDeMinecraftPorDefecto;
import com.asbestosstar.crashdetector.mapas.BiMap;
import com.asbestosstar.crashdetector.mapas.TriMap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VerificacionDeStackTrace {
    public static List<ListaDenegadosTrace> denegados = new ArrayList<ListaDenegadosTrace>();
    Consola consola;
    public static String nl = System.lineSeparator();
    private static final Pattern STACK_TRACE_PATTERN = Pattern.compile("(?m)(^\\S.*(?:\\r?\\n[ \\t]*(?://\\s*)?at\\s+.*)+)");
    private static final Pattern JSON_PATTERN = Pattern.compile("(\\S+\\.json)(?=[: ])");
    private static final Pattern BRACE_PATTERN = Pattern.compile("\\{([^}]+)\\}");
    private static final Pattern PATRON_MODID_TRANSFORMER = Pattern.compile("^\\s*at\\s+TRANSFORMER/([a-z0-9_\\-.]+)(?:@|/).*$");
    private static final Pattern PATRON_MODID_SIMPLE = Pattern.compile("^\\s*at\\s+(?!java\\b|jdk\\b|sun\\b|org\\b|com\\b|net\\b)([a-z0-9_\\-]+)@[^/]+/.*$");
    private static final Set<String> TOKENS_FALSOS_SM = new HashSet<String>(Arrays.asList("app", "APP", "a", "A", "b", "B", "mixin", "pl", "re", "accesstransformer", "runtimedistcleaner", "classloading"));
    public BiMap<String, Integer, Boolean> sm_config = new BiMap();
    public TriMap<String, Integer, Integer, String> clases_fatales_no_existentes = new TriMap();
    public Map<Integer, TraceInfo> nivel_trazo = new HashMap<Integer, TraceInfo>();
    public List<String> jar_malo = new ArrayList<String>();
    public List<String> modid_malo = new ArrayList<String>();
    public List<String> package_malo = new ArrayList<String>();
    public List<String> brace_malo = new ArrayList<String>();
    public static String[] package_no_permite = new String[]{"java.", "net.minecraft", "net.minecraftforge", "org.spongepowered", "it.unimi", "com.mojang.", "cpw.", "featurecreep.", "jdk.", "sun.", "com.sun.", "org.lwjgl.", "org.apache.", "io.netty", "org.prismlauncher", "io.github.zekerzhayard", "org.multimc", "org.polymc", "org.tlauncher", "net.fabricmc", "org.objectweb.asm", "datafixerupper", "org.slf4j", "com.asbestosstar", "srg", "asbestosstar.", "org.openjdk", "com.google", "cpw.mods.modlauncher.", "com.modrinth.theseus.", "net.neoforged."};
    public List<TraceInfo> trazos_completos = new ArrayList<TraceInfo>();
    private static final String[] PREFIJOS_CARGADOR;

    public VerificacionDeStackTrace(Consola cons) {
        this.consola = cons;
    }

    public void reiniciar() {
        this.sm_config.clear();
        this.clases_fatales_no_existentes.clear();
        this.jar_malo.clear();
        this.modid_malo.clear();
        this.package_malo.clear();
        this.brace_malo.clear();
        this.nivel_trazo.clear();
        this.trazos_completos.clear();
        int nivel_prioridad = 0;
        String contenido = this.consola.contenido_verificar;
        List<TraceInfo> tracesFatal = VerificacionDeStackTrace.obtenerTracesFatalConLinea(contenido);
        Collections.reverse(tracesFatal);
        for (TraceInfo base : tracesFatal) {
            TraceInfo info = this.construirTraceInfo(base.trace, base.consolaLineaComenzar, ++nivel_prioridad, true);
            this.trazos_completos.add(info);
            this.nivel_trazo.put(nivel_prioridad, info);
            this.procesarTrace(base.trace, true, nivel_prioridad, base.consolaLineaComenzar);
        }
        List<TraceInfo> tracesNormales = VerificacionDeStackTrace.obtenerTracesConLinea(contenido);
        Collections.reverse(tracesNormales);
        for (TraceInfo base : tracesNormales) {
            TraceInfo info = this.construirTraceInfo(base.trace, base.consolaLineaComenzar, ++nivel_prioridad, false);
            this.trazos_completos.add(info);
            this.nivel_trazo.put(nivel_prioridad, info);
            this.procesarTrace(base.trace, false, nivel_prioridad, base.consolaLineaComenzar);
        }
    }

    private TraceInfo construirTraceInfo(String trace, int consolaLineaInicio, int nivel, boolean fatal) {
        TraceInfo info = new TraceInfo(trace, consolaLineaInicio, nivel, fatal);
        String[] lineas = trace.split(nl);
        for (int i = 0; i < lineas.length; ++i) {
            String dec;
            String paquete;
            String modid;
            String jar;
            String normalizada = VerificacionDeStackTrace.normalizarLineaStack(lineas[i]);
            if (normalizada == null || !(normalizada = normalizada.trim()).startsWith("at ")) continue;
            int lineaConsola = consolaLineaInicio + i;
            String clase = VerificacionDeStackTrace.extraerClaseDeLinea(normalizada);
            if (clase == null || clase.isEmpty()) continue;
            String origen = null;
            List<String> jars = VerificacionDeStackTrace.extraerJarsDeLinea(normalizada);
            if (!jars.isEmpty() && !VerificacionDeStackTrace.isJarNoPermite(jar = jars.get(0))) {
                origen = jar;
            }
            if (origen == null && (modid = VerificacionDeStackTrace.extraerModidDeLinea(normalizada)) != null && !VerificacionDeStackTrace.esModNoPermite(modid)) {
                origen = modid;
            }
            if (origen == null && (paquete = VerificacionDeStackTrace.extraerPaqueteDeLinea(normalizada)) != null && !this.packNoEsPermite(paquete, dec = nivel + "," + lineaConsola, fatal)) {
                origen = paquete;
            }
            if (origen == null) {
                boolean denegado = false;
                for (String pref : package_no_permite) {
                    String prefSlash;
                    if (pref == null || pref.isEmpty() || !clase.startsWith(prefSlash = pref.replace('.', '/'))) continue;
                    denegado = true;
                    break;
                }
                if (denegado) continue;
            }
            if (origen == null) {
                origen = clase;
            }
            LineaTrazo lt = new LineaTrazo();
            lt.origen = origen;
            lt.clase = clase;
            lt.nivel = nivel;
            lt.lineaConsola = lineaConsola;
            lt.fatal = fatal;
            lt.llaves = VerificacionDeStackTrace.extraerLlavesDeLinea(normalizada);
            info.lineas.add(lt);
        }
        return info;
    }

    public List<LineaTrazo> extraerLineasDeTrazoUnificadas() {
        ArrayList<LineaTrazo> resultado = new ArrayList<LineaTrazo>();
        if (this.nivel_trazo == null || this.nivel_trazo.isEmpty()) {
            return resultado;
        }
        for (Map.Entry<Integer, TraceInfo> entrada : this.nivel_trazo.entrySet()) {
            int nivel = entrada.getKey();
            TraceInfo info = entrada.getValue();
            boolean fatal = info.trace.contains("/FATAL]");
            String[] lineas = info.trace.split(nl);
            for (int i = 0; i < lineas.length; ++i) {
                String pack;
                String modid;
                String jar;
                String normalizada = VerificacionDeStackTrace.normalizarLineaStack(lineas[i]);
                if (normalizada == null || !(normalizada = normalizada.trim()).startsWith("at ")) continue;
                int lineaConsola = info.consolaLineaComenzar + i;
                String clase = VerificacionDeStackTrace.extraerClaseDeLinea(normalizada);
                if (clase == null || clase.isEmpty()) continue;
                String origen = null;
                List<String> jars = VerificacionDeStackTrace.extraerJarsDeLinea(normalizada);
                if (!jars.isEmpty() && !VerificacionDeStackTrace.isJarNoPermite(jar = jars.get(0))) {
                    origen = jar;
                }
                if (origen == null && (modid = VerificacionDeStackTrace.extraerModidDeLinea(normalizada)) != null && !VerificacionDeStackTrace.esModNoPermite(modid)) {
                    origen = modid;
                }
                if (origen == null && (pack = VerificacionDeStackTrace.extraerPaqueteDeLinea(normalizada)) != null && !this.packNoEsPermite(pack, nivel + "," + lineaConsola, fatal)) {
                    origen = pack;
                }
                if (origen == null) {
                    origen = clase;
                }
                LineaTrazo lt = new LineaTrazo();
                lt.origen = origen;
                lt.clase = clase;
                lt.nivel = nivel;
                lt.lineaConsola = lineaConsola;
                lt.fatal = fatal;
                resultado.add(lt);
            }
        }
        return resultado;
    }

    public static String extraerClaseDeLinea(String linea) {
        int ultimoPunto;
        int idxDoble;
        int idxPar;
        if (linea == null) {
            return "";
        }
        String texto = linea.trim();
        if (texto.startsWith("//")) {
            texto = texto.substring(2).trim();
        }
        if (texto.startsWith("at ")) {
            texto = texto.substring(3).trim();
        }
        if ((idxPar = (texto = VerificacionDeStackTrace.limpiarPrefijosYCargadores(texto)).indexOf(40)) >= 0) {
            texto = texto.substring(0, idxPar).trim();
        }
        if ((idxDoble = texto.indexOf("$$")) >= 0) {
            texto = texto.substring(0, idxDoble).trim();
        }
        if ((ultimoPunto = texto.lastIndexOf(46)) > 0) {
            texto = texto.substring(0, ultimoPunto).trim();
        }
        texto = texto.replace('.', '/').trim();
        while (texto.startsWith("/")) {
            texto = texto.substring(1);
        }
        return texto;
    }

    private static String limpiarPrefijosYCargadores(String texto) {
        String[] prefijosMetadata;
        boolean cambio;
        if (texto == null || texto.isEmpty()) {
            return "";
        }
        String t = texto.trim();
        do {
            cambio = false;
            if (t.startsWith("knot//")) {
                t = t.substring("knot//".length()).trim();
                cambio = true;
            }
            if (t.startsWith("knott//")) {
                t = t.substring("knott//".length()).trim();
                cambio = true;
            }
            if (t.startsWith("app//")) {
                t = t.substring("app//".length()).trim();
                cambio = true;
            }
            if (t.startsWith("MC//")) {
                t = t.substring("MC//".length()).trim();
                cambio = true;
            }
            if (!t.startsWith("jdk/")) continue;
            t = t.substring("jdk/".length()).trim();
            cambio = true;
        } while (cambio);
        for (String pref : prefijosMetadata = new String[]{"TRANSFORMER/", "MC-BOOTSTRAP/", "LAYER PLUGIN/"}) {
            if (!t.startsWith(pref)) continue;
            int idx = (t = t.substring(pref.length()).trim()).indexOf(47);
            if (idx < 0 || idx + 1 >= t.length()) break;
            t = t.substring(idx + 1).trim();
            break;
        }
        do {
            cambio = false;
            if (t.startsWith("knot//MC//")) {
                t = t.substring("knot//MC//".length()).trim();
                cambio = true;
            }
            if (t.startsWith("knott//")) {
                t = t.substring("knott//".length()).trim();
                cambio = true;
            }
            if (t.startsWith("app//")) {
                t = t.substring("app//".length()).trim();
                cambio = true;
            }
            if (t.startsWith("MC//")) {
                t = t.substring("MC//".length()).trim();
                cambio = true;
            }
            if (!t.startsWith("jdk/")) continue;
            t = t.substring("jdk/".length()).trim();
            cambio = true;
        } while (cambio);
        return t;
    }

    public static List<TraceInfo> obtenerTracesFatalConLinea(String log) {
        ArrayList<TraceInfo> resultado = new ArrayList<TraceInfo>();
        String[] lineas = log.split(nl);
        for (int i = 0; i < lineas.length; ++i) {
            int j;
            String header = lineas[i];
            if (header == null || !header.contains("/FATAL]")) continue;
            StringBuilder traza = new StringBuilder(header);
            for (j = i + 1; j < lineas.length && VerificacionDeStackTrace.esParteDeStack(lineas[j]); ++j) {
                traza.append(nl).append(lineas[j]);
            }
            String traceStr = traza.toString();
            if (!VerificacionDeStackTrace.tracePermite(traceStr)) continue;
            resultado.add(new TraceInfo(traceStr, i, -1, true));
            i = j - 1;
        }
        return resultado;
    }

    public static List<TraceInfo> obtenerTracesConLinea(String log) {
        ArrayList<TraceInfo> resultado = new ArrayList<TraceInfo>();
        String[] lineas = log.split(nl);
        int i = 0;
        while (i < lineas.length - 1) {
            int j;
            String header = lineas[i];
            if (header == null || header.isEmpty()) {
                ++i;
                continue;
            }
            if (Character.isWhitespace(header.charAt(0))) {
                ++i;
                continue;
            }
            String next = VerificacionDeStackTrace.normalizarLineaStack(lineas[i + 1]);
            if (next == null || !next.trim().startsWith("at ")) {
                ++i;
                continue;
            }
            StringBuilder traza = new StringBuilder(header);
            for (j = i + 1; j < lineas.length && VerificacionDeStackTrace.esParteDeStack(lineas[j]); ++j) {
                traza.append(nl).append(lineas[j]);
            }
            String traceStr = traza.toString();
            if (VerificacionDeStackTrace.tracePermite(traceStr)) {
                resultado.add(new TraceInfo(traceStr, i, -1, false));
            }
            i = j;
        }
        return resultado;
    }

    public void procesarTrace(String trace, boolean fatal, int nivel, int consolaLineaInicio) {
        List<String> jsons = this.obtenerArchivosJsonEnMixinExceptions(trace);
        for (String json : jsons) {
            if (this.sm_config.containsKey0(json)) continue;
            this.sm_config.put(json, consolaLineaInicio, fatal);
        }
        String[] arr = trace.split(nl);
        for (int i = 0; i < arr.length; ++i) {
            String clase;
            Map.Entry<String, String> res;
            String t;
            String linea = VerificacionDeStackTrace.normalizarLineaStack(arr[i]);
            if (linea == null || (t = linea.trim()).isEmpty()) continue;
            int consolaLinea = consolaLineaInicio + i;
            if ((t.contains("ClassNotFoundException") || t.contains("NoClassDefFoundError")) && !VerificacionDeStackTrace.esLineaDeAdvertenciaEstandar(t) && (res = this.procesarErrorClaseNoEncontrada(t, arr, consolaLinea, nivel)) != null) {
                this.clases_fatales_no_existentes.put(res.getKey(), nivel, consolaLinea, res.getValue());
            }
            if (!t.contains("org.spongepowered.asm.mixin.throwables.ClassMetadataNotFoundException:") || (clase = VerificacionDeStackTrace.extraerClaseDeMetadataNoEncontrada(t)) == null || clase.isEmpty()) continue;
            this.clases_fatales_no_existentes.put(clase, nivel, consolaLinea, "");
        }
    }

    private static String extraerClaseDeMetadataNoEncontrada(String linea) {
        if (linea == null) {
            return null;
        }
        String clave = "ClassMetadataNotFoundException:";
        int p = linea.indexOf("ClassMetadataNotFoundException:");
        if (p < 0) {
            return null;
        }
        String clase = linea.substring(p + "ClassMetadataNotFoundException:".length()).trim();
        return clase.replace('.', '/');
    }

    public static boolean esLineaDeAdvertenciaEstandar(String l) {
        if (l == null) {
            return false;
        }
        String t = l.trim();
        if (t.contains("/WARN]")) {
            return true;
        }
        if (t.contains("] [WARN")) {
            return true;
        }
        if (t.matches(".*\\[[^\\]]*\\]\\s*\\[[^\\]]*\\bWARN\\b[^\\]]*\\]\\s*:.*")) {
            return true;
        }
        return t.matches(".*\\[[^\\]]*\\bWARN\\b[^\\]]*\\]:.*");
    }

    public static List<String> extraerJarsDeLinea(String linea) {
        int cerrar;
        int abrir;
        ArrayList<String> jars = new ArrayList<String>();
        int inicio = 0;
        while ((abrir = linea.indexOf(91, inicio)) != -1 && (cerrar = linea.indexOf(93, abrir)) != -1) {
            String contenido = linea.substring(abrir + 1, cerrar);
            int indiceJar = contenido.indexOf(".jar");
            if (indiceJar != -1) {
                String nombreJar = contenido.substring(0, indiceJar + 4);
                jars.add(nombreJar);
            }
            inicio = cerrar + 1;
        }
        return jars;
    }

    public static String extraerModidDeLinea(String linea) {
        if (linea == null) {
            return null;
        }
        String t = VerificacionDeStackTrace.normalizarLineaStack(linea);
        if (t == null) {
            return null;
        }
        Matcher mTrans = PATRON_MODID_TRANSFORMER.matcher(t = t.trim());
        if (mTrans.matches()) {
            return mTrans.group(1);
        }
        Matcher mSimple = PATRON_MODID_SIMPLE.matcher(t);
        if (mSimple.matches()) {
            String cand = mSimple.group(1);
            return VerificacionDeStackTrace.esModNoPermite(cand) ? null : cand;
        }
        int h = t.indexOf("handler$");
        if (h >= 0) {
            String[] segs;
            String tail = t.substring(h + "handler$".length());
            for (String s : segs = tail.split("\\$")) {
                String k = VerificacionDeStackTrace.sane(s);
                if (k.isEmpty() || TOKENS_FALSOS_SM.contains(k) || VerificacionDeStackTrace.pareceMetodoOClase(k) || !VerificacionDeStackTrace.esModIdPlausible(k) || VerificacionDeStackTrace.esModNoPermite(k)) continue;
                return k;
            }
        }
        return null;
    }

    public static String extraerPaqueteDeLinea(String linea) {
        int ultimoPunto;
        int idxLambda;
        int idxPar;
        if (linea == null) {
            return null;
        }
        String texto = VerificacionDeStackTrace.normalizarLineaStack(linea);
        if (texto == null) {
            return null;
        }
        if (!(texto = texto.trim()).startsWith("at ")) {
            return null;
        }
        texto = texto.substring(3).trim();
        for (String p : PREFIJOS_CARGADOR) {
            if (!texto.startsWith(p)) continue;
            texto = texto.substring(p.length());
            break;
        }
        if ((idxPar = texto.indexOf(40)) != -1) {
            texto = texto.substring(0, idxPar);
        }
        if ((idxLambda = texto.indexOf("$$Lambda")) != -1) {
            texto = texto.substring(0, idxLambda);
        }
        if ((texto = texto.replaceAll("/0x[0-9a-fA-F]+.*", "")).contains("@") && texto.contains("/")) {
            int barra = texto.indexOf(47);
            texto = texto.substring(0, barra);
        }
        if ((ultimoPunto = texto.lastIndexOf(46)) > 0) {
            return texto.substring(0, ultimoPunto);
        }
        return null;
    }

    public static List<String> extraerLlavesDeLinea(String linea) {
        ArrayList<String> llaves = new ArrayList<String>();
        Matcher m = BRACE_PATTERN.matcher(linea);
        while (m.find()) {
            String contenido = m.group(1).trim();
            if (!VerificacionDeStackTrace.esLlaveDeSistema(contenido)) continue;
            llaves.add(contenido);
        }
        return llaves;
    }

    private static boolean esLlaveDeSistema(String c) {
        if (c == null) {
            return false;
        }
        String s = c.trim();
        if (s.indexOf(61) >= 0) {
            return false;
        }
        if (s.indexOf(58) < 0) {
            return false;
        }
        String[] segs = s.split("\\s*,\\s*");
        if (segs.length == 0) {
            return false;
        }
        int paresValidos = 0;
        for (String seg : segs) {
            int p = seg.indexOf(58);
            if (p <= 0 || p == seg.length() - 1) {
                return false;
            }
            String clave = seg.substring(0, p).trim();
            String valor = seg.substring(p + 1).trim();
            if (!clave.matches("[a-z][a-z0-9_\\-]*")) {
                return false;
            }
            if (valor.indexOf(61) >= 0) {
                return false;
            }
            if (valor.matches(".*\\s{2,}.*")) {
                return false;
            }
            ++paresValidos;
        }
        return paresValidos >= 2;
    }

    public Map.Entry<String, String> procesarErrorClaseNoEncontrada(String linea, String[] arr, int consoleLineNumber, int nivel_prioridad) {
        int startIdx;
        String claseFaltante = null;
        CrashDetectorLogger.log("procesarErrorClaseNoEncontrada " + linea);
        if (linea.contains("ClassNotFoundException")) {
            startIdx = linea.indexOf("ClassNotFoundException:") + "ClassNotFoundException:".length();
            claseFaltante = linea.substring(startIdx).trim();
        } else {
            startIdx = linea.indexOf("NoClassDefFoundError:") + "NoClassDefFoundError:".length();
            claseFaltante = linea.substring(startIdx).trim();
        }
        CrashDetectorLogger.log(claseFaltante);
        if (claseFaltante.contains(" ")) {
            CrashDetectorLogger.log("espacio");
            int spaceIdx = claseFaltante.indexOf(32);
            CrashDetectorLogger.log("spaceidx");
            if (spaceIdx != -1) {
                CrashDetectorLogger.log("-1");
                if (claseFaltante.startsWith("Could not initialize class ")) {
                    claseFaltante = claseFaltante.replace("Could not initialize class ", "");
                    spaceIdx = claseFaltante.indexOf(32);
                    CrashDetectorLogger.log(claseFaltante);
                }
            }
        }
        if (claseFaltante.contains("(")) {
            CrashDetectorLogger.log("(");
            int parenIdx = claseFaltante.indexOf(40);
            if (parenIdx != -1) {
                claseFaltante = claseFaltante.substring(0, parenIdx);
            }
        }
        claseFaltante = claseFaltante.replace(".", "/");
        String mejorOrigen = null;
        boolean esOrigenDirecto = false;
        boolean esTransformer = false;
        for (int i = 0; i < arr.length; ++i) {
            String representacion;
            String pack;
            String notrim = arr[i];
            String t = notrim.trim();
            if (t.isEmpty() || t.contains("... more")) continue;
            boolean esLineaTransformer = t.startsWith("at TRANSFORMER/");
            boolean esLineaDirecta = t.contains(claseFaltante.replace("/", "."));
            List<String> jarsEncontrados = VerificacionDeStackTrace.extraerJarsDeLinea(t);
            for (String jar : jarsEncontrados) {
                if (!jar.contains(".jar") || VerificacionDeStackTrace.isJarNoPermite(jar)) continue;
                if (esLineaDirecta || esLineaTransformer) {
                    mejorOrigen = jar;
                    esOrigenDirecto = esLineaDirecta;
                    esTransformer = esLineaTransformer;
                    continue;
                }
                if (mejorOrigen != null) continue;
                mejorOrigen = jar;
            }
            String modid = VerificacionDeStackTrace.extraerModidDeLinea(t);
            if (modid != null && !VerificacionDeStackTrace.esModNoPermite(modid)) {
                if (esLineaDirecta || esLineaTransformer) {
                    mejorOrigen = modid;
                    esOrigenDirecto = esLineaDirecta;
                    esTransformer = esLineaTransformer;
                } else if (mejorOrigen == null) {
                    mejorOrigen = modid;
                }
            }
            if ((pack = VerificacionDeStackTrace.extraerPaqueteDeLinea(t)) != null && !this.packNoEsPermite(pack, representacion = Integer.toString(nivel_prioridad) + "," + Integer.toString(consoleLineNumber), false)) {
                if (esLineaDirecta || esLineaTransformer) {
                    mejorOrigen = pack;
                    esOrigenDirecto = esLineaDirecta;
                    esTransformer = esLineaTransformer;
                } else if (mejorOrigen == null) {
                    mejorOrigen = pack;
                }
            }
            if (esTransformer) break;
        }
        if (mejorOrigen != null) {
            CrashDetectorLogger.log("Origen identificado: " + mejorOrigen + (esTransformer ? " (TRANSFORMER)" : (esOrigenDirecto ? " (directo)" : "")));
            return new AbstractMap.SimpleEntry<String, Object>(claseFaltante, mejorOrigen);
        }
        return null;
    }

    private static boolean esModIdPlausible(String s) {
        return s != null && s.matches("^[a-z0-9_\\-.]{2,64}$");
    }

    private static boolean pareceMetodoOClase(String s) {
        if (s == null) {
            return false;
        }
        if (s.indexOf(40) >= 0) {
            return true;
        }
        if (s.indexOf(46) >= 0) {
            return true;
        }
        return !s.equals(s.toLowerCase());
    }

    public void processarSMHandler(String pack, String dec, boolean fatal) {
        try {
            String s1;
            int idx = pack.indexOf("handler$");
            if (idx < 0) {
                return;
            }
            String tail = pack.substring(idx + "handler$".length());
            String[] segs = tail.split("\\$");
            if (segs.length == 0) {
                return;
            }
            String candidato = null;
            String s0 = VerificacionDeStackTrace.sane(segs[0]);
            if (!TOKENS_FALSOS_SM.contains(s0) && VerificacionDeStackTrace.esModIdPlausible(s0) && !VerificacionDeStackTrace.esModNoPermite(s0)) {
                if (segs.length >= 2) {
                    s1 = VerificacionDeStackTrace.sane(segs[1]);
                    if (VerificacionDeStackTrace.pareceMetodoOClase(s1) || !VerificacionDeStackTrace.esModIdPlausible(s1)) {
                        candidato = s0;
                    }
                } else {
                    candidato = s0;
                }
            }
            if (candidato == null && segs.length >= 2 && !TOKENS_FALSOS_SM.contains(s1 = VerificacionDeStackTrace.sane(segs[1])) && VerificacionDeStackTrace.esModIdPlausible(s1) && !VerificacionDeStackTrace.esModNoPermite(s1) && !VerificacionDeStackTrace.pareceMetodoOClase(s1)) {
                candidato = s1;
            }
            if (candidato == null && segs.length >= 2) {
                for (int i = 2; i < segs.length; ++i) {
                    String si = VerificacionDeStackTrace.sane(segs[i]);
                    if (TOKENS_FALSOS_SM.contains(si) || !VerificacionDeStackTrace.esModIdPlausible(si) || VerificacionDeStackTrace.esModNoPermite(si) || VerificacionDeStackTrace.pareceMetodoOClase(si)) continue;
                    candidato = si;
                    break;
                }
            }
            if (candidato == null) {
                return;
            }
            if (!this.modid_malo.contains(candidato)) {
                this.modid_malo.add(candidato);
                String[] lvlLinea = dec.split(",");
                int nivel_prioridad = Integer.parseInt(lvlLinea[0]);
                int consoleLineNumber = Integer.parseInt(lvlLinea[1]);
                CrashDetectorLogger.log("Mod ID por handler detectado: " + candidato);
            }
        }
        catch (Exception ex) {
            CrashDetectorLogger.log("processarSMHandler ignorado: " + ex.getMessage());
        }
    }

    private static String sane(String s) {
        int dot;
        if (s == null) {
            return "";
        }
        int p = s.indexOf(40);
        if (p >= 0) {
            s = s.substring(0, p);
        }
        if ((dot = s.indexOf(46)) >= 0) {
            s = s.substring(0, dot);
        }
        return s;
    }

    public static boolean esModNoPermite(String modid) {
        String[] ids;
        if (modid == null || modid.replace(" ", "").equals("")) {
            return true;
        }
        for (String id : ids = new String[]{"java", "minecraft", "minecraftforge", "net.minecraftforge", "eventbus", "cpw", "coremods", "featurecreep", "mixin", "accesstransformer", "forge", "neoforge", "authlib", "sun", "jdk", "java", "fmlloader", "fmlcore", "org.spongepowered.mixin", "fmlearlydisplay", "com.sun.jna", "text2speech", "xf:crashdetector:default", "crashdetector", "srg", "org.objectweb.asm", "it.unimi", "datafixerupper", "com.google.gson", "org.openjdk", "launchwrapper"}) {
            if (!modid.startsWith(id)) continue;
            return true;
        }
        return false;
    }

    public boolean packNoEsPermite(String pack, String dec, boolean fatal) {
        if (pack.contains("handler$")) {
            this.processarSMHandler(pack, dec, fatal);
        }
        String packSlash = pack.replace('.', '/');
        for (String prefix : package_no_permite) {
            String prefSlash = prefix.replace('.', '/');
            if (!packSlash.startsWith(prefSlash)) continue;
            return true;
        }
        return false;
    }

    public static String[] eliminarDuplicados(String[] inputArray) {
        HashSet<String> set = new HashSet<String>(Arrays.asList(inputArray));
        String[] ret = set.toArray(new String[0]);
        return ret;
    }

    public static boolean tracePermite(String str) {
        for (ListaDenegadosTrace pred : denegados) {
            if (!pred.predicado(str)) continue;
            return false;
        }
        return true;
    }

    private static boolean esParteDeStack(String l) {
        String t = VerificacionDeStackTrace.normalizarLineaStack(l);
        if (t == null) {
            return false;
        }
        if ((t = t.trim()).endsWith("more")) {
            return false;
        }
        return t.startsWith("at ") || t.startsWith("Caused by:") || t.startsWith("Suppressed:") || t.startsWith("...") || t.startsWith("SECURE-BOOTSTRAP") || t.matches("^[a-zA-Z0-9_.]+\\.[A-Z][a-zA-Z0-9]+Exception.*");
    }

    public List<String> obtenerArchivosJsonEnMixinExceptions(String contenido_de_logs) {
        String[] lineas;
        ArrayList<String> archivos_json = new ArrayList<String>();
        for (String linea : lineas = contenido_de_logs.split("\r?\n")) {
            if (!linea.contains("org.spongepowered.asm.mixin")) continue;
            Matcher matcher = JSON_PATTERN.matcher(linea.trim());
            while (matcher.find()) {
                if (matcher.group(1) == null) continue;
                String nombreJson = matcher.group(1).trim();
                if (nombreJson.startsWith("[")) {
                    nombreJson = nombreJson.substring(1);
                }
                archivos_json.add(nombreJson);
            }
        }
        return archivos_json;
    }

    public static boolean isJarNoPermite(String jarName) {
        if (jarName.startsWith("fml")) {
            return true;
        }
        if (jarName.startsWith("fabric-loader")) {
            return true;
        }
        if (jarName.startsWith("crashdetectormc")) {
            return true;
        }
        if (jarName.startsWith("sponge-mixin")) {
            return true;
        }
        if (jarName.startsWith("forge-")) {
            return true;
        }
        if (jarName.startsWith("ForgeWrapper")) {
            return true;
        }
        if (jarName.startsWith("NewLaunch")) {
            return true;
        }
        if (jarName.contains("fmlcore")) {
            return true;
        }
        if (jarName.startsWith("mixin")) {
            return true;
        }
        if (jarName.startsWith("gson-")) {
            return true;
        }
        if (jarName.startsWith("eventbus")) {
            return true;
        }
        if (jarName.startsWith("featurecreep-")) {
            return true;
        }
        if (jarName.startsWith("server-")) {
            return true;
        }
        if (jarName.startsWith("modlauncher")) {
            return true;
        }
        if (jarName.startsWith("launchwrapper")) {
            return true;
        }
        if (jarName.startsWith("com.google")) {
            return true;
        }
        if (jarName.startsWith("toml-")) {
            return true;
        }
        if (jarName.startsWith("javafmllanguage")) {
            return true;
        }
        if (jarName.startsWith("client-")) {
            return true;
        }
        if (jarName.startsWith("lwjgl-")) {
            return true;
        }
        if (jarName.startsWith("netty-")) {
            return true;
        }
        if (jarName.startsWith("bootstraplauncher")) {
            return true;
        }
        if (jarName.startsWith("neoforge-")) {
            return true;
        }
        if (jarName.startsWith("bootstrap-")) {
            return true;
        }
        if (jarName.startsWith("bus-")) {
            return true;
        }
        if (jarName.startsWith("securejarhandler")) {
            return true;
        }
        if (jarName.startsWith("securemodules-")) {
            return true;
        }
        if (jarName.startsWith("core-")) {
            return true;
        }
        if (jarName.startsWith("asm-")) {
            return true;
        }
        if (jarName.startsWith("loader-")) {
            return true;
        }
        if (jarName.startsWith("authlib-")) {
            return true;
        }
        if (jarName.startsWith("jna-")) {
            return true;
        }
        if (jarName.startsWith("text2speech-")) {
            return true;
        }
        if (jarName.startsWith("Fabric%")) {
            return true;
        }
        if (jarName.startsWith("Forge%")) {
            return true;
        }
        if (jarName.startsWith("language-")) {
            return true;
        }
        if (jarName.startsWith("language-")) {
            return true;
        }
        if (jarName.startsWith("minecraft-") && jarName.contains("server")) {
            return true;
        }
        if (jarName.startsWith("minecraft-") && jarName.contains("client")) {
            return true;
        }
        if (jarName.startsWith("coremods-")) {
            return true;
        }
        if (jarName.startsWith("nashorn-core-")) {
            return true;
        }
        if (jarName.startsWith("guava-")) {
            return true;
        }
        if (jarName.startsWith("sun")) {
            return true;
        }
        if (jarName.startsWith("com.sun")) {
            return true;
        }
        if (jarName.startsWith("datafixerupper")) {
            return true;
        }
        return jarName.startsWith("theseus");
    }

    public static String normalizarLineaStack(String l) {
        String marca;
        if (l == null) {
            return null;
        }
        String t = l.trim();
        if (t.startsWith("//")) {
            t = t.substring(2).trim();
        }
        if (t.startsWith("at ")) {
            for (String p : PREFIJOS_CARGADOR) {
                marca = "at " + p;
                if (!t.startsWith(marca)) continue;
                t = "at " + t.substring(marca.length());
                break;
            }
        } else {
            for (String p : PREFIJOS_CARGADOR) {
                marca = p + "at ";
                if (!t.startsWith(marca)) continue;
                t = "at " + t.substring(marca.length());
                break;
            }
        }
        for (String p : PREFIJOS_CARGADOR) {
            if (!t.startsWith("at " + p)) continue;
            t = "at " + t.substring(("at " + p).length());
        }
        return t;
    }

    static {
        StackTracesDenegadosDeMinecraftPorDefecto.init();
        PREFIJOS_CARGADOR = new String[]{"knot//MC//", "knot//", "knott//", "app//"};
    }

    public static class TraceInfo {
        public final String trace;
        public final int consolaLineaComenzar;
        public final int nivel;
        public final boolean fatal;
        public final List<LineaTrazo> lineas = new ArrayList<LineaTrazo>();

        TraceInfo(String trace, int consolaLineaComenzar, int nivel, boolean fatal) {
            this.trace = trace;
            this.consolaLineaComenzar = consolaLineaComenzar;
            this.nivel = nivel;
            this.fatal = fatal;
        }
    }

    public static class LineaTrazo {
        public String origen;
        public String clase;
        public int nivel;
        public int lineaConsola;
        public boolean fatal;
        public List<String> llaves = Collections.emptyList();
    }
}

