/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador;

import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.analizador.Criticalidad;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.awt.Desktop;
import java.net.URI;

public interface Verificaciones {
    public static final String nl = System.lineSeparator();
    public static final String nl_html = "<br>";

    public void verificar(Consola var1);

    default public void verificar(Consola consola, String linea, int numero_de_linea) {
    }

    public Verificaciones nueva();

    public boolean activado();

    default public boolean anularNormal() {
        return false;
    }

    public float prioridad();

    public String mensaje();

    public String nombre();

    public QuickFix solucion();

    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo var1);

    public static void abrirEnNavegador(String url) {
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI(url));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    default public Criticalidad nivel_de_criticalidad() {
        return Criticalidad.ERROR;
    }

    public String id();

    public Documento docs();

    public String enlaceACodigo();

    default public boolean recomendadoParaCorperata() {
        return false;
    }

    default public String comoString() {
        StringBuilder constructor = new StringBuilder();
        String tituloColor = Config.obtenerInstancia().obtenerColorDeTitulosDeConsolas();
        constructor.append("<span style='color: #").append(tituloColor).append("; font-weight: bold;'>").append(this.nombre()).append("</span>");
        constructor.append(nl_html).append(this.mensaje());
        String colorenlace = Config.obtenerInstancia().obtenerColorEnlace();
        if (this.solucion() != null && this.solucion() != QuickFix.NINGUN) {
            String enlaceHtml = "<a href=\"" + this.solucion().obtenerEnlace() + "\" style=\"color:" + colorenlace + ";\">QuickFix</a>";
            if (!constructor.toString().endsWith(nl_html) && !constructor.toString().endsWith(nl)) {
                constructor.append(nl_html);
            }
            constructor.append(enlaceHtml);
        }
        constructor.append("<hr style='border: 0; border-top: 1px solid #").append(tituloColor).append("; margin: 8px 0;' />");
        return constructor.toString();
    }
}

