/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.buscar.Buscardor;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AuditorTransformer
implements Verificaciones {
    private boolean activado = false;
    private final List<EntradaAudit> entradas = new ArrayList<EntradaAudit>();
    private final Map<String, String> enlacesPorEntrada = new HashMap<String, String>();
    private static final String[] LISTA_DE_DENEGADOS = new String[]{"PLUGIN: runtimedistcleaner", "PLUGIN: accesstransformer", "PLUGIN: crashdetector", "REASON: classloading", "TRANSFORMER: crashdetector"};

    @Override
    public void verificar(Consola consola) {
        if (consola == null || consola.contenido_verificar == null) {
            return;
        }
        this.entradas.clear();
        this.enlacesPorEntrada.clear();
        HashSet<String> procesados = new HashSet<String>();
        String[] lineas = consola.contenido_verificar.split(Verificaciones.nl);
        if (lineas.length == 0) {
            return;
        }
        int auditIndex = 0;
        for (int i = lineas.length - 1; i >= 0; --i) {
            String l\u00ednea = lineas[i].trim();
            if (l\u00ednea.isEmpty()) continue;
            try {
                Matcher modidMatcher;
                if (l\u00ednea.startsWith("Transformer Audit:")) {
                    ++auditIndex;
                    continue;
                }
                if (!this.esEntradaValida(l\u00ednea) || this.estaEnDenylist(l\u00ednea) || procesados.contains(l\u00ednea) || this.esEntradaExcluida(l\u00ednea)) continue;
                procesados.add(l\u00ednea);
                String textoBase = l\u00ednea;
                String puntuaci\u00f3nStr = "";
                float puntuaci\u00f3n = (float)auditIndex + (float)(this.entradas.size() % 100) / 100.0f;
                if (l\u00ednea.contains("(") && l\u00ednea.contains(")")) {
                    int inicio = l\u00ednea.indexOf(40);
                    int fin = l\u00ednea.indexOf(41);
                    if (inicio > 0 && fin > inicio) {
                        puntuaci\u00f3nStr = " (" + l\u00ednea.substring(inicio + 1, fin) + ")";
                        textoBase = l\u00ednea.substring(0, inicio).trim();
                    }
                }
                List<Object> jars = new ArrayList();
                if (l\u00ednea.contains("mixin:APP:")) {
                    Matcher jsonMatcher = Pattern.compile("mixin:APP:([^:\\s]+)").matcher(l\u00ednea);
                    if (jsonMatcher.find()) {
                        String jsonFile = jsonMatcher.group(1);
                        jars = Buscardor.obtenerUbicaciones(Buscardor.buscarModsConTermino(jsonFile));
                    }
                } else if (l\u00ednea.startsWith("TRANSFORMER: fml:") && (modidMatcher = Pattern.compile("TRANSFORMER: fml:([^:\\s]+)").matcher(l\u00ednea)).find()) {
                    String modid = modidMatcher.group(1);
                    CrashDetectorLogger.log(modid);
                    jars = Buscardor.obtenerModsConNombre(modid);
                }
                String jarsStr = "";
                if (!jars.isEmpty()) {
                    jarsStr = " <strong>[" + String.join((CharSequence)", ", jars) + "]</strong>";
                }
                String textoParaMostrar = textoBase + jarsStr + puntuaci\u00f3nStr;
                String enlace = consola.agregarErrorALectador(i, this);
                this.enlacesPorEntrada.put(textoParaMostrar, enlace);
                this.entradas.add(new EntradaAudit(textoParaMostrar, puntuaci\u00f3n));
                continue;
            }
            catch (Exception e) {
                CrashDetectorLogger.log("Error procesando l\u00ednea: " + l\u00ednea);
            }
        }
        this.activado = !this.entradas.isEmpty();
    }

    private boolean esEntradaValida(String l\u00ednea) {
        return l\u00ednea.startsWith("REASON") || l\u00ednea.startsWith("TRANSFORMER") || l\u00ednea.startsWith("PLUGIN");
    }

    private boolean estaEnDenylist(String l\u00ednea) {
        for (String bloque : LISTA_DE_DENEGADOS) {
            if (!l\u00ednea.startsWith(bloque)) continue;
            return true;
        }
        return false;
    }

    private boolean esEntradaExcluida(String l\u00ednea) {
        if (!l\u00ednea.contains(": ")) {
            return false;
        }
        String[] partes = l\u00ednea.split(": ", 2);
        String valor = partes[1].split(" ")[0];
        return valor.equals("mixin") || valor.equals("mixin:AFTER") || valor.equals("computing_frames");
    }

    @Override
    public String mensaje() {
        if (!this.activado || this.entradas.isEmpty()) {
            return "";
        }
        StringBuilder html = new StringBuilder();
        html.append(MonitorDePID.idioma.auditorias_transformer_detectadas());
        html.append("<ul>");
        for (EntradaAudit entrada : this.entradas) {
            String enlace = this.enlacesPorEntrada.getOrDefault(entrada.texto, "");
            html.append("<li>").append(entrada.texto).append(" ").append(enlace).append("</li>");
        }
        html.append("</ul>");
        return html.toString();
    }

    @Override
    public Verificaciones nueva() {
        return new AuditorTransformer();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 2.5f;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.auditorias_transformer();
    }

    @Override
    public QuickFix solucion() {
        return QuickFix.NINGUN;
    }

    @Override
    public String id() {
        return "auditortransformer";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }

    private static class EntradaAudit {
        String texto;
        float score;

        EntradaAudit(String texto, float score) {
            this.texto = texto;
            this.score = score;
        }
    }
}

