/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;

public class AzureGeckoLibInicializoPronto
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private boolean azureLibError = false;
    private boolean geckoLibError = false;
    private boolean connectorPresente = false;
    private String enlaceHtml = "";
    private final String azure = "AzureLib was initialized too early!";
    private final String geck = "GeckoLib was initialized too early!";

    @Override
    public void verificar(Consola consola) {
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (linea.contains("AzureLib was initialized too early!")) {
            this.azureLibError = true;
            this.activado = true;
            this.enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
        }
        if (linea.contains("GeckoLib was initialized too early!")) {
            this.geckoLibError = true;
            this.activado = true;
            if (this.enlaceHtml.isEmpty()) {
                this.enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
            }
        }
        if (linea.contains("SINYTRA CONNECTOR IS PRESENT!") || linea.contains("specialcompatibilityoperation")) {
            this.connectorPresente = true;
        }
        if (this.activado) {
            this.mensaje = MonitorDePID.idioma.errorAzureGeckoLibInicializoPronto(this.azureLibError, this.geckoLibError, this.connectorPresente) + "<br>" + this.enlaceHtml;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new AzureGeckoLibInicializoPronto();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 950.0f;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_de_error_azure_geckolib_inicializo_pronto();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.paso1_azure_geckolib_inicializo_pronto()).agregarEtiqueta(MonitorDePID.idioma.paso2_azure_geckolib_inicializo_pronto()).construir();
    }

    @Override
    public String id() {
        return "azuregeckolibinicialaizo";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return trazo.trace.contains("GeckoLib was initialized too early!") || trazo.trace.contains("AzureLib was initialized too early!");
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

