/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConflictoDeIDsMinecraft
implements Verificaciones {
    private boolean activado = false;
    private String tipoConflicto = "";
    private String idConflictivo = "";
    private String modOrigen = "";
    private String modDestino = "";
    private final StringBuilder mensaje = new StringBuilder();

    @Override
    public void verificar(Consola consola) {
        Pattern patternIDColision;
        Matcher matcherIDColision;
        String contenidoConsola = consola.contenido_verificar;
        if (contenidoConsola.contains("maximum id range exceeded")) {
            this.tipoConflicto = "maximo_rango";
            this.activado = true;
        }
        if ((matcherIDColision = (patternIDColision = Pattern.compile("java\\.lang\\.IllegalArgumentException: Slot (\\d+) is already occupied by (.*?) when adding (.*?)")).matcher(contenidoConsola)).find()) {
            this.tipoConflicto = "colision_id";
            this.idConflictivo = matcherIDColision.group(1);
            this.modOrigen = matcherIDColision.group(2);
            this.modDestino = matcherIDColision.group(3);
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ConflictoDeIDsMinecraft();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 750.0f;
    }

    @Override
    public String mensaje() {
        if ("colision_id".equals(this.tipoConflicto)) {
            return MonitorDePID.idioma.conflicto_id_colision_especifico(this.idConflictivo, this.modOrigen, this.modDestino);
        }
        if ("maximo_rango".equals(this.tipoConflicto)) {
            return MonitorDePID.idioma.conflicto_id_maximo();
        }
        return "";
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_de_conflicto_ids();
    }

    @Override
    public QuickFix solucion() {
        QuickFix.Builder builder = new QuickFix.Builder(this.nombre()).agregarEtiqueta(this.obtenerSolucionEspecifica());
        if ("maximo_rango".equals(this.tipoConflicto)) {
            builder.agregarBoton(MonitorDePID.idioma.instalar_justenoughids(), bool -> Verificaciones.abrirEnNavegador("https://www.curseforge.com/minecraft/mc-mods/justenoughids")).agregarBoton(MonitorDePID.idioma.instalar_endlessids(), bool -> Verificaciones.abrirEnNavegador("https://www.curseforge.com/minecraft/mc-mods/endless-ids"));
        } else if ("colision_id".equals(this.tipoConflicto)) {
            builder.agregarBoton(MonitorDePID.idioma.usar_idfix_minus(), bool -> Verificaciones.abrirEnNavegador("https://www.minecraftforum.net/forums/mapping-and-modding-java-edition/minecraft-mods/1291014-idfix-and-idfix-minus-mods-for-resolving-id")).agregarBoton(MonitorDePID.idioma.usar_minecraft_id_resolver(), bool -> Verificaciones.abrirEnNavegador("https://github.com/SS111/Minecraft-ID-Resolver")).agregarBoton(MonitorDePID.idioma.ver_documentacion_jp(), bool -> Verificaciones.abrirEnNavegador("https://minecraftjapan.miraheze.org/wiki/MOD%E8%A7%A3%E8%AA%AC/ID%E7%AB%B6%E5%90%88%E9%98%B2%E6%AD%A2%E6%94%AF%E6%8F%B4MOD"));
        }
        return builder.construir();
    }

    private String obtenerSolucionEspecifica() {
        if ("maximo_rango".equals(this.tipoConflicto)) {
            return MonitorDePID.idioma.solucion_maximo_rango();
        }
        if ("colision_id".equals(this.tipoConflicto)) {
            return MonitorDePID.idioma.solucion_colision_id();
        }
        return "";
    }

    @Override
    public String id() {
        return "conflicto_de_ids_minecraft";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        String t = trazo.trace;
        if ("maximo_rango".equals(this.tipoConflicto)) {
            return t.contains("maximum id range exceeded");
        }
        if ("colision_id".equals(this.tipoConflicto) && !this.idConflictivo.isEmpty() && !this.modOrigen.isEmpty() && !this.modDestino.isEmpty()) {
            String esperado = "java.lang.IllegalArgumentException: Slot " + this.idConflictivo + " is already occupied by " + this.modOrigen + " when adding " + this.modDestino;
            return t.contains(esperado);
        }
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

