/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;

public class ConflictoFlywheelRubidium
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private String enlaceHtml = "";
    private boolean encontradaLinea1 = false;

    @Override
    public void verificar(Consola consola) {
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (this.activado) {
            return;
        }
        if (linea.contains("Failure message: Mod flywheel only supports sodium") && linea.contains("0.6.0-beta.2 or above")) {
            this.encontradaLinea1 = true;
        }
        if (this.encontradaLinea1 && linea.contains("Currently, sodium is")) {
            if (linea.contains("0.5.") || linea.contains("0.4.") || linea.contains("0.3.") || linea.contains("0.2.") || linea.contains("0.1.") || linea.contains("0.0.")) {
                this.enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
                this.mensaje = MonitorDePID.idioma.errorConflictoFlywheelSodium() + "<br>";
                this.activado = true;
            } else {
                this.encontradaLinea1 = false;
            }
        }
        if (this.encontradaLinea1 && !linea.contains("Currently, sodium is") && (linea.toLowerCase().contains("rubidium") || linea.toLowerCase().contains("embeddium") || linea.toLowerCase().contains("sodium")) && (linea.contains("0.5.") || linea.contains("0.4.") || linea.contains("0.3.") || linea.contains("0.2.") || linea.contains("0.1.") || linea.contains("0.0."))) {
            this.enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
            this.mensaje = MonitorDePID.idioma.errorConflictoFlywheelSodium() + "<br>";
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ConflictoFlywheelRubidium();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1300.0f;
    }

    @Override
    public String mensaje() {
        return this.activado ? this.mensaje + this.enlaceHtml : "";
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreDeConflictoFlywheelSodium();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.pasoConflictoFlywheelSodium()).construir();
    }

    @Override
    public String id() {
        return "conflicto_flywheel_sodium";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        String t = trazo.trace;
        return t.contains("Failure message: Mod flywheel only supports sodium") && t.contains("0.6.0-beta.2 or above") && (t.contains("Currently, sodium is") || t.toLowerCase().contains("rubidium") || t.toLowerCase().contains("embeddium"));
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

