/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;

public class ConflictoIrisOptifine
implements Verificaciones {
    private boolean activado = false;
    private String enlaceHtml = "";
    private boolean encontroOptifine = false;

    @Override
    public void verificar(Consola consola) {
        this.activado = false;
        this.enlaceHtml = "";
        this.encontroOptifine = false;
        String contenido = consola.contenido_verificar.toLowerCase();
        if (contenido.contains("optifine")) {
            this.encontroOptifine = true;
        }
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (this.activado || !this.encontroOptifine || linea == null) {
            return;
        }
        String l = linea.toLowerCase();
        boolean tieneIrisOculusJson = l.contains("mixins.iris.json") || l.contains("mixins.iris.forge.json") || l.contains("mixins.iris.fabric.json") || l.contains("mixins.oculus.json");
        boolean tieneInjectionError = l.contains("injectionerror");
        boolean tieneMixinLevelRenderer = l.contains("mixinlevelrenderer");
        boolean tieneFailedCheck = l.contains("failed injection check");
        if (tieneIrisOculusJson && tieneInjectionError && tieneMixinLevelRenderer && tieneFailedCheck) {
            this.activado = true;
            this.enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ConflictoIrisOptifine();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 950.0f;
    }

    @Override
    public String mensaje() {
        if (!this.activado) {
            return "";
        }
        return MonitorDePID.idioma.conflicto_iris_optifine_html() + (this.enlaceHtml.isEmpty() ? "" : " " + this.enlaceHtml);
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_conflicto_iris_optifine();
    }

    @Override
    public QuickFix solucion() {
        QuickFix.Builder builder = new QuickFix.Builder(this.nombre());
        builder.agregarEtiqueta(MonitorDePID.idioma.solucion_eliminar_optifine());
        builder.agregarEtiqueta(MonitorDePID.idioma.solucion_usar_iris_sin_optifine());
        return builder.construir();
    }

    @Override
    public String id() {
        return "conflicto_iris_optifine";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

