/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;

public class ConflictoMoniLabsConnectorExtras
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private String enlaceHtml = "";
    private boolean encontradoMoniLabs = false;
    private boolean encontradoConnectorExtras = false;

    @Override
    public void verificar(Consola consola) {
        if (consola.contenido_verificar != null) {
            String contenido = consola.contenido_verificar.toLowerCase();
            this.encontradoMoniLabs = contenido.contains("monilabs");
            this.encontradoConnectorExtras = contenido.contains("connectorextras");
        }
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (this.activado) {
            return;
        }
        if (linea.contains("dev.latvian.mods.kubejs.util.KubeJSPlugins.handler") && linea.contains("$monilabs$moniLabs$injectBeforeLoad") && this.encontradoMoniLabs && this.encontradoConnectorExtras) {
            this.enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
            this.mensaje = MonitorDePID.idioma.errorConflictoMoniLabsConnectorExtras() + "<br>";
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ConflictoMoniLabsConnectorExtras();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 850.0f;
    }

    @Override
    public String mensaje() {
        return this.activado ? this.mensaje + this.enlaceHtml : "";
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreDeConflictoMoniLabsConnectorExtras();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.pasoConflictoMoniLabsConnectorExtras()).construir();
    }

    @Override
    public String id() {
        return "conflicto_monilabs_connectorextras";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        String t = trazo.trace;
        return t.contains("dev.latvian.mods.kubejs.util.KubeJSPlugins.handler") && t.contains("$monilabs$moniLabs$injectBeforeLoad") && t.toLowerCase().contains("monilabs") && t.toLowerCase().contains("connectorextras");
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

