/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;

public class ConflictoMoonlightIceberg
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";

    @Override
    public void verificar(Consola consola) {
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (this.activado) {
            return;
        }
        if (linea.contains("FATAL ERROR in native method") && linea.contains("No context is current or a function that is not available in the current context")) {
            boolean tieneIceberg;
            String contenido = consola.contenido_verificar;
            boolean tieneMoonlight = contenido.contains("moonlight") || contenido.contains("Moonlight");
            boolean bl = tieneIceberg = contenido.contains("iceberg") || contenido.contains("Iceberg");
            if (tieneMoonlight && tieneIceberg) {
                String enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
                this.mensaje = MonitorDePID.idioma.conflictoMoonlightIceberg() + enlaceHtml;
                this.activado = true;
            }
        }
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        String t = trazo.trace;
        return t.contains("FATAL ERROR in native method") && t.contains("No context is current") && t.contains("moonlight") && t.contains("iceberg");
    }

    @Override
    public Verificaciones nueva() {
        return new ConflictoMoonlightIceberg();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public float prioridad() {
        return 1100.0f;
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.solucionConflictoMoonlightIceberg()).construir();
    }

    @Override
    public String id() {
        return "conflicto_moonlight_iceberg";
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreConflictoMoonlightIceberg();
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

