/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;

public class ConflictoOptiFineFusion
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private String enlaceHtml = "";
    private boolean encontradoOptiFine = false;

    @Override
    public void verificar(Consola consola) {
        if (consola.contenido_verificar != null) {
            this.encontradoOptiFine = consola.contenido_verificar.toLowerCase().contains("optifine");
        }
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (this.activado) {
            return;
        }
        if (linea.contains("Critical injection failure") && linea.contains("net/minecraft/client/renderer/entity/EntityRenderDispatcher") && linea.contains("fusion.mixins.json") && linea.contains("EntityRenderDispatcherMixin") && linea.contains("renderTail") && this.encontradoOptiFine) {
            this.enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
            this.mensaje = MonitorDePID.idioma.errorConflictoOptiFineFusion() + "<br>";
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ConflictoOptiFineFusion();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 900.0f;
    }

    @Override
    public String mensaje() {
        return this.activado ? this.mensaje + this.enlaceHtml : "";
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreDeConflictoOptiFineFusion();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.pasoConflictoOptiFineFusion()).construir();
    }

    @Override
    public String id() {
        return "conflicto_optifine_fusion";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        String t = trazo.trace;
        return t.contains("Critical injection failure") && t.contains("net/minecraft/client/renderer/entity/EntityRenderDispatcher") && t.contains("fusion.mixins.json") && t.contains("EntityRenderDispatcherMixin") && t.contains("renderTail") && this.encontradoOptiFine;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

