/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.analizador.Criticalidad;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorCurseForgeApp;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;

public class CursedConsola
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = MonitorDePID.idioma.noTieneConsolaDeLauncherCursedForge();
    private static final String CURSEFORGE_MARKER = "curseforge";
    private static final String INSTANCE_MARKER = "instances";
    private static final String LAUNCHER_LOG = "launcher_log";

    @Override
    public void verificar(Consola consolaog) {
        if (Statics.lanzer_del_app != null && Statics.lanzer_del_app.equals(DetectorCurseForgeApp.ID)) {
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new CursedConsola();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1000.0f;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_de_cursed_consola();
    }

    @Override
    public QuickFix solucion() {
        return QuickFix.NINGUN;
    }

    @Override
    public Criticalidad nivel_de_criticalidad() {
        return Criticalidad.ADVERTENCIA;
    }

    @Override
    public String id() {
        return "cursedconsola";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

