/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;

public class EarlyWindow
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private String enlaceHtml = "";

    @Override
    public void verificar(Consola consola) {
        String contenidoConsola = consola.contenido_verificar;
        String[] lineas = contenidoConsola.split(Verificaciones.nl);
        if (lineas.length == 0) {
            return;
        }
        String ultimaLinea = null;
        int indiceUltimaLinea = -1;
        for (int i = lineas.length - 1; i >= 0; --i) {
            String linea = lineas[i].trim();
            if (linea.isEmpty()) continue;
            ultimaLinea = linea;
            indiceUltimaLinea = i;
            break;
        }
        String falloInicializacion = "Failed to initialize the mod loading system and display.";
        String falloInicializacionActual = "Failed to initialize graphics window with current settings.";
        if (ultimaLinea != null && ultimaLinea.contains("Loading ImmediateWindowProvider fmlearlywindow")) {
            this.mensaje = MonitorDePID.idioma.fmlEarlyWindow() + "<br>";
            this.enlaceHtml = consola.agregarErrorALectador(indiceUltimaLinea, this);
            this.activado = true;
        } else if (contenidoConsola.contains("Failed to initialize the mod loading system and display.") || contenidoConsola.contains("Failed to initialize graphics window with current settings.")) {
            this.mensaje = MonitorDePID.idioma.fmlEarlyWindow() + "<br>";
            this.activado = true;
        }
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
    }

    @Override
    public Verificaciones nueva() {
        return new EarlyWindow();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 800.0f;
    }

    @Override
    public String mensaje() {
        if (!this.activado) {
            return "";
        }
        return this.mensaje + this.enlaceHtml;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_de_early_window();
    }

    @Override
    public QuickFix solucion() {
        return QuickFix.NINGUN;
    }

    @Override
    public boolean recomendadoParaCorperata() {
        return true;
    }

    @Override
    public String id() {
        return "earlywindow";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        String t = trazo.trace;
        if (t.contains("Loading ImmediateWindowProvider fmlearlywindow")) {
            return true;
        }
        return t.contains("Failed to initialize the mod loading system and display.");
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

