/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ErrorAccessTransformerInvalido
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private String nombreJar = "";
    private String enlaceHtml = "";

    @Override
    public void verificar(Consola consola) {
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        Pattern pattern;
        Matcher matcher;
        if (this.activado) {
            return;
        }
        if (linea.contains("Invalid access transformer line in") && (matcher = (pattern = Pattern.compile("Invalid access transformer line in ([^:]+):")).matcher(linea)).find()) {
            this.nombreJar = matcher.group(1);
            this.mensaje = MonitorDePID.idioma.errorAccessTransformerInvalido(this.nombreJar) + "<br>";
            this.enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ErrorAccessTransformerInvalido();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 910.0f;
    }

    @Override
    public String mensaje() {
        if (!this.activado) {
            return "";
        }
        return this.mensaje + this.enlaceHtml;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_de_error_access_transformer_invalido();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.paso1_access_transformer_invalido(this.nombreJar)).agregarEtiqueta(MonitorDePID.idioma.paso2_access_transformer_invalido(this.nombreJar)).agregarEtiqueta(MonitorDePID.idioma.paso3_access_transformer_invalido()).construir();
    }

    @Override
    public String id() {
        return "access_transformer_invalido";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        String t = trazo.trace;
        if (!this.nombreJar.isEmpty()) {
            return t.contains("Invalid access transformer line in") && t.contains(this.nombreJar);
        }
        return t.contains("Invalid access transformer line in");
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

