/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ErrorCargaClaseEntornoInvalido
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private String nombreClase = "";
    private String entornoInvalido = "";
    private String enlaceHtml = "";

    @Override
    public void verificar(Consola consola) {
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        Pattern pattern;
        Matcher matcher;
        if (this.activado) {
            return;
        }
        if (linea.contains("Attempted to load class") && linea.contains("for invalid dist") && (matcher = (pattern = Pattern.compile("Attempted to load class\\s+([^ ]+)\\s+for invalid dist\\s+([A-Z_]+)")).matcher(linea)).find()) {
            this.nombreClase = matcher.group(1);
            this.entornoInvalido = matcher.group(2);
            this.mensaje = MonitorDePID.idioma.errorModEnPlataformaIncorrecta(this.nombreClase, this.entornoInvalido) + "<br>";
            this.enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ErrorCargaClaseEntornoInvalido();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1400.0f;
    }

    @Override
    public String mensaje() {
        if (!this.activado) {
            return "";
        }
        return this.mensaje + this.enlaceHtml;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_de_error_mod_plataforma_incorrecta();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.paso1_mod_plataforma_incorrecta(this.nombreClase, this.entornoInvalido)).agregarEtiqueta(MonitorDePID.idioma.paso2_mod_plataforma_incorrecta(this.entornoInvalido)).agregarEtiqueta(MonitorDePID.idioma.paso3_mod_plataforma_incorrecta()).construir();
    }

    @Override
    public String id() {
        return "error_carga_clase_entorno_invalido";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        String t = trazo.trace;
        if (!this.nombreClase.isEmpty() && !this.entornoInvalido.isEmpty()) {
            String esperado = "Attempted to load class " + this.nombreClase + " for invalid dist " + this.entornoInvalido;
            return t.contains(esperado);
        }
        return t.contains("Attempted to load class") && t.contains("for invalid dist");
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

