/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;

public class ErrorClaveRegistroMayusculas
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";

    @Override
    public void verificar(Consola consola) {
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (this.activado || linea == null) {
            return;
        }
        if (linea.contains("java.lang.IllegalStateException") && linea.contains("key must be lowercase:")) {
            String clave;
            int idx = linea.indexOf("key must be lowercase:");
            String string = clave = idx != -1 ? linea.substring(idx + 22).trim() : "clave desconocida";
            if (clave.length() > 256) {
                clave = clave.substring(0, 256) + "...";
            }
            this.activado = true;
            String enlace = consola.agregarErrorALectador(numero_de_linea, this);
            this.mensaje = MonitorDePID.idioma.error_clave_registro_mayusculas_html(clave) + (enlace.isEmpty() ? "" : " " + enlace);
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ErrorClaveRegistroMayusculas();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 920.0f;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_error_clave_registro_mayusculas();
    }

    @Override
    public QuickFix solucion() {
        QuickFix.Builder builder = new QuickFix.Builder(this.nombre());
        builder.agregarEtiqueta(MonitorDePID.idioma.solucion_buscar_clave_en_archivos());
        builder.agregarEtiqueta(MonitorDePID.idioma.solucion_eliminar_mod_reciente());
        return builder.construir();
    }

    @Override
    public String id() {
        return "error_clave_registro_mayusculas";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

