/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ErrorConfiguracionMCForge
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private String enlaceHtml = "";
    private String detalleArchivoHtml = "";
    private String listaArchivosVaciosHtml = "";
    private static final Pattern P_FALLO_CARGA_CONFIG = Pattern.compile("(?:ConfigFileTypeHandler|ConfigSpecWrapper)\\$ConfigLoadingException:\\s*Failed\\s+loading\\s+config\\s+file\\s+([^\\s]+)\\s+of\\s+type\\s+[^\\s]+\\s+for\\s+modid\\s+([^\\s]+)", 2);
    private static final String PARSING_EXCEPTION = "ParsingException: Not enough data available";
    private static final String CFG_HANDLER = "ConfigFileTypeHandler$ConfigLoadingException:";
    private static final String CFG_WRAPPER = "ConfigSpecWrapper$ConfigLoadingException:";
    private static final String CFG_FAILED = "Failed loading config file";

    @Override
    public void verificar(Consola consola) {
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        Matcher m;
        if (!this.activado) {
            if (linea.contains(PARSING_EXCEPTION)) {
                this.mensaje = MonitorDePID.idioma.errorConfigMCForge() + "<br>";
                this.enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
                this.activado = true;
                this.generarListaArchivosVacios();
            } else if ((linea.contains(CFG_HANDLER) || linea.contains(CFG_WRAPPER)) && linea.contains(CFG_FAILED)) {
                this.mensaje = MonitorDePID.idioma.errorConfigMCForge() + "<br>";
                this.enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
                this.activado = true;
                this.generarListaArchivosVacios();
            }
        }
        if ((this.detalleArchivoHtml == null || this.detalleArchivoHtml.isEmpty()) && (linea.contains(CFG_HANDLER) || linea.contains(CFG_WRAPPER)) && linea.contains(CFG_FAILED) && (m = P_FALLO_CARGA_CONFIG.matcher(linea)).find()) {
            String archivo = m.group(1);
            String modid = m.group(2);
            String enlaceDetalle = consola.agregarErrorALectador(numero_de_linea, this);
            this.detalleArchivoHtml = "<b>" + archivo + "</b> (modid: <code>" + modid + "</code>). " + enlaceDetalle;
        }
    }

    private void generarListaArchivosVacios() {
        File carpetaConfig = new File("config");
        if (!carpetaConfig.exists() || !carpetaConfig.isDirectory()) {
            this.listaArchivosVaciosHtml = "";
            return;
        }
        ArrayList<String> archivosVacios = new ArrayList<String>();
        this.listarArchivosVaciosRecursivo(carpetaConfig, carpetaConfig, archivosVacios);
        if (!archivosVacios.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("<br>");
            sb.append("<ul>");
            for (String relPath : archivosVacios) {
                sb.append("<li><code>").append(relPath).append("</code></li>");
            }
            sb.append("</ul>");
            this.listaArchivosVaciosHtml = sb.toString();
        } else {
            this.listaArchivosVaciosHtml = "";
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void listarArchivosVaciosRecursivo(File raiz, File actual, List<String> acumulador) {
        if (actual.isDirectory()) {
            File[] hijos = actual.listFiles();
            if (hijos == null) return;
            for (File hijo : hijos) {
                this.listarArchivosVaciosRecursivo(raiz, hijo, acumulador);
            }
            return;
        } else {
            if (!actual.isFile()) return;
            try {
                if (Files.size(actual.toPath()) != 0L) return;
                String relPath = raiz.toURI().relativize(actual.toURI()).getPath();
                acumulador.add(relPath);
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ErrorConfiguracionMCForge();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1100.0f;
    }

    @Override
    public String mensaje() {
        if (!this.activado) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.mensaje);
        if (!this.listaArchivosVaciosHtml.isEmpty()) {
            sb.append(this.listaArchivosVaciosHtml).append("<br>");
        }
        sb.append(this.enlaceHtml);
        if (this.detalleArchivoHtml != null && !this.detalleArchivoHtml.isEmpty()) {
            sb.append("<br>").append(this.detalleArchivoHtml);
        }
        return sb.toString();
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_de_error_de_config_mcforge();
    }

    @Override
    public QuickFix solucion() {
        return QuickFix.NINGUN;
    }

    @Override
    public String id() {
        return "config_mcforge";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        String t = trazo.trace;
        if (t.contains(PARSING_EXCEPTION)) {
            return true;
        }
        return (t.contains(CFG_HANDLER) || t.contains(CFG_WRAPPER)) && t.contains(CFG_FAILED);
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }

    @Override
    public boolean recomendadoParaCorperata() {
        return true;
    }
}

