/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.buscar.ArchivoDeMod;
import com.asbestosstar.crashdetector.buscar.Buscardor;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ErrorConfiguracionServicioIDependencyLocator
implements Verificaciones {
    private static final String PATRON_ERROR = "Caused by: java\\.util\\.ServiceConfigurationError: .*IDependencyLocator: Unable to load ([^\\s]+)";
    private boolean activado = false;
    private String mensaje = "";
    private String claseProblematica = "";
    private List<String> modsUbicacion = new ArrayList<String>();
    private String enlaceHtml = "";

    @Override
    public void verificar(Consola consola) {
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        Pattern patron;
        Matcher matcher;
        if (this.activado) {
            return;
        }
        if (linea.contains("ServiceConfigurationError") && linea.contains("IDependencyLocator") && (matcher = (patron = Pattern.compile(PATRON_ERROR)).matcher(linea)).find()) {
            this.claseProblematica = matcher.group(1);
            String classPath = this.claseProblematica.replace('.', '/') + ".class";
            List<ArchivoDeMod> mods = Buscardor.buscarModsConTermino(classPath);
            for (ArchivoDeMod mod : mods) {
                this.modsUbicacion.add(mod.ubicacion_para_publicar());
            }
            this.enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
            this.activado = true;
            this.mensaje = MonitorDePID.idioma.errorConfiguracionServicio(this.claseProblematica, this.modsUbicacion.isEmpty() ? null : this.modsUbicacion) + "<br>" + this.enlaceHtml;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ErrorConfiguracionServicioIDependencyLocator();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1300.0f;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_error_configuracion_servicio();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.paso1_configuracion_servicio(this.modsUbicacion)).agregarEtiqueta(MonitorDePID.idioma.paso2_configuracion_servicio()).construir();
    }

    @Override
    public String id() {
        return "error_configuracion_servicio";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        String t = trazo.trace;
        if (this.claseProblematica != null && !this.claseProblematica.isEmpty()) {
            return t.contains("ServiceConfigurationError") && t.contains("IDependencyLocator") && t.contains(this.claseProblematica);
        }
        return t.contains("ServiceConfigurationError") && t.contains("IDependencyLocator") && t.contains("Unable to load");
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

