/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ErrorCreacionModeloFallida
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private static final Pattern PATRON_MODELO_FALLIDO = Pattern.compile("java\\.lang\\.IllegalStateException: Failed to create model for ([^:\\s]+):([^\\s]+)");

    @Override
    public void verificar(Consola consola) {
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (this.activado) {
            return;
        }
        Matcher m = PATRON_MODELO_FALLIDO.matcher(linea);
        if (m.find()) {
            String modid = m.group(1);
            String nombreModelo = m.group(2);
            String enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
            this.mensaje = MonitorDePID.idioma.errorCreacionModeloFallida(modid, nombreModelo) + enlaceHtml;
            this.activado = true;
        }
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return PATRON_MODELO_FALLIDO.matcher(trazo.trace).find();
    }

    @Override
    public Verificaciones nueva() {
        return new ErrorCreacionModeloFallida();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public float prioridad() {
        return 790.0f;
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.solucionErrorCreacionModeloFallida()).construir();
    }

    @Override
    public String id() {
        return "creacion_modelo_fallida";
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreErrorCreacionModeloFallida();
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

