/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ErrorDiscrepanciaModID
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private String rutaMod = "";
    private String nombreMod = "";
    private String enlaceHtml = "";

    @Override
    public void verificar(Consola consola) {
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        Pattern pattern;
        Matcher matcher;
        if (this.activado) {
            return;
        }
        if (linea.contains("has mods that were not found") && (matcher = (pattern = Pattern.compile("The Mod File (.+) has mods that were not found")).matcher(linea)).find()) {
            this.rutaMod = matcher.group(1);
            this.nombreMod = this.rutaMod.contains("\\") ? this.rutaMod.substring(this.rutaMod.lastIndexOf("\\") + 1) : (this.rutaMod.contains("/") ? this.rutaMod.substring(this.rutaMod.lastIndexOf("/") + 1) : this.rutaMod);
            this.mensaje = MonitorDePID.idioma.errorDiscrepanciaModID(this.nombreMod) + "<br>";
            this.enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ErrorDiscrepanciaModID();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 940.0f;
    }

    @Override
    public String mensaje() {
        if (!this.activado) {
            return "";
        }
        return this.mensaje + this.enlaceHtml;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_de_error_discrepancia_mod_id();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.paso1_discrepancia_mod_id(this.nombreMod)).agregarEtiqueta(MonitorDePID.idioma.paso2_discrepancia_mod_id()).agregarEtiqueta(MonitorDePID.idioma.paso3_discrepancia_mod_id()).construir();
    }

    @Override
    public String id() {
        return "discrepancia_modid";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        String t = trazo.trace;
        if (this.rutaMod != null && !this.rutaMod.isEmpty()) {
            String esperado = "The Mod File " + this.rutaMod + " has mods that were not found";
            return t.contains(esperado);
        }
        return t.contains("The Mod File ") && t.contains(" has mods that were not found");
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

