/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;

public class ErrorEnGarde
implements Verificaciones {
    private boolean activado = false;
    private String enlaceHtml = "";

    @Override
    public void verificar(Consola consola) {
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (this.activado || linea == null) {
            return;
        }
        if (linea.contains("handler$") && linea.contains("$en_garde$")) {
            this.activado = true;
            this.enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ErrorEnGarde();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1500.0f;
    }

    @Override
    public String mensaje() {
        if (!this.activado) {
            return "";
        }
        return MonitorDePID.idioma.error_en_garde_html() + (this.enlaceHtml.isEmpty() ? "" : " " + this.enlaceHtml);
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_error_en_garde();
    }

    @Override
    public QuickFix solucion() {
        QuickFix.Builder builder = new QuickFix.Builder(this.nombre());
        builder.agregarEtiqueta(MonitorDePID.idioma.solucion_actualizar_en_garde());
        builder.agregarEtiqueta(MonitorDePID.idioma.solucion_eliminar_conflicto_mod_combate());
        return builder.construir();
    }

    @Override
    public String id() {
        return "error_en_garde";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

