/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;

public class ErrorEntityTextureFeaturesServidor
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private String enlaceHtml = "";
    private boolean encontradoETF = false;

    @Override
    public void verificar(Consola consola) {
        if (consola.contenido_verificar != null) {
            this.encontradoETF = consola.contenido_verificar.toLowerCase().contains("$entity_texture_features$") || consola.contenido_verificar.contains("$etf$");
        }
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (this.activado) {
            return;
        }
        if (linea.contains("Attempted to load class") && linea.contains("net/minecraft/client/gui/screens/Screen") && linea.contains("for invalid dist DEDICATED_SERVER") && this.encontradoETF) {
            this.enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
            this.mensaje = MonitorDePID.idioma.errorEntityTextureFeaturesServidor() + "<br>";
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ErrorEntityTextureFeaturesServidor();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 950.0f;
    }

    @Override
    public String mensaje() {
        return this.activado ? this.mensaje + this.enlaceHtml : "";
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreDeErrorEntityTextureFeaturesServidor();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.pasoErrorEntityTextureFeaturesServidor()).construir();
    }

    @Override
    public String id() {
        return "error_etf_servidor";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        String t = trazo.trace;
        return t.contains("Attempted to load class") && t.contains("net/minecraft/client/gui/screens/Screen") && t.contains("for invalid dist DEDICATED_SERVER") && (t.contains("entity texture features") || t.contains("etf") || t.contains("ResourceLocation.handler$zca000$etf$illegalPathOverride"));
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

