/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;

public class ErrorGroovyModloaderModuloFaltante
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private String enlaceHtml = "";
    private boolean encontradoGML = false;

    @Override
    public void verificar(Consola consola) {
        if (consola.contenido_verificar != null) {
            String contenido = consola.contenido_verificar.toLowerCase();
            this.encontradoGML = contenido.contains("groovy") || contenido.contains("gml");
        }
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (this.activado) {
            return;
        }
        if (linea.contains("java.lang.module.FindException") && linea.contains("Module com.fasterxml.jackson.core not found") && linea.contains("required by com.fasterxml.jackson") && this.encontradoGML) {
            this.enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
            this.mensaje = MonitorDePID.idioma.errorGroovyModloaderModuloFaltante() + "<br>";
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ErrorGroovyModloaderModuloFaltante();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1400.0f;
    }

    @Override
    public String mensaje() {
        return this.activado ? this.mensaje + this.enlaceHtml : "";
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreDeErrorGroovyModloaderModuloFaltante();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.pasoErrorGroovyModloaderModuloFaltante()).construir();
    }

    @Override
    public String id() {
        return "error_gml_modulo_faltante";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        String t = trazo.trace;
        return t.contains("java.lang.module.FindException") && t.contains("Module com.fasterxml.jackson.core not found") && t.contains("required by com.fasterxml.jackson.module.paramnames") && (t.toLowerCase().contains("groovy modloader") || t.toLowerCase().contains("valkyrien") || t.toLowerCase().contains("valkerian") || t.toLowerCase().contains("gml"));
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

