/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;

public class ErrorHealightINT
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";

    @Override
    public void verificar(Consola consola) {
        String contenido = consola.contenido_verificar;
        if (contenido.contains("java.lang.NoSuchFieldError: INT") && (contenido.contains("LivingEntity.<clinit>") || contenido.contains("EntityType.<clinit>") || contenido.contains("net.minecraft.world.entity")) && contenido.contains("healight")) {
            this.mensaje = MonitorDePID.idioma.errorHealightINT();
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ErrorHealightINT();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    public String obtenerMensaje() {
        return this.mensaje;
    }

    @Override
    public float prioridad() {
        return 900.0f;
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.solucionHealightINT()).construir();
    }

    @Override
    public String id() {
        return "error_healight_int";
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreErrorHealightINT();
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        String contenido = trazo.trace;
        return contenido.contains("java.lang.NoSuchFieldError: INT") && (contenido.contains("LivingEntity.<clinit>") || contenido.contains("EntityType.<clinit>") || contenido.contains("net.minecraft.world.entity"));
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

