/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ErrorJEIPluginFallido
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private String nombreClase = "";
    private String modId = "";
    private String pluginId = "";
    private String enlaceHtml = "";

    @Override
    public void verificar(Consola consola) {
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        Pattern pattern;
        Matcher matcher;
        if (this.activado) {
            return;
        }
        if (linea.contains("Caught an error from mod plugin: class") && (matcher = (pattern = Pattern.compile("Caught an error from mod plugin: class ([^ ]+) ([^:]+):([^ ]+)")).matcher(linea)).find()) {
            this.nombreClase = matcher.group(1);
            this.modId = matcher.group(2);
            this.pluginId = matcher.group(3);
            this.mensaje = MonitorDePID.idioma.errorJEIPluginFallido(this.nombreClase, this.modId, this.pluginId) + "<br>";
            this.enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ErrorJEIPluginFallido();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 950.0f;
    }

    @Override
    public String mensaje() {
        if (!this.activado) {
            return "";
        }
        return this.mensaje + this.enlaceHtml;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_de_error_jei_plugin_fallido();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.paso1_jei_plugin_fallido(this.modId)).agregarEtiqueta(MonitorDePID.idioma.paso2_jei_plugin_fallido(this.modId)).agregarEtiqueta(MonitorDePID.idioma.paso3_jei_plugin_fallido(this.modId)).construir();
    }

    @Override
    public String id() {
        return "jei_plugin_fallido";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        String t = trazo.trace;
        if (!(this.nombreClase.isEmpty() || this.modId.isEmpty() || this.pluginId.isEmpty())) {
            String esperado = "Caught an error from mod plugin: class " + this.nombreClase + " " + this.modId + ":" + this.pluginId;
            return t.contains(esperado);
        }
        return t.contains("Caught an error from mod plugin: class") && t.contains("JEI");
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

