/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;

public class ErrorMetadataAnimacionEnServidor
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";

    @Override
    public void verificar(Consola consola) {
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (this.activado) {
            return;
        }
        String contenidoCompleto = consola.contenido_verificar;
        if (linea.contains("org.spongepowered.asm.mixin.throwables.ClassMetadataNotFoundException") && linea.contains("net.minecraft.client.resources.metadata.animation.AnimationMetadataSection")) {
            boolean esServidor;
            boolean modernFixPresente = contenidoCompleto.contains("Loaded configuration file for ModernFix");
            boolean bl = esServidor = contenidoCompleto.contains("Launching target 'forgeserver'") || contenidoCompleto.contains("DEDICATED_SERVER");
            if (modernFixPresente && esServidor) {
                String enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
                this.mensaje = MonitorDePID.idioma.errorMetadataAnimacionEnServidor() + enlaceHtml;
                this.activado = true;
            }
        }
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        String t = trazo.trace;
        return t.contains("ClassMetadataNotFoundException") && t.contains("AnimationMetadataSection");
    }

    @Override
    public Verificaciones nueva() {
        return new ErrorMetadataAnimacionEnServidor();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public float prioridad() {
        return 1200.0f;
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.solucionErrorMetadataAnimacionEnServidor()).construir();
    }

    @Override
    public String id() {
        return "metadata_animacion_en_servidor";
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreErrorMetadataAnimacionEnServidor();
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

