/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.buscar.Buscardor;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ErrorMetadataModsTomlFaltante
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private String modIdFaltante = "";
    private List<String> modsPotenciales = null;
    private String enlaceHtml = "";

    @Override
    public void verificar(Consola consola) {
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        Pattern pattern;
        Matcher matcher;
        if (this.activado) {
            return;
        }
        if (linea.contains("mods.toml missing metadata for modid") && (matcher = (pattern = Pattern.compile("mods\\.toml missing metadata for modid (\\w+)")).matcher(linea)).find()) {
            this.modIdFaltante = matcher.group(1);
            this.modsPotenciales = Buscardor.obtenerModsConNombre(this.modIdFaltante);
            this.mensaje = MonitorDePID.idioma.errorMetadataModsTomlFaltante(this.modIdFaltante, this.modsPotenciales) + "<br>";
            this.enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ErrorMetadataModsTomlFaltante();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 925.0f;
    }

    @Override
    public String mensaje() {
        if (!this.activado) {
            return "";
        }
        return this.mensaje + this.enlaceHtml;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_de_error_metadata_mods_toml_faltante();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.paso1_metadata_mods_toml_faltante(this.modIdFaltante, this.modsPotenciales)).agregarEtiqueta(MonitorDePID.idioma.paso2_metadata_mods_toml_faltante(this.modIdFaltante)).agregarEtiqueta(MonitorDePID.idioma.paso3_metadata_mods_toml_faltante(this.modIdFaltante)).construir();
    }

    @Override
    public String id() {
        return "metadata_mods_toml_faltante";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        String t = trazo.trace;
        if (this.modIdFaltante != null && !this.modIdFaltante.isEmpty()) {
            String esperado = "mods.toml missing metadata for modid " + this.modIdFaltante;
            return t.contains(esperado);
        }
        return t.contains("mods.toml missing metadata for modid ");
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

