/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;

public class ErrorModLauncherTransformationService
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private String enlaceHtml = "";
    private String claseProveedor = "";

    @Override
    public void verificar(Consola consola) {
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (this.activado) {
            return;
        }
        if (linea.contains("java.util.ServiceConfigurationError") && linea.contains("cpw.mods.modlauncher.api.ITransformationService") && linea.contains("Provider") && linea.contains("could not be instantiated")) {
            int inicioClase = linea.indexOf("Provider ") + "Provider ".length();
            int finClase = linea.indexOf(" could not be instantiated");
            if (inicioClase > -1 && finClase > inicioClase) {
                this.claseProveedor = linea.substring(inicioClase, finClase).trim();
            } else {
                String[] partes = linea.split(" ");
                for (int i = 0; i < partes.length; ++i) {
                    if (!partes[i].contains("TransformationService") || partes[i].contains("ITransformationService")) continue;
                    this.claseProveedor = partes[i].replace(",", "").replace(":", "").trim();
                    break;
                }
            }
            this.enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
            this.mensaje = MonitorDePID.idioma.errorModLauncherTransformationService(this.claseProveedor) + "<br>";
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ErrorModLauncherTransformationService();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1000.0f;
    }

    @Override
    public String mensaje() {
        return this.activado ? this.mensaje + this.enlaceHtml : "";
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreDeErrorModLauncherTransformationService();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.pasoErrorModLauncherTransformationService(this.claseProveedor)).construir();
    }

    @Override
    public String id() {
        return "error_modlauncher_transformation_service";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        String t = trazo.trace;
        return t.contains("java.util.ServiceConfigurationError") && t.contains("cpw.mods.modlauncher.api.ITransformationService") && t.contains("Provider") && t.contains("could not be instantiated");
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

