/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.buscar.ArchivoDeMod;
import com.asbestosstar.crashdetector.buscar.Buscardor;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ErrorRegistroSuscriptoresAutomaticos
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private String modId = "";
    private String nombreClase = "";
    private List<String> modsUbicacion = new ArrayList<String>();
    private String enlaceHtml = "";

    @Override
    public void verificar(Consola consola) {
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        Pattern pattern;
        Matcher matcher;
        if (this.activado) {
            return;
        }
        if (linea.contains("Failed to register automatic subscribers. ModID:") && (matcher = (pattern = Pattern.compile("Failed to register automatic subscribers\\. ModID: ([^,]+), class ([^\\s]+)")).matcher(linea)).find()) {
            this.modId = matcher.group(1).trim();
            this.nombreClase = matcher.group(2).trim();
            String classPath = this.nombreClase.replace('.', '/') + ".class";
            List<ArchivoDeMod> modsPotenciales = Buscardor.buscarModsConTermino(classPath);
            for (ArchivoDeMod mod : modsPotenciales) {
                this.modsUbicacion.add(mod.ubicacion_para_publicar());
            }
            this.mensaje = MonitorDePID.idioma.errorRegistroSuscriptoresAutomaticos(this.modId, this.nombreClase, this.modsUbicacion) + "<br>";
            this.enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ErrorRegistroSuscriptoresAutomaticos();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 900.0f;
    }

    @Override
    public String mensaje() {
        if (!this.activado) {
            return "";
        }
        return this.mensaje + this.enlaceHtml;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_de_error_registro_suscriptores_automaticos();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.paso1_registro_suscriptores_automaticos(this.modId, this.nombreClase)).agregarEtiqueta(MonitorDePID.idioma.paso2_registro_suscriptores_automaticos(this.modId, this.nombreClase, this.modsUbicacion)).agregarEtiqueta(MonitorDePID.idioma.paso3_registro_suscriptores_automaticos(this.modId)).agregarEtiqueta(MonitorDePID.idioma.paso4_registro_suscriptores_automaticos()).construir();
    }

    @Override
    public String id() {
        return "registro_subscriptores_automaticos";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        String t = trazo.trace;
        if (!this.modId.isEmpty() && !this.nombreClase.isEmpty()) {
            String esperado = "Failed to register automatic subscribers. ModID: " + this.modId + ", class " + this.nombreClase;
            return t.contains(esperado);
        }
        return t.contains("Failed to register automatic subscribers. ModID:");
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

