/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ErrorResolucionDeTextura
implements Verificaciones {
    private static final Pattern ERRORES_RESOLUCION = Pattern.compile("net\\.minecraft\\.client\\.renderer\\.texture\\.StitcherException:\\s*Unable to fit:\\s*([^\\s]+)\\s*-\\s*size:\\s*(\\d+x\\d+)(?:\\s*-\\s*Maybe try a lower resolution resourcepack\\?)?", 2);
    private static final String NL = Verificaciones.nl;
    private final Map<String, String> errores = new HashMap<String, String>();
    private boolean activado = false;
    private final Map<String, String> enlacesPorLinea = new HashMap<String, String>();

    @Override
    public void verificar(Consola consola) {
        this.errores.clear();
        this.enlacesPorLinea.clear();
        this.activado = false;
        ArrayList<VerificacionDeStackTrace.TraceInfo> trazosInfo = new ArrayList<VerificacionDeStackTrace.TraceInfo>();
        trazosInfo.addAll(VerificacionDeStackTrace.obtenerTracesConLinea(consola.contenido_verificar));
        trazosInfo.addAll(VerificacionDeStackTrace.obtenerTracesFatalConLinea(consola.contenido_verificar));
        for (VerificacionDeStackTrace.TraceInfo traceInfo : trazosInfo) {
            Matcher matcher;
            String trazo = traceInfo.trace;
            if (!trazo.contains("Unable to fit:") || !trazo.contains("Maybe try a lower resolution resourcepack?") || !(matcher = ERRORES_RESOLUCION.matcher(trazo)).find()) continue;
            String recurso = matcher.group(1);
            String tama\u00f1o = matcher.group(2);
            String mensajeBase = MonitorDePID.idioma.error_resolucion_textura(recurso, tama\u00f1o);
            this.enlacesPorLinea.putIfAbsent(mensajeBase, consola.agregarErrorALectador(traceInfo.consolaLineaComenzar, this));
            this.errores.put(mensajeBase, "");
            this.activado = true;
        }
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (!linea.contains("Unable to fit:") || !linea.contains("Maybe try a lower resolution resourcepack?") || linea.contains("at ") || !VerificacionDeStackTrace.tracePermite(linea)) {
            return;
        }
        this.procesarLineaSinTraza(linea, numero_de_linea, consola);
    }

    private void procesarLineaSinTraza(String linea, int numeroLinea, Consola consola) {
        Matcher matcher = ERRORES_RESOLUCION.matcher(linea);
        if (!matcher.find()) {
            return;
        }
        String recurso = matcher.group(1);
        String tama\u00f1o = matcher.group(2);
        String mensajeBase = MonitorDePID.idioma.error_resolucion_textura(recurso, tama\u00f1o);
        this.enlacesPorLinea.put(mensajeBase, consola.agregarErrorALectador(numeroLinea, this));
        this.errores.put(mensajeBase, "");
        this.activado = true;
    }

    @Override
    public Verificaciones nueva() {
        return new ErrorResolucionDeTextura();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1400.0f;
    }

    @Override
    public String mensaje() {
        if (this.errores.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder("<ul>");
        for (String mensajeBase : this.errores.keySet()) {
            String enlace = this.enlacesPorLinea.getOrDefault(mensajeBase, "");
            if (!enlace.isEmpty()) {
                sb.append("<li>").append(mensajeBase).append(MonitorDePID.idioma.solucion_resolucion_textura()).append(" ").append(enlace).append("</li>");
                continue;
            }
            sb.append("<li>").append(mensajeBase).append("</li>");
        }
        sb.append("</ul>");
        return sb.toString();
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_de_error_resolucion_textura();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.solucion_resolucion_textura()).construir();
    }

    @Override
    public String id() {
        return "error_resolucion_de_textura";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        return ERRORES_RESOLUCION.matcher(trazo.trace).find();
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }

    @Override
    public boolean recomendadoParaCorperata() {
        return true;
    }
}

