/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.HashMap;
import java.util.Map;

public class ErrorRutaModLauncher
implements Verificaciones {
    private static final String NL = Verificaciones.nl;
    private final Map<String, String> errores = new HashMap<String, String>();
    private boolean activado = false;
    private final Map<String, String> enlacesPorLinea = new HashMap<String, String>();
    boolean no_UnixUriUtils = false;

    @Override
    public void verificar(Consola consola) {
        String contenido = consola.contenido_verificar;
        if (!contenido.contains("java.lang.IllegalArgumentException: Bad escape") || !contenido.contains("sun.nio.fs.UnixUriUtils.fromUri")) {
            this.no_UnixUriUtils = true;
        }
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (!this.no_UnixUriUtils) {
            return;
        }
        if (!linea.contains("java.lang.IllegalArgumentException: Bad escape")) {
            return;
        }
        String mensajeBase = MonitorDePID.idioma.error_modlauncher_path();
        if (!this.enlacesPorLinea.containsKey(mensajeBase)) {
            String enlace = consola.agregarErrorALectador(numero_de_linea, this);
            this.enlacesPorLinea.put(mensajeBase, enlace);
        }
        this.errores.put(mensajeBase, "");
        this.activado = true;
    }

    @Override
    public Verificaciones nueva() {
        return new ErrorRutaModLauncher();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1000.0f;
    }

    @Override
    public String mensaje() {
        if (this.errores.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder("<ul>");
        for (String mensajeBase : this.errores.keySet()) {
            String enlace = this.enlacesPorLinea.getOrDefault(mensajeBase, "");
            if (!enlace.isEmpty()) {
                sb.append("<li>").append(mensajeBase).append(" ").append(enlace).append("</li>");
                continue;
            }
            sb.append("<li>").append(mensajeBase).append("</li>");
        }
        sb.append("</ul>");
        return sb.toString();
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_error_modlauncher_path();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.solucion_modlauncher_path()).construir();
    }

    @Override
    public String id() {
        return "ruta_modlauncher";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        String t = trazo.trace;
        return t.contains("java.lang.IllegalArgumentException: Bad escape") && t.contains("sun.nio.fs.UnixUriUtils.fromUri");
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }

    @Override
    public boolean recomendadoParaCorperata() {
        return true;
    }
}

