/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.buscar.ArchivoDeMod;
import com.asbestosstar.crashdetector.buscar.Buscardor;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ErrorSinListenersEnClase
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private String nombreClase = "";
    private List<String> modsUbicacion = new ArrayList<String>();
    private String enlaceHtml = "";

    @Override
    public void verificar(Consola consola) {
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        Pattern pattern;
        Matcher matcher;
        if (this.activado) {
            return;
        }
        if (linea.contains("No listeners found in class") && (matcher = (pattern = Pattern.compile("No listeners found in class ([^\\s]+)")).matcher(linea)).find()) {
            this.nombreClase = matcher.group(1);
            String classPath = this.nombreClase.replace('.', '/');
            List<ArchivoDeMod> modsPotenciales = Buscardor.buscarModsConTermino(classPath + ".class");
            for (ArchivoDeMod mod : modsPotenciales) {
                this.modsUbicacion.add(mod.ubicacion_para_publicar());
            }
            this.mensaje = MonitorDePID.idioma.errorSinListenersEnClase(this.nombreClase, this.modsUbicacion) + "<br>";
            this.enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ErrorSinListenersEnClase();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 880.0f;
    }

    @Override
    public String mensaje() {
        if (!this.activado) {
            return "";
        }
        return this.mensaje + this.enlaceHtml;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_de_error_sin_listeners_en_clase();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.paso1_sin_listeners_en_clase(this.nombreClase, this.modsUbicacion)).agregarEtiqueta(MonitorDePID.idioma.paso2_sin_listeners_en_clase(this.nombreClase)).agregarEtiqueta(MonitorDePID.idioma.paso3_sin_listeners_en_clase(this.nombreClase, this.modsUbicacion)).construir();
    }

    @Override
    public String id() {
        return "sin_listeners_en_clase";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        String t = trazo.trace;
        if (this.nombreClase != null && !this.nombreClase.isEmpty()) {
            String esperado = "No listeners found in class " + this.nombreClase;
            return t.contains(esperado);
        }
        return t.contains("No listeners found in class ");
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

