/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ErrorUnionFileSystemCorrupto
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private String nombreArchivo = "un archivo de mod";
    private boolean esModpack = false;
    private String enlaceHtml = "";

    @Override
    public void verificar(Consola consola) {
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (this.activado) {
            return;
        }
        if (linea.contains("cpw.mods.niofs.union.UnionFileSystem$UncheckedIOException") && linea.contains("java.util.zip.ZipException: zip END header not found")) {
            String contenidoConsola = consola.contenido_verificar;
            Pattern pattern = Pattern.compile("at.*?/(.*?\\.jar)");
            Matcher matcher = pattern.matcher(contenidoConsola);
            if (matcher.find()) {
                this.nombreArchivo = matcher.group(1);
            }
            this.mensaje = MonitorDePID.idioma.errorUnionFileSystemCorrupto(this.nombreArchivo) + "<br>";
            this.enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ErrorUnionFileSystemCorrupto();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 965.0f;
    }

    @Override
    public String mensaje() {
        if (!this.activado) {
            return "";
        }
        return this.mensaje + this.enlaceHtml;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_de_error_union_filesystem_corrupto();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.paso1_union_filesystem_corrupto(this.nombreArchivo)).agregarEtiqueta(MonitorDePID.idioma.paso2_union_filesystem_corrupto()).agregarEtiqueta(MonitorDePID.idioma.paso3_union_filesystem_corrupto()).construir();
    }

    @Override
    public String id() {
        return "union_filesystem_corrupto";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        String t = trazo.trace;
        return t.contains("cpw.mods.niofs.union.UnionFileSystem$UncheckedIOException") && t.contains("java.util.zip.ZipException: zip END header not found");
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }

    @Override
    public boolean recomendadoParaCorperata() {
        return true;
    }
}

