/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;

public class ErrorVersionClaseGregTechEasyCore
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private String enlaceHtml = "";
    private boolean encontradoGTECore = false;

    @Override
    public void verificar(Consola consola) {
        if (consola.contenido_verificar != null) {
            this.encontradoGTECore = consola.contenido_verificar.toLowerCase().contains("gtecore");
        }
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (this.activado) {
            return;
        }
        if (linea.contains("java.lang.UnsupportedClassVersionError") && linea.contains("net/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity") && linea.contains("has been compiled by a more recent version of the Java Runtime") && this.encontradoGTECore) {
            this.enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
            this.mensaje = MonitorDePID.idioma.errorVersionClaseGregTechEasyCore() + "<br>";
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ErrorVersionClaseGregTechEasyCore();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1000.0f;
    }

    @Override
    public String mensaje() {
        return this.activado ? this.mensaje + this.enlaceHtml : "";
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreDeErrorVersionClaseGregTechEasyCore();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.pasoErrorVersionClaseGregTechEasyCore()).construir();
    }

    @Override
    public String id() {
        return "error_version_clase_gtecore";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        String t = trazo.trace;
        return t.contains("java.lang.UnsupportedClassVersionError") && t.contains("net/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity") && t.contains("has been compiled by a more recent version of the Java Runtime") && t.toLowerCase().contains("gtecore");
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

