/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;

public class ErrorYesSteveModelLinux
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private String enlaceHtml = "";

    @Override
    public void verificar(Consola consola) {
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (this.activado) {
            return;
        }
        if (linea.contains("java.lang.RuntimeException: Only YSM server is supported on linux.") || linea.contains("Only YSM server is supported on linux")) {
            this.enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
            this.mensaje = MonitorDePID.idioma.errorYesSteveModelLinux() + "<br>";
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ErrorYesSteveModelLinux();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1300.0f;
    }

    @Override
    public String mensaje() {
        return this.activado ? this.mensaje + this.enlaceHtml : "";
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreDeErrorYesSteveModelLinux();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.pasoErrorYesSteveModelLinux()).construir();
    }

    @Override
    public String id() {
        return "error_yessetevemodel_linux";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        String t = trazo.trace;
        return t.contains("java.lang.RuntimeException: Only YSM server is supported on linux.") || t.contains("Only YSM server is supported on linux");
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }

    @Override
    public boolean recomendadoParaCorperata() {
        return true;
    }
}

